/*
 * Copyright (c) 2009, Wei Mingzhi <whistler@openoffice.org>.
 * All Rights Reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */





static Atom wmprotocols, wmdelwindow;
static int initialized=0;

static void InitKeyboard(void) {
	Display *disp = (Display *)gpuDisp;
	if (disp == NULL) {
		fprintf(stderr, "xkb: null display\n");
		exit(1);
	}

	fprintf(stderr,"display:%d",(int)gpuDisp);
	wmprotocols = XInternAtom(disp, "WM_PROTOCOLS", 0);
	wmdelwindow = XInternAtom(disp, "WM_DELETE_WINDOW", 0);

	XkbSetDetectableAutoRepeat(disp, 1, NULL);
	
}

static void DestroyKeyboard(void) {
	Display *disp = (Display *)gpuDisp;
	if (disp)
		XkbSetDetectableAutoRepeat(disp, 0, NULL);
}

void read_x11_keys(void) {
	
	XEvent					evt;
	XClientMessageEvent		*xce;
	unsigned int				Key;
	int leave = 0, psxkey1 = -1, psxkey2 = -1;
	
	int ret;
	
	
	Display *disp = (Display *)gpuDisp;

	

	while (XPending(disp)) {
		XNextEvent(disp, &evt);
		switch (evt.type) {
			case KeyPress:
			case KeyRelease:
				Key=keymap[evt.xkey.keycode];
				//printf("%s %d\n", evt.type == KeyPress ? "press" : "rel  ", Key);
				psxkey1 = -1, psxkey2 = -1;
					if (Key < ARRAY_SIZE(keymap2))
						psxkey1 = keymap2[Key];
					else switch (Key) {
		case 14:
			hildon_quit();
			break;
		case 15:
			psxkey1 = DKEY_UP;
			psxkey2 = DKEY_LEFT;
			break;
		case 16:
			psxkey1 = DKEY_UP;
			psxkey2 = DKEY_RIGHT;
			break;
		case 17:
			psxkey1 = DKEY_DOWN;
			psxkey2 = DKEY_LEFT;
			break;
		case 18:
			psxkey1 = DKEY_DOWN;
			psxkey2 = DKEY_RIGHT;
			break;
		case 19:
			if (evt.type == KeyPress)
				emu_set_action(SACTION_SAVE_STATE);
			return;
		case 20:
			if (evt.type == KeyPress)
				emu_set_action(SACTION_LOAD_STATE);
			return;
	}
				
	if (evt.type == KeyPress) {
		if (psxkey1 >= 0)
			in_keystate |= 1 << psxkey1;
		if (psxkey2 >= 0)
			in_keystate |= 1 << psxkey2;
	}else{
	
		if (psxkey1 >= 0)
			in_keystate &= ~(1 << psxkey1);
		if (psxkey2 >= 0)
			in_keystate &= ~(1 << psxkey2);

		emu_set_action(SACTION_NONE);
	
	}
					

				break;

			case ClientMessage:
				xce = (XClientMessageEvent *)&evt;
				if (xce->message_type == wmprotocols && (Atom)xce->data.l[0] == wmdelwindow)
					leave = 1;
				break;
		}
	}

	if (leave) {
		DestroyKeyboard();
		exit(1);
	}

	return;
}
