/*
 * Copyright (c) 2009 Nokia Corporation
 * Contact: integration@maemo.org
 *
 * Authors: Walter Guerra <walter.guerra@signove.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 */

#ifndef __NM_FILE_DIALOG_H__
#define __NM_FILE_DIALOG_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>

#include "nm_conn_widget.h"

G_BEGIN_DECLS

#define NM_FILE_DIALOG_PATHS            "EXPORT_PATHS"
#define NM_FILE_DIALOG_IPS              "ALLOWED_IPS"

#define NM_FILE_DIALOG_FOLDER_DIALOG    0
#define NM_FILE_DIALOG_TEXT_DIALOG      1

#define NM_FILE_DIALOG_TYPE            (nm_file_dialog_get_type ())
#define NM_FILE_DIALOG(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), NM_FILE_DIALOG_TYPE, NmFileDialog))
#define NM_FILE_DIALOG_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), NM_FILE_DIALOG_TYPE, NmFileDialogClass))
#define IS_NM_FILE_DIALOG(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), NM_FILE_DIALOG_TYPE))
#define IS_NM_FILE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), NM_FILE_DIALOG_TYPE))
#define NM_FILE_DIALOG_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), NM_FILE_DIALOG_TYPE, NmFileDialogClass))

typedef struct _NmFileDialog      NmFileDialog;
typedef struct _NmFileDialogClass NmFileDialogClass;

struct _NmFileDialogClass
{
    GtkDialogClass parent_class;
};

struct _NmFileDialog
{
    GtkDialog parent;
};


GtkWidget* nm_file_dialog_new (gchar *env, gchar *group, gint type);
GType nm_file_dialog_get_type ();
gchar** nm_file_dialog_get_list(NmFileDialog *, gsize *);
void nm_file_dialog_show_dialog(NmFileDialog *);

G_END_DECLS

#endif /* __NM_FILE_DIALOG_H__ */
