#include "qossoabookdialog.h"
#include <QDebug>
#include <QMessageBox>
#include <QtDebug>

QOssoABookDialog::QOssoABookDialog(QObject *parent) :
    QObject(parent)
{
}

QStringList QOssoABookDialog::contactChooser(const QString& windowTitle,
                                             OssoABookCapsFlags caps,
                                             OssoABookContactOrder order,
                                             unsigned int lower_limit,
                                             unsigned int upper_limit,
                                             QStringList *selectedContacts)
{
    QStringList rtn;
    OssoABookContactModel * model = osso_abook_contact_model_get_default();

    GtkWidget* contactChooser = osso_abook_contact_chooser_new_with_capabilities (0, qPrintable(windowTitle), caps, order);

    osso_abook_contact_chooser_set_model(OSSO_ABOOK_CONTACT_CHOOSER(contactChooser), model);

    osso_abook_contact_chooser_set_minimum_selection(OSSO_ABOOK_CONTACT_CHOOSER(contactChooser),
                                                     lower_limit);
    osso_abook_contact_chooser_set_maximum_selection(OSSO_ABOOK_CONTACT_CHOOSER(contactChooser),
                                                     upper_limit);
    /*
        Get the default model.
        Verify that selectedContacts are in it.
        Set this model as the model for the contact chooser.
     */
    if (selectedContacts) {
        QString contact;
        foreach (contact, *selectedContacts) {
            qDebug() << "Looking up " << contact;
            OssoABookListStoreRow* row =
                    osso_abook_contact_model_find_contact(model,
                                                          qPrintable(contact),
                                                          NULL);
            if (row) {
                OssoABookContact *c = row->contact;

                qDebug() << "Found "
                        << osso_abook_contact_get_uid(c)
                        << " "
                        << osso_abook_contact_get_display_name(c);

                osso_abook_contact_chooser_select(OSSO_ABOOK_CONTACT_CHOOSER(contactChooser), c);
            } else qDebug() << "Did not find " << contact;
        }
        // TALMAGE: Something about osso_abook_contact_chooser_select() isn't right.
        // Is it supposed to make an 'X' mark beside all elements in g?
        // That's what I expect.  No contact is marked in any way.
    }

    //Shows a modal dialog.
    GList* contacts; // Do not free // TALMAGE: Why not?

    // TALMAGE: Prove that the contacts are indeed selected before showing the contactChooser.
    // Expected result: non-NULL contacts.
    // Actual result: contacts is NULL
    contacts = osso_abook_contact_chooser_get_selection(OSSO_ABOOK_CONTACT_CHOOSER(contactChooser));
    while (contacts){
        EContact* eContact = E_CONTACT(contacts->data);
        const char* id = (const char*)e_contact_get_const(eContact, E_CONTACT_UID);
        qDebug() << "Chooser has " << id;
        contacts = contacts->next;
        // TALMAGE: This looks like a memory leak to me.
    }

    if (gtk_dialog_run(GTK_DIALOG(contactChooser)) == GTK_RESPONSE_OK){
      contacts = osso_abook_contact_chooser_get_selection(OSSO_ABOOK_CONTACT_CHOOSER(contactChooser));
      while (contacts){
          EContact* eContact = E_CONTACT(contacts->data);
          const char* id = (const char*)e_contact_get_const(eContact, E_CONTACT_UID);
          rtn << QString::fromLatin1(id);
          contacts = contacts->next;
          // TALMAGE: This looks like a memory leak to me.
      }
    }
    // TALMAGE: Maybe this takes care of it.
    gtk_widget_destroy(contactChooser);

    return rtn;
}

void QOssoABookDialog::contactEditor(const QString& id){
    OssoABookContact* contact = QOssoABookDialog::lookup(id);

    OssoABookContactEditorMode mode = (contact) ?  OSSO_ABOOK_CONTACT_EDITOR_EDIT : OSSO_ABOOK_CONTACT_EDITOR_CREATE;

    GtkWidget* contactEditor = osso_abook_contact_editor_new_with_contact(0, contact, mode);
    gtk_dialog_run(GTK_DIALOG(contactEditor));
    gtk_widget_destroy(contactEditor);
}

OssoABookContact* QOssoABookDialog::lookup(const QString& id){
    OssoABookContact *answer = 0;
    GList* contacts = 0; // Do not free
    GError *error = 0;
    OssoABookAggregator* aggregator = 0; // Do not free

    aggregator = (OssoABookAggregator*) osso_abook_aggregator_get_default(&error);
    if (error){
        qWarning() << "error opening addressbook" << error->message;
        g_error_free (error);
        return 0;
    }
    osso_abook_waitable_run(OSSO_ABOOK_WAITABLE(aggregator),
                                g_main_context_default(), &error);

    if (error) {
        qWarning() << "error setting up aggregator" << error->message;
        g_error_free(error);
        return 0;
    }

    contacts = osso_abook_aggregator_lookup(aggregator,qPrintable(id));

    if (contacts) // Found!
        answer = (OssoABookContact*) contacts->data;

    return answer;
}
