#ifndef PANICBUTTONMAINWINDOW_H
#define PANICBUTTONMAINWINDOW_H
#include "qcontactchooserdialog.h"
#include <qmobilityglobal.h>
#include <QContactAbstractRequest>
#include <QContactFetchRequest>
#include <QContactManager>
#include <QMainWindow>
#include <QMenuBar>
#include <QMessageService>
#include <QtLocation/QGeoPositionInfo>
#include <QtLocation/QGeoPositionInfoSource>
#include <QVariant>

QTM_USE_NAMESPACE

namespace Ui {
    class PanicButtonMainWindow;
}

// TODO: QPair<QString, QList<QString>>
struct work {
    QString message;
    QList<QVariant> recipients;
};

class PanicButtonMainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit PanicButtonMainWindow(QWidget *parent = 0);
    ~PanicButtonMainWindow();
    void sendMessage();

private:
    Ui::PanicButtonMainWindow *ui;
    QMenuBar *menuBar;
    QAction *aboutAction;
    QAction *setContactsAction;
    QAction *clearContactsAction;
    QAction *helpAction;
    QAction *setGPSUpdateIntervalAction;
    QAction *setPanicMessageAction;
    QMap<QString, QString> allContacts;  // Temporary place for guid->phone number mappings
    int allContactsIndex;
    QMap<QString, QVariant> emergencyContacts; // guid->phone number
    int emergencyContactsIndex;
    QString panicMessage;
    QGeoPositionInfoSource *source;
    QGeoPositionInfo location;
    QMessageService *service;
    QList<work *> workQueue;  // TODO: QList<QPair<QString, QList<QString>> *>
    bool messageServiceReady;
    int gpsUpdateInterval; // in seconds
    bool gpsUpdateIntervalSet;
    QContactManager cm;
    QContactFetchRequest allContactsFetchRequest;
    QContactFetchRequest emergencyContactsFetchRequest;
    QContactChooserDialog chooserDialog;

    void addToChooserDialog(QContactFetchRequest &request);
    void addToEmergencyContacts(QContactFetchRequest &request);
    bool buildEmergencyContactsFetchRequest();
    QList<QVariant> phoneNumbers();
    void printEmergencyContacts();

private slots:
    void about();
    void accept();
    void allContactsFetchRequestResultsAvailable();
    void allContactsFetchRequestStateChanged(QContactAbstractRequest::State);
    void clearContacts();
    void emergencyContactsFetchRequestStateChanged(QContactAbstractRequest::State);
    void emergencyContactsFetchRequestUpdateResultsAvailable();
    void help();
    void messageServiceStateChanged(QMessageService::State newState);
    void on_panicButton_clicked();
    void positionUpdated(const QGeoPositionInfo &info);
    void reject();
    void setContacts();
    void setGPSUpdateInterval();
    void setPanicMessage();

};

#endif // PANICBUTTONMAINWINDOW_H
