/*
 * This file is part of osso-abook-plugin-merge-contacts
 *
 * Copyright (C) 2008-2009 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 * 
 * Header file with application data.
 */


#ifndef _APPDATA_H
#define _APPDATA_H

#ifdef  __cplusplus
extern "C" {
#endif

#include <glib.h>
#include <gtk/gtk.h>
#include <libosso-abook/osso-abook.h>

/**
 * Struct with user account information.
 */ 
typedef struct _Account Account;

struct _Account {
    gchar *vcard_field_name; /* Name of field in vcard 3.0 representation
			        For example, X-JABBER, ICQ and so on*/
    gchar *display_name; // Displan name of service.
    GList *domains; // GList with domain. Define by DefaultAccountDomain field in profile.
};


/**
 * Application data.
 */ 
typedef struct _AppData AppData;

struct _AppData {
    GtkWidget *window; // Main window. Need for osso GUI for merging contacts.
    GList *accounts; // GList with accounts of user. (GList->data has Account type)

    OssoABookFilterModel* filter_model_left;
    OssoABookFilterModel* filter_model_right;
    
    GtkWidget *view1;
    GtkWidget *view2;
    
    HildonLiveSearch *live_left;
    HildonLiveSearch *live_right;
};


#ifdef  __cplusplus

}
#endif

#endif  /* _APPDATA_H */

