import os
import sys
import time
from PySide.QtCore import *
from PySide.QtGui import *

# Some global variables
OpenmsxGuiVersion = "0.0.1-2"
CommentChar = '#'
OptionChar =  ' '
Home = os.path.expanduser("~")
OpenmsxGui_CfgFile = Home + '/.config/openmsx-gui/openmsx-gui.cfg'
Openmsx_CfgFile = Home + '/.openMSX/share/scripts/startup.tcl'
LastPlayed_File = Home + '/.config/openmsx-gui/last_played.txt'
MuteOn_File = '/opt/openmsx-gui/mute_on.tcl'
MuteOff_File = '/opt/openmsx-gui/mute_off.tcl'
RomPath = ""
RomPath2 = ""
ExecPath = ""
RomPathActive = ""
P1upkey = ""
P1downkey = ""
P1rightkey = ""
P1leftkey = ""
P1button1key = ""
P1button2key = ""
Pausekey = ""
Resetkey = ""
Quitkey = ""
gameName = ""

def parse_config(self, filename):
        options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if CommentChar in line:
                # split on comment char, keep only the part before
                line, comment = line.split(CommentChar, 1)
            # Second, find lines with an option=value:
            if OptionChar in line:
                 # split on option char:
                 option, value = line.split(OptionChar, 1)
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 options[option] = value
        f.close()
        return options

def parse_openmsx_settings_config(self, filename):
        set_settings_options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if CommentChar in line:
                # split on comment char, keep only the part before
                line, comment = line.split(CommentChar, 1)
            # Second, find lines with an option=value:
            if "set " in line:
                 # split on option char:
		 option = line.strip().split()[1]
		 value = line[line.replace(' ','x',1).index(' '):line.rindex('\n')]
                 # strip spaces:
                 value = value.strip()
                 # store in dictionary:
                 set_settings_options[option] = value
        f.close()
        return set_settings_options

def parse_openmsx_bindings_config(self, filename):
        set_bindings_options = {}
        f = open(filename)
        for line in f:
            if (line.strip().split()[0] == "bind") or (line.strip().split()[0] == "#bind"):
                 # split on option char:
		 value = line.strip().split()[1]
		 option = line[line.replace(' ' ,'x',1).index(' '):line.rindex('\n')]
                 # strip spaces:
                 option = option.strip()
                 # store in dictionary:
                 set_bindings_options[option] = value
        f.close()
        return set_bindings_options

def parse_openmsx_plug_config(self, filename):
        set_plugs_options = {}
        f = open(filename)
        for line in f:
            # First, remove comments:
            if CommentChar in line:
                # split on comment char, keep only the part before
                line, comment = line.split(CommentChar, 1)
            # Second, find lines with an option=value:
            if "plug " in line:
                 # split on option char:
		 option = line[line.index(' '):line.rindex(' ')]
		 value = line[line.replace(' ' ,'x',1).index(' '):line.rindex('\n')]
                 # strip spaces:
                 option = option.strip()
                 value = value.strip()
                 # store in dictionary:
                 set_plugs_options[option] = value
        f.close()
        return set_plugs_options

class Ui_MainWindow(QMainWindow):
    def __init__(self):
        QMainWindow.__init__(self, None)
        self.setWindowTitle("OpenMSX-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
	global RomPathActive
	'''
	Check for required files
	'''
	# Load config
        self.gui_opts = parse_config(self,OpenmsxGui_CfgFile)
	if not "exec_path" in self.gui_opts:
		QMessageBox.critical(self, "Critical",  "exec_path not set in '" + OpenmsxGui_CfgFile + "'")
    		sys.exit()
	if not os.path.isfile(self.gui_opts["exec_path"] + "/openmsx"):
		QMessageBox.critical(self, "Critical",  "'" + self.gui_opts["exec_path"] + "/openmsx' not found!")
        	widget = pathWindow(self)
		widget.show()
	if not os.path.isdir(self.gui_opts["rom_path"]):
		QMessageBox.critical(self, "Critical",  "rom_path" + " '" + self.gui_opts["rom_path"] + "' not found!")
       		widget = pathWindow(self)
		widget.show()

	# Set background image
        backgroundLabel = QLabel(self)
        AboutTxt = "<img src=/opt/openmsx-gui/msx-screen.png />" 
        backgroundLabel.setText(AboutTxt)
	backgroundLabel.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
      	self.setCentralWidget(backgroundLabel)
	# Get Gametitles from rom_path

        self.gameListButton = QPushButton(self)
        self.gameListButton.setGeometry(QRect(20, 50, 750, 60))
        self.connect(self.gameListButton, SIGNAL("clicked()"), self.pickGame)

	# Define menubar
	aboutAction = QAction( '&About', self)
        aboutAction.triggered.connect(self.slotAbout)
	configAction = QAction( '&Config', self)
        configAction.triggered.connect(self.slotConfig)
	self.romPath1Action = QAction( '&Use RomPath1', self)
	self.romPath1Action.setCheckable(True)
        self.romPath1Action.triggered.connect(self.setGame1)
	self.romPath2Action = QAction( '&Use RomPath2', self)
	self.romPath2Action.setCheckable(True)
	self.romPath2Action.triggered.connect(self.setGame2)
	if self.gui_opts["rom_path_active"] == "1":
		self.romPath1Action.setChecked(True)
	else:
		self.romPath2Action.setChecked(True)

        # Read last started file
        try:
                playedFile = open(LastPlayed_File,"r")
        except:
                last_game = "Select game"
        else:
                last_game = playedFile.readlines()
                if RomPathActive == "1":
                        if os.path.isfile(self.gui_opts["rom_path"]+'/'+os.path.basename(''.join(last_game))):
                                gameName = last_game
                        else:
                                last_game = "Select game"
        self.gameListButton.setText(''.join(last_game))
		
        menubar = self.menuBar()
        fileMenu = menubar.addMenu('&MainMenu')
        fileMenu.addAction(configAction)
        fileMenu.addAction(aboutAction)
        fileMenu.addAction(self.romPath1Action)
        fileMenu.addAction(self.romPath2Action)

        self.startButton = QPushButton("Start",self)
        self.startButton.setGeometry(QRect(0, 370, 400, 55))
        font = QFont()
        font.setPointSize(24)
        self.startButton.setFont(font)
	QObject.connect(self.startButton
		, SIGNAL("clicked()")
		, self.on_start_clicked)

        self.onesmutePushButton = QPushButton("Mute",self)
	self.onesmutePushButton.setCheckable(True)
        self.onesmutePushButton.setGeometry(QRect(400, 370, 400, 55))
        self.onesmutePushButton.setFont(font)

    def setGame1(self):
        global RomPathActive
        global gameName
        self.romPath1Action.setChecked(True)
        self.romPath2Action.setChecked(False)
        gameName = ""
        self.gameListButton.setText("Select game")
        RomPathActive = "1"

    def setGame2(self):
        global RomPathActive
        global gameName
        if self.gui_opts["rom2_path"] not in "notset":
                self.romPath1Action.setChecked(False)
                self.romPath2Action.setChecked(True)
                gameName = ""
                self.gameListButton.setText("Select game")
                RomPathActive = "2"
        else:
                self.romPath2Action.setChecked(False)

    def pickGame(self):
        gamePick = GamePickDialog(self)
        gamePick.show()
        if gameName:
                self.gameListButton.setText(gameName)

    def on_start_clicked(self):
	# Add all the options
	# but first, re-read all settings
        self.gui_opts = parse_config(self,OpenmsxGui_CfgFile)
	if self.gui_opts["machine"] == "C-Bios":
		ALL_OPTS=" "
	else:
		# Panasonic machine chosen
		for SystemRom in "fs-a1gt_firmware.rom", "fs-a1gt_kanjifont.rom":
			if not (os.path.exists(Home + "/.openMSX/share/systemroms/" + SystemRom)):
				if not (os.path.exists("/opt/openmsx/share/systemroms/" + SystemRom)):
					QMessageBox.critical(self, "Critical",  SystemRom + " not found in /opt/openmsx/share/systemroms/ or " + Home + "/.openMSX/share/systemroms/")
					ALL_OPTS=" "
				else:	
					ALL_OPTS="-machine " + self.gui_opts["machine"] + " "
        if self.onesmutePushButton.isChecked():
		ALL_OPTS= ALL_OPTS + "-script " + MuteOn_File + " "
        else:  ALL_OPTS= ALL_OPTS + "-script " + MuteOff_File + " "

	if not (gameName == "No roms found" or not gameName):
		# Write as last played game
		playedFile = open(LastPlayed_File,"w")
		playedFile.write(gameName)
		playedFile.close()
		file_extension = os.path.splitext(gameName)[1][1:].upper()
		if self.gui_opts["machine"] == "C-Bios" and file_extension in ("DSK","XSA"):
			QMessageBox.critical(self, "Critical", "Disk images are not supported with C-Bios activated")
		# Start emulator with parametersA
                if RomPathActive != "":
                        self.gui_opts["rom_path_active"] = RomPathActive
		if RomPathActive == "1":
			print self.gui_opts["exec_path"] + "/openmsx "+ALL_OPTS+ " " + '"' + self.gui_opts["rom_path"] + "/" + gameName +  '"'
			QProcess.startDetached(self.gui_opts["exec_path"] + "/openmsx "+ALL_OPTS+ " " + '"' + self.gui_opts["rom_path"] + "/" + gameName + '"' )
		else:
			print self.gui_opts["exec_path"] + "/openmsx "+ALL_OPTS+ " " + '"' + self.gui_opts["rom2_path"] + "/" + gameName +  '"'
			QProcess.startDetached(self.gui_opts["exec_path"] + "/openmsx "+ALL_OPTS+ " " + '"' + self.gui_opts["rom2_path"] + "/" + gameName + '"' )

		if (self.gui_opts["exit_after_launch"] == "true"):
			time.sleep(5)
			os._exit(0)

    def slotAbout(self):
        a = AboutWindow(self)
        a.show()

    def slotConfig(self):
        a = ConfigWindow(self)
        a.show()

class GamePickDialog(QWidget):
    def __init__(self,parent):
        super(GamePickDialog, self).__init__(parent)
        global RomPathActive
        self.d = QDialog(self)
        self.d.setMinimumHeight(380)
        self.d.setMaximumHeight(380)
        self.d.setWindowTitle("[Select game]")
        hbox = QGridLayout()
        horizontalLayout = QGridLayout()
        self.gameWidget = QListWidget()

        # Load config
        self.gui_opts = parse_config(self,OpenmsxGui_CfgFile)
        if RomPathActive == "1":
		ListCmd = "cd '" + self.gui_opts["rom_path"] + "' 2>/dev/null && ls -1 *.zip *.ZIP *.rom *.ROM *.dsk *.DSK *.cas *.CAS *.wav *.WAV *.xsa *.XSA 2>/dev/null|sort -f" 
        else:
		ListCmd = "cd '" + self.gui_opts["rom2_path"] + "' 2>/dev/null && ls -1 *.zip *.ZIP *.rom *.ROM *.dsk *.DSK *.cas *.CAS *.wav *.WAV *.xsa *.XSA 2>/dev/null|sort -f" 
        fin,fout = os.popen4(ListCmd)
        romList = fout.read()
        fin.close()
        romList = romList.split('\n')
        romList = romList[:-1]
        if not romList:
                romList = ['No roms found']

        for Game in romList:
                item = QListWidgetItem(Game)
                item.setTextAlignment(Qt.AlignCenter)
                self.gameWidget.addItem(item)
                if Game == gameName:
                        currItem = item

        # Set most recent file as current
        if gameName in romList:
                self.gameWidget.setCurrentItem(currItem)

        horizontalLayout.addWidget(self.gameWidget,0,0)
        self.d.setLayout(hbox)
        hbox.addLayout (horizontalLayout,0,0)

        self.connect(self.gameWidget, SIGNAL("itemClicked(QListWidgetItem *)"), self.itemClicked)
        self.d.exec_()

    def itemClicked(self, item):
        global gameName
        gameName = item.text()
        self.d.close()

    def slotJoyconf(self):
        a = JoyconfWindow(self)
        a.show()

class AboutWindow(QMainWindow):
    def __init__(self, parent):
        QMainWindow.__init__(self, parent)
        self.setWindowTitle("About OpenMSX-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
	area = QScrollArea()
	lay = QVBoxLayout()
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	self.setCentralWidget(area)
	wg.resize(792,550);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	self.setLayout(grid)
        self.label = QLabel(self)
	AboutTxt = "<font style='color: black'><h3>OpenMSX-gui " + OpenmsxGuiVersion + "</h3><p>" \
                   "<img src=/opt/usr/share/icons/hicolor/64x64/apps/openMSX-logo-64.png /><br>" \
                   "OpenMSX-gui is a Graphical User Interface for OpenMSX<p> " \
                   "OpenMSX emulates the MSX homecomputer standard by ASCII &#174;</p>" \
                   "<p>OpenMSX-gui is written in PySide by <i>Arno Dekker</i> 2012<p><br>" \
                   "<u>Used special key mappings:</u>" \
                   "<ul align=left>" \
                   "<li> - N900 MODE+BACKSPACE mapped to MSX DELETE" \
                   "<li> - N900 MODE+ENTER mapped to MSX INSERT" \
                   "<li> - N900 CTRL+Q,W,E,R,T mapped to MSX F1,F2,F3,F4,F5" \
                   "<li> - N900 CTRL+X to toggle console" \
                   "</ul>" \
                   "<br>" \
                   '<FONT FACE= "Courier New"><a href="http://openmsx.sourceforge.net/">Visit openMSX homepage</a><br>' \
                   "" %dict()
        self.label.setText(AboutTxt)
	self.label.setOpenExternalLinks(True)
	self.label.setAlignment(Qt.AlignCenter | Qt.AlignLeft)
	self.label.setStyleSheet("QWidget {background-color: white }")
        grid.addWidget(self.label)

class ConfigWindow(QMainWindow):
    def __init__(self,parent):
        QMainWindow.__init__(self,parent)
        self.setWindowTitle("Configuration Openmsx-gui")
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        self.setAttribute(Qt.WA_DeleteOnClose)
	area = QScrollArea()
	lay = QVBoxLayout()
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	self.setCentralWidget(area)
	wg.resize(790,550);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
        self.gui_opts = parse_config(self,OpenmsxGui_CfgFile)
        self.openmsx_opts = parse_openmsx_settings_config(self,Openmsx_CfgFile)
        self.openmsx_keys = parse_openmsx_bindings_config(self,Openmsx_CfgFile)
        self.openmsx_plugs = parse_openmsx_plug_config(self,Openmsx_CfgFile)
        font = QFont()
        font.setPointSize(20)
	self.setLayout(grid)
	# Full screen
        self.showfsPushButton = QPushButton("full screen",self)
	self.showfsPushButton.setCheckable(True)
        grid.addWidget(self.showfsPushButton,0,0)
        self.showfsPushButton.setFont(font)
	if "fullscreen" not in self.openmsx_opts:
		self.openmsx_opts["fullscreen"] = "off"
	if self.openmsx_opts["fullscreen"] == "on":
            self.showfsPushButton.setChecked(True)
	# limitspites
	if "limitsprites" not in self.openmsx_opts:
		self.openmsx_opts["limitsprites"] = "false"
        self.spritesPushButton = QPushButton("limit sprites",self)
	self.spritesPushButton.setCheckable(True)
        grid.addWidget(self.spritesPushButton,0,1)
        self.spritesPushButton.setFont(font)
	if self.openmsx_opts["limitsprites"] == "true":
            self.spritesPushButton.setChecked(True)
        # Exit on start button
        self.exitPushButton = QPushButton("exit after start game",self)
	self.exitPushButton.setCheckable(True)
        grid.addWidget(self.exitPushButton,0,2)
	if self.gui_opts["exit_after_launch"] == "true":
		self.exitPushButton.setChecked(True)
	# Scanline
	if "scanline" not in self.openmsx_opts:
		self.openmsx_opts["scanline"] = "0"
        grid.addWidget(QLabel("<center>Scanline:</center>"), 1, 0)
        self.scanlineSpinBox = QDoubleSpinBox()
        self.scanlineSpinBox.setRange(0,100)
        self.scanlineSpinBox.setAlignment(Qt.AlignCenter)
        self.scanlineSpinBox.setValue(float(self.openmsx_opts["scanline"]))
        self.scanlineSpinBox.setDecimals(0)
        self.scanlineSpinBox.setSuffix(" %")
        grid.addWidget(self.scanlineSpinBox, 2,0)
	# Keyclick volume
        grid.addWidget(QLabel("<center>KeyClick volume:</center>"), 1, 1)
        self.keyclickvolSpinBox = QDoubleSpinBox()
        self.keyclickvolSpinBox.setRange(0,100)
        self.keyclickvolSpinBox.setAlignment(Qt.AlignCenter)
        self.keyclickvolSpinBox.setValue(float(self.openmsx_opts["keyclick_volume"]))
        self.keyclickvolSpinBox.setDecimals(0)
        self.keyclickvolSpinBox.setSuffix(" %")
        grid.addWidget(self.keyclickvolSpinBox, 2,1)
	# Master volume
        grid.addWidget(QLabel("<center>Master volume:</center>"), 1, 2)
        self.mastervolSpinBox = QDoubleSpinBox()
        self.mastervolSpinBox.setRange(0,100)
        self.mastervolSpinBox.setAlignment(Qt.AlignCenter)
        self.mastervolSpinBox.setValue(float(self.openmsx_opts["master_volume"]))
        self.mastervolSpinBox.setDecimals(0)
        self.mastervolSpinBox.setSuffix(" %")
        grid.addWidget(self.mastervolSpinBox, 2,2)
	# Brightness
        grid.addWidget(QLabel("<center>Brightness:</center>"), 3, 0)
        self.brightnessSpinBox = QDoubleSpinBox()
        self.brightnessSpinBox.setRange(-100,100)
        self.brightnessSpinBox.setAlignment(Qt.AlignCenter)
        self.brightnessSpinBox.setValue(float(self.openmsx_opts["brightness"]))
        self.brightnessSpinBox.setDecimals(0)
        self.brightnessSpinBox.setSuffix(" %")
        grid.addWidget(self.brightnessSpinBox, 4,0)
	# TV Blur
        grid.addWidget(QLabel("<center>Blur:</center>"), 3, 1)
        self.blurSpinBox = QDoubleSpinBox()
        self.blurSpinBox.setRange(0,100)
        self.blurSpinBox.setAlignment(Qt.AlignCenter)
        self.blurSpinBox.setValue(float(self.openmsx_opts["blur"]))
        self.blurSpinBox.setDecimals(0)
        self.blurSpinBox.setSuffix(" %")
        grid.addWidget(self.blurSpinBox, 4,1)
	# Contrast
        grid.addWidget(QLabel("<center>Contrast:</center>"), 3, 2)
        self.contrastSpinBox = QDoubleSpinBox()
        self.contrastSpinBox.setRange(-100,100)
        self.contrastSpinBox.setAlignment(Qt.AlignCenter)
        self.contrastSpinBox.setValue(float(self.openmsx_opts["contrast"]))
        self.contrastSpinBox.setDecimals(0)
        self.contrastSpinBox.setSuffix(" %")
        grid.addWidget(self.contrastSpinBox, 4,2)
	# Accuracy
	grid.addWidget(QLabel("<center>Accuracy:</center>"), 5, 0)
        self.comboAccuracy = QComboBox(self)
        grid.addWidget(self.comboAccuracy,6,0)
	accuracies = self.listDefaultFirst('accuracy',['screen','line','pixel'])
	for Accuracy in accuracies:
		self.comboAccuracy.addItem(Accuracy)
	# Scale algorithm
	grid.addWidget(QLabel("<center>Algorithm:</center>"), 5,1)
        self.comboAlgorithm = QComboBox(self)
        grid.addWidget(self.comboAlgorithm,6,1)
	algorithms = self.listDefaultFirst('scale_algorithm',['simple','hq'])
	for Algorithm in algorithms:
		self.comboAlgorithm.addItem(Algorithm)
	# Machine
	grid.addWidget(QLabel("<center>Machine:</center>"), 5, 2)
        self.comboMachine = QComboBox(self)
        grid.addWidget(self.comboMachine,6,2)
	machines = self.listDefaultFirstGui('machine',['C-Bios','Panasonic_FS-A1GT'])
	for Machine in machines:
		self.comboMachine.addItem(Machine)
        # keyjoy1
	if "joyporta" not in self.openmsx_plugs:
		self.openmsx_plugs["joyporta"] = "unplug"
        self.keyjoy1PushButton = QPushButton("keyjoystick 1",self)
	self.keyjoy1PushButton.setCheckable(True)
        grid.addWidget(self.keyjoy1PushButton,7,0)
	if self.openmsx_plugs["joyporta"] == "keyjoystick1":
            self.keyjoy1PushButton.setChecked(True)

	# Path button
        self.pathButton = QPushButton("paths def",self)
        self.pathButton.setFont(font)
        grid.addWidget(self.pathButton,7,1)
	QObject.connect(self.pathButton
		, SIGNAL("clicked()")
		, self.on_paths_clicked)
	# Keys button
        self.keysButton = QPushButton("keyjoy1 def",self)
        self.keysButton.setFont(font)
        grid.addWidget(self.keysButton,7,2)
	QObject.connect(self.keysButton
		, SIGNAL("clicked()")
		, self.on_keys_clicked)
	# Save button
        self.saveButton = QPushButton("SAVE",self)
        self.saveButton.setStyleSheet(
	"QPushButton { color: red; font:bold; }"
      		) 
        self.saveButton.setFont(font)
        grid.addWidget(self.saveButton,8,0,1,3)
	QObject.connect(self.saveButton
		, SIGNAL("clicked()")
		, self.on_save_clicked)


    def on_save_clicked(self):
	if self.spritesPushButton.isChecked():
           self.openmsx_opts["limitsprites"] = "true"
        else: self.openmsx_opts["limitsprites"] = "false" 
        if self.showfsPushButton.isChecked():
           self.openmsx_opts["fullscreen"] = "on"
        else: self.openmsx_opts["fullscreen"] = "off" 
        if self.exitPushButton.isChecked():
           self.gui_opts["exit_after_launch"] = "true"
        else: self.gui_opts["exit_after_launch"] = "false" 
        if self.keyjoy1PushButton.isChecked():
           self.openmsx_plugs["joyporta"] = "keyjoystick1"
        else: self.openmsx_plugs["joyporta"] = "unplug" 
        if RomPath != "":
           self.gui_opts["rom_path"] = RomPath
        if RomPath2 != "":
           self.gui_opts["rom2_path"] = RomPath2
        if RomPathActive != "":
           self.gui_opts["rom_path_active"] = RomPathActive
        self.gui_opts["machine"] = self.comboMachine.currentText()
	self.openmsx_opts["scanline"] = "%.0f" % self.scanlineSpinBox.value()
	self.openmsx_opts["blur"] = "%.0f" % self.blurSpinBox.value()
	self.openmsx_opts["contrast"] = "%.0f" % self.contrastSpinBox.value()
	self.openmsx_opts["brightness"] = "%.0f" % self.brightnessSpinBox.value()
	self.openmsx_opts["master_volume"] = "%.0f" % self.mastervolSpinBox.value()
	self.openmsx_opts["keyclick_volume"] = "%.0f" % self.keyclickvolSpinBox.value()
	self.openmsx_opts["accuracy"] = self.comboAccuracy.currentText()
	self.openmsx_opts["scale_algorithm"] = self.comboAlgorithm.currentText()
	

	#------------------------------#
	# save openMSX-gui config file #
	#------------------------------#
        orgConfigFile = open(OpenmsxGui_CfgFile,"r")
        try:
                copyFile = open(OpenmsxGui_CfgFile + ".old" ,"w")
        except:
                QMessageBox.critical(self, "Warning",  "Cannot write " + OpenmsxGui_CfgFile + ".old")
        else:
                # Write the copy (.old)
                for line in orgConfigFile.readlines():
                        copyFile.write(line)
                orgConfigFile.close()
                copyFile.close()
                try:
                        newConfigFile = open(OpenmsxGui_CfgFile,"w")
                except:
                        QMessageBox.critical(self, "Warning",  "Cannot write " + OpenmsxGui_CfgFile)
                else:
                        newConfigFile.write("# Generated by openMSX-gui\n")
                        for option in self.gui_opts:
                                newConfigFile.write(option + " " + self.gui_opts[option] + "\n")
                        newConfigFile.close()

        self.openmsx_keys = parse_openmsx_bindings_config(self,Openmsx_CfgFile)
	#----------------------------------#
	# save the openMSX tcl config file #
	#----------------------------------#
	if P1upkey != "":
		self.openmsx_opts["keyjoystick1.up"] = P1upkey
	if P1downkey != "":
		self.openmsx_opts["keyjoystick1.down"] = P1downkey
	if P1rightkey != "":
		self.openmsx_opts["keyjoystick1.right"] = P1rightkey
	if P1leftkey != "":
		self.openmsx_opts["keyjoystick1.left"] = P1leftkey
	if P1button1key != "":
		self.openmsx_opts["keyjoystick1.triga"] = P1button1key
	if P1button2key != "":
		self.openmsx_opts["keyjoystick1.trigb"] = P1button2key
	if Pausekey != "":
		self.openmsx_keys["toggle pause"] = Pausekey
	if Resetkey != "":
		self.openmsx_keys["reset"] = Resetkey
	if Quitkey != "":
		self.openmsx_keys["quit"] = Quitkey
	try:
		newConfigFile = open(Openmsx_CfgFile,"w")
	except:
		QMessageBox.critical(self, "Warning",  "Cannot write " + Openmsx_CfgFile)
	else:
		newConfigFile.write("# Generated by openMSX-gui\n")
		for option in self.openmsx_opts:
			newConfigFile.write('set ' + option + " " + self.openmsx_opts[option] + "\n")
		for option in self.openmsx_keys:
			if self.openmsx_plugs["joyporta"] != "unplug":
				newConfigFile.write('bind ' + self.openmsx_keys[option] + " " + option + "\n")
			else:
				newConfigFile.write('#bind ' + self.openmsx_keys[option] + " " + option + "\n")
				newConfigFile.write('unbind ' + self.openmsx_keys[option] + "\n")
		for option in self.openmsx_plugs:
			if self.openmsx_plugs[option] != "unplug":
				newConfigFile.write('plug ' + option + " " + self.openmsx_plugs[option] + "\n")
		newConfigFile.close()
		os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
		           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
		           string:"Configuration is succesfully saved"')

    def listDefaultFirst(self, optVal,List):
	Position = List.index(self.openmsx_opts[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def listDefaultFirstGui(self, optVal,List):
	Position = List.index(self.gui_opts[optVal])
	List[Position], List[0] = List[0], List[Position]
	return List

    def on_keys_clicked(self):
        widget = keyWindow(self)
        widget.show()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button to save it!"')

    def on_paths_clicked(self):
        widget = pathWindow(self)
        widget.show()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

class keyWindow(QDialog):
    def __init__(self, parent=None):
        super(keyWindow, self).__init__(parent)
        self.setWindowTitle("OpenMsx-gui keyjoy config")
        LineNbr=1
        self.openmsx_opts = parse_openmsx_settings_config(self,Openmsx_CfgFile)
        self.openmsx_keys = parse_openmsx_bindings_config(self,Openmsx_CfgFile)
        # Layout
        area = QScrollArea(self)
        lay = QVBoxLayout(self)
        lay.addWidget(area)
        wg = QWidget()
        area.setWidget(wg)
        wg.resize(750,650);
        grid = QGridLayout(wg)
        wg.show()
        area.show()
        grid.setColumnStretch(2, 20)
        font = QFont()
        font.setPointSize(24)

        grid.addWidget(QLabel("<center>PLAYER 1</center>"), 1, 1)
        grid.addWidget(QLabel("<center>[pick]</center>"), 1, 2)
        # Add button list
        cntr=2
        for pButton in ['UP','DOWN','LEFT','RIGHT','BUTTON1','BUTTON2','PAUSE','RESET','QUIT']:
                grid.addWidget(QLabel(pButton), cntr, 0)
                cntr=cntr+1
	# UP
	self.P1UpValue = QLineEdit(self.openmsx_opts["keyjoystick1.up"])
	self.P1UpValue.setAlignment(Qt.AlignHCenter);
	grid.addWidget(self.P1UpValue, 2, 1)
	self.P1UpValue.setEnabled(False)
	self.P1UpButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1UpButton, 2, 2)
	# DOWN
	self.P1DownValue = QLineEdit(self.openmsx_opts["keyjoystick1.down"])
	self.P1DownValue.setAlignment(Qt.AlignHCenter);
	self.P1DownValue.setEnabled(False)
	grid.addWidget(self.P1DownValue, 3, 1)
	self.P1DownButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1DownButton, 3, 2)
	# LEFT
	self.P1LeftValue = QLineEdit(self.openmsx_opts["keyjoystick1.left"])
	self.P1LeftValue.setAlignment(Qt.AlignHCenter);
	self.P1LeftValue.setEnabled(False)
	grid.addWidget(self.P1LeftValue, 4, 1)
	self.P1LeftButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1LeftButton, 4, 2)
	# RIGHT
	self.P1RightValue = QLineEdit(self.openmsx_opts["keyjoystick1.right"])
	self.P1RightValue.setAlignment(Qt.AlignHCenter);
	self.P1RightValue.setEnabled(False)
	grid.addWidget(self.P1RightValue, 5, 1)
	self.P1RightButton = MyKeyPressed("key",self)
	grid.addWidget(self.P1RightButton, 5, 2)
        # Trigger A
	self.P1Button1Value = QLineEdit(self.openmsx_opts["keyjoystick1.triga"])
	self.P1Button1Value.setAlignment(Qt.AlignHCenter);
	self.P1Button1Value.setEnabled(False)
	grid.addWidget(self.P1Button1Value, 6, 1)
	self.P1Button1Button = MyKeyPressed("key",self)
	grid.addWidget(self.P1Button1Button, 6, 2)
        # Trigger B
	self.P1Button2Value = QLineEdit(self.openmsx_opts["keyjoystick1.trigb"])
	self.P1Button2Value.setAlignment(Qt.AlignHCenter);
	self.P1Button2Value.setEnabled(False)
	grid.addWidget(self.P1Button2Value, 7, 1)
	self.P1Button2Button = MyKeyPressed("key",self)
	grid.addWidget(self.P1Button2Button, 7, 2)
	# PAUSE
	self.PauseButtonValue = QLineEdit(self.openmsx_keys["toggle pause"])
	self.PauseButtonValue.setAlignment(Qt.AlignHCenter);
	self.PauseButtonValue.setEnabled(False)
	grid.addWidget(self.PauseButtonValue, 8, 1)
	self.PauseButton = MyKeyPressed("key",self)
	grid.addWidget(self.PauseButton, 8, 2)
        # RESET
	self.ResetButtonValue = QLineEdit(self.openmsx_keys["reset"])
	self.ResetButtonValue.setAlignment(Qt.AlignHCenter);
	self.ResetButtonValue.setEnabled(False)
	grid.addWidget(self.ResetButtonValue, 9, 1)
	self.ResetButton= MyKeyPressed("key",self)
	grid.addWidget(self.ResetButton, 9, 2)
        # QUIT
	self.QuitButtonValue = QLineEdit(self.openmsx_keys["quit"])
	self.QuitButtonValue.setAlignment(Qt.AlignHCenter);
	self.QuitButtonValue.setEnabled(False)
	grid.addWidget(self.QuitButtonValue, 10, 1)
	self.QuitButton= MyKeyPressed("key",self)
	grid.addWidget(self.QuitButton, 10, 2)

        self.setLayout(grid)

	self.connect(self.P1UpButton, SIGNAL("keyPressed"),self.P1updateUp)
	self.connect(self.P1DownButton, SIGNAL("keyPressed"),self.P1updateDown)
	self.connect(self.P1RightButton, SIGNAL("keyPressed"),self.P1updateRight)
	self.connect(self.P1LeftButton, SIGNAL("keyPressed"),self.P1updateLeft)
	self.connect(self.P1Button1Button, SIGNAL("keyPressed"),self.P1updateButton1)
	self.connect(self.P1Button2Button, SIGNAL("keyPressed"),self.P1updateButton2)
	self.connect(self.PauseButton, SIGNAL("keyPressed"),self.updatePauseButton)
	self.connect(self.ResetButton, SIGNAL("keyPressed"),self.updateResetButton)
	self.connect(self.QuitButton, SIGNAL("keyPressed"),self.updateQuitButton)

    def P1updateUp(self):
	global P1upkey
	self.P1UpValue.setText(AsciiVal)
	P1upkey = self.P1UpValue.text()

    def P1updateDown(self):
	global P1downkey
	self.P1DownValue.setText(AsciiVal)
	P1downkey = self.P1DownValue.text()

    def P1updateRight(self):
	global P1rightkey
	self.P1RightValue.setText(AsciiVal)
	P1rightkey = self.P1RightValue.text()

    def P1updateLeft(self):
	global P1leftkey
	self.P1LeftValue.setText(AsciiVal)
	P1leftkey = self.P1LeftValue.text()

    def P1updateButton1(self):
	global P1button1key
	self.P1Button1Value.setText(AsciiVal)
	P1button1key = self.P1Button1Value.text()

    def P1updateButton2(self):
	global P1button2key
	self.P1Button2Value.setText(AsciiVal)
	P1button2key = self.P1Button2Value.text()

    def updatePauseButton(self):
	global Pausekey
	self.PauseButtonValue.setText(AsciiVal)
	Pausekey = self.PauseButtonValue.text()

    def updateResetButton(self):
	global Resetkey
	self.ResetButtonValue.setText(AsciiVal)
	Resetkey = self.ResetButtonValue.text()

    def updateQuitButton(self):
	global Quitkey
	self.QuitButtonValue.setText(AsciiVal)
	Quitkey = self.QuitButtonValue.text()

class MyKeyPressed(QPushButton):
    def __init__(self, *args):
        QPushButton.__init__(self, *args)

    def event(self, event):
        if (event.type()==QEvent.KeyPress):
            # we have to get the SDL keysym
	    global AsciiVal
            if (event.key() < 256):
                AsciiVal = chr(ord(str.lower(chr(event.key()))))
            if (event.key() == 16777236):
		# right
                AsciiVal = "RIGHT";
	    if (event.key() == 16777234):
                # left
                AsciiVal = "LEFT";
            if (event.key() == 16777235):
                # up
                AsciiVal = "UP";
            if (event.key() == 16777237):
                # down
                AsciiVal = "DOWN";
            if (event.key() == 16777219):
                # BS
                AsciiVal = "BACKSPACE";
            if (event.key() == 16777221):
                # Return
                AsciiVal = "RETURN";
            if (event.key() == 16777248):
                # R-Shift
                AsciiVal = "RSHIFT";
            if (event.key() == 16777249):
                # R-Control
                AsciiVal = "RCTRL";
            if (event.key() == 16781571):
                # R-Alt
                AsciiVal = "RALT";
            if (event.key() == 32):
		# space
                AsciiVal = "SPACE";
            self.emit(SIGNAL("keyPressed"))

        return QPushButton.event(self, event)
	
class pathWindow(QDialog):
    def __init__(self, parent=None):
        super(pathWindow, self).__init__(parent)
        self.setWindowTitle("Openmsx-gui path configuration")
        self.gui_opts = parse_config(self,OpenmsxGui_CfgFile)
	if RomPath == "":
		self.romPath=self.gui_opts["rom_path"]
	else:
		self.romPath=RomPath
	if ExecPath == "":
		self.execPath = self.gui_opts["exec_path"]
	else:
		self.execPath = ExecPath
	if RomPath2 == "":
		self.romPath2=self.gui_opts["rom2_path"]
	else:
		self.romPath2=RomPath2
	area = QScrollArea(self)
	lay = QVBoxLayout(self)
	lay.addWidget(area)
	wg = QWidget()
	area.setWidget(wg)
	wg.setMinimumSize(700,300);
	grid = QGridLayout(wg)
	wg.show()
	area.show()
	grid.setColumnStretch(1, 10)
	grid.setColumnStretch(2, 20)
	# bios path
        font = QFont()
        font.setPointSize(24)
	# rom path
	self.pushRomButton = QPushButton(self.romPath,self)
        self.pushRomButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms 1"), 1, 0)
	grid.addWidget(self.pushRomButton, 1, 1)
	# rom2 path
	self.pushRomButton2 = QPushButton(self.romPath2,self)
        self.pushRomButton2.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("roms 2"), 2, 0)
	grid.addWidget(self.pushRomButton2, 2, 1)
	# exec path
	self.pushExecButton = QPushButton(self.execPath,self)
        self.pushExecButton.setStyleSheet(
	"QPushButton { text-align: left; }")
	grid.addWidget(QLabel("openmsx"), 3, 0)
	grid.addWidget(self.pushExecButton, 3, 1)

	self.setLayout(grid)

	QObject.connect(self.pushRomButton
		, SIGNAL("clicked()")
		, self.on_rom_button_clicked)
	QObject.connect(self.pushRomButton2
		, SIGNAL("clicked()")
		, self.on_rom2_button_clicked)
	QObject.connect(self.pushExecButton
		, SIGNAL("clicked()")
		, self.on_exec_button_clicked)


    def on_rom_button_clicked(self):
	d = QDialog(self)
 
	vbox = QVBoxLayout()
	#Add Layouts
	horizontalLayout = QHBoxLayout() 

	# Now create your buttons.
	homeButton = QPushButton("internal")
	rootButton = QPushButton("SD card")
	closeButton = QPushButton("Close")
	# Add buttons to your layouts, they'll show up in the order given.
	horizontalLayout.addWidget(homeButton)
	horizontalLayout.addWidget(rootButton)
	horizontalLayout.addWidget(closeButton)
	# Add layouts to your main Layout
	vbox.addLayout (horizontalLayout)
	d.setLayout(vbox)
        d.setWindowTitle("Choose roms location...")
 
	# Show the window!
	d.show()
	QObject.connect(homeButton
		, SIGNAL("clicked()")
		, self.on_rom_homebutton_clicked)
	QObject.connect(rootButton
		, SIGNAL("clicked()")
		, self.on_rom_rootbutton_clicked)
	QObject.connect(closeButton
		, SIGNAL("clicked()")
		, d.close)

    def on_rom2_button_clicked(self):
	d = QDialog(self)
 
	vbox = QVBoxLayout()
	#Add Layouts
	horizontalLayout = QHBoxLayout() 

	# Now create your buttons.
	homeButton = QPushButton("internal")
	rootButton = QPushButton("SD card")
	closeButton = QPushButton("Close")
	# Add buttons to your layouts, they'll show up in the order given.
	horizontalLayout.addWidget(homeButton)
	horizontalLayout.addWidget(rootButton)
	horizontalLayout.addWidget(closeButton)
	# Add layouts to your main Layout
	vbox.addLayout (horizontalLayout)
	d.setLayout(vbox)
        d.setWindowTitle("Choose roms2 location...")
 
	# Show the window!
	d.show()
	QObject.connect(homeButton
		, SIGNAL("clicked()")
		, self.on_rom2_homebutton_clicked)
	QObject.connect(rootButton
		, SIGNAL("clicked()")
		, self.on_rom2_rootbutton_clicked)
	QObject.connect(closeButton
		, SIGNAL("clicked()")
		, d.close)

    def on_rom_homebutton_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

    def on_rom2_homebutton_clicked(self):
	global RomPath2
	RomPath2 = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

    def on_rom_rootbutton_clicked(self):
	global RomPath
	RomPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/media')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

    def on_rom2_rootbutton_clicked(self):
	global RomPath2
	RomPath2 = QFileDialog.getExistingDirectory(self, 'Choose directory', '/media')
	self.close()
	os.system('run-standalone.sh dbus-send --type=method_call --dest=org.freedesktop.Notifications  \
	           /org/freedesktop/Notifications org.freedesktop.Notifications.SystemNoteInfoprint \
	           string:"Use SAVE button in config screen to save it!"')

    def on_exec_button_clicked(self):
	global ExecPath
	ExecPath = QFileDialog.getExistingDirectory(self, 'Choose directory', '/home/')
	if (not os.path.isfile(ExecPath + "/openmsx")) and (ExecPath != "") :
		QMessageBox.critical(self, "Warning",  "Cannot find " + ExecPath + "/openmsx")
	self.close()

if __name__ == "__main__":
    app = QApplication(sys.argv)
    ui = Ui_MainWindow()
    ui.show()
    sys.exit(app.exec_())
