#!/bin/sh

CFG_DIR=$HOME/.config/openmsx-gui
CFG_FILE=$CFG_DIR/openmsx-gui.cfg
mkdir -p $CFG_DIR 2> /dev/null
if [ ! -r $CFG_FILE ]
then
	echo "exec_path /opt/openmsx/bin" > $CFG_FILE
	echo "bios_path $HOME/.openMSX/share/systemroms" >> $CFG_FILE
	echo "rom_path notset" >> $CFG_FILE
	echo "rom2_path notset" >> $CFG_FILE
	echo "rom_path_active 1" >> $CFG_FILE
	echo "exit_after_launch false" >> $CFG_FILE
	echo "machine C-Bios" >> $CFG_FILE
fi
# Set possible missing values
grep ^exec_path $CFG_FILE >/dev/null || echo "exec_path /opt/openmsx/bin" >> $CFG_FILE
grep ^bios_path $CFG_FILE >/dev/null || echo "bios_path $HOME/.openMSX/share/systemroms" >> $CFG_FILE
grep "^rom_path " $CFG_FILE >/dev/null || echo "rom_path notset" >> $CFG_FILE
grep ^rom2_path $CFG_FILE >/dev/null || echo "roms2_path notset" >> $CFG_FILE
grep ^rom_path_active $CFG_FILE >/dev/null || echo "roms_path_active 1" >> $CFG_FILE
grep ^exit_after_launch $CFG_FILE >/dev/null || echo "exit_after_lanch false" >> $CFG_FILE
grep ^machine $CFG_FILE >/dev/null || echo "machine C-Bios" >> $CFG_FILE

# start openmsx-gui
cd /opt/openmsx-gui/
python openmsx-gui.py
