
/*
 *
 * scene.h
 *
 * 3rd February 2009: Created scene.h from parts of scene.c
 *
 * Part of the OpenJazz project
 *
 *
 * Copyright (c) 2005-2010 Alister Thomson
 *
 * OpenJazz is distributed under the terms of
 * the GNU General Public License, version 2.0
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */


#ifndef _SCENE_H
#define _SCENE_H


#include <io/file.h>

#include <SDL/SDL.h>


// Enums

// These are the known script types
enum {

	ESceneMusic = 0x2A,
	ESceneFadeType = 0x3F,
	ESceneTextBlock = 0x40,
	ESceneTextColour = 0x41,
	ESceneFontFun = 0x45,
	ESceneFontIndex = 0x46,
	ESceneTextPosition = 0x47,
	ESceneTextAlign = 0x4A,
	ESceneTextAlign2 = 0x4B,
	ESceneBackground = 0x4c,
	ESceneBreaker = 0x50,
	ESceneSomethingElse = 0x51,
	ESceneTextRect = 0x57,
	ESceneFontDefine = 0x58,
	ESceneTime = 0x5d,
	ESceneTextLine = 0x5e,
	ESceneTextVAdjust = 0x5f,
	ESceneAnimationIndex = 0xA7,
	ESceneAnimationSetting = 0xA6,
	ESceneTextSetting = 0xb1,
	ESceneTextSomething = 0xd9,
	ESceneTextShadow = 0xdb

};


// Classes

class Font;

class SceneText {

	public:
		char     *text;
		int       alignment;
		int       fontId;
		int       x;
		int       y;
		SDL_Rect  textRect;
		int       extraLineHeight;

		SceneText  ();
		~SceneText ();

};

class ScenePage {

	public:
		int           backgrounds;
		int           bgIndex[30];
		unsigned int  bgPos[30];

		// Length of the scene in seconds, or if zero = anim complete, or 256 = user interaction
		int           pageTime;
		SceneText     texts[100];
		int           nTexts;
		char         *musicFile;
		int           paletteIndex;

		ScenePage();
		~ScenePage();

};

class SceneImage {

	public:
		SceneImage  *next;
		SDL_Surface *image;
		int id;

		SceneImage  (SceneImage *newNext);
		~SceneImage ();

};

class ScenePalette {

	public:
		ScenePalette *next;
		SDL_Color palette[256];
		int id;

		ScenePalette  (ScenePalette *newNext);
		~ScenePalette ();

};

class SceneFont {

	public:
		Font *font;
		int   id;

};

class Scene {

	private:
		SceneImage         *images;
		ScenePalette       *palettes;
		SceneFont           fonts[5];
		int                 nFonts;
		unsigned short int  scriptItems;
		unsigned short int  dataItems;
		signed long int    *scriptStarts;
		signed long int    *dataOffsets;

		// Scripts all information needed to render script pages, text etc
		ScenePage          *pages;

		void         loadScripts (File *f);
		void         loadData    (File *f);
		void         loadAni     (File* f, int dataIndex);

	public:
		Scene    (const char * fileName);
		~Scene   ();

		int play ();

};

#endif

