/** @file src/table/unitinfo.c UnitInfo file table. */

#include <stdio.h>
#include "types.h"

#include "../explosion.h"
#include "../house.h"
#include "../structure.h"
#include "../unit.h"
#include "strings.h"

const uint16 g_table_actionsAI[4] = {ACTION_HUNT, ACTION_AREA_GUARD, ACTION_AMBUSH, ACTION_GUARD};

UnitInfo g_table_unitInfo[UNIT_MAX] = {
	{ /* 0 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_CARRYALL,
		/* name                 */ "Carryall",
		/* stringID_full        */ STR_ALLPURPOSE_CARRYALL,
		/* wsa                  */ "carryall.wsa",
		{ /* flags */
		/* hasShadow            */ true,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 100,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 89,
		/* buildCredits         */ 800,
		/* buildTime            */ 64,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 16,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 20,
		/* priorityTarget       */ 16,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 0,
		/* indexEnd             */ 10,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ true,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 32,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 200,
		/* turningSpeed         */ 3,
		/* groundSpriteID       */ 283,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_STOP,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 0,
		/* damage               */ 0,
		/* explosionType        */ EXPLOSION_INVALID,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ 42
	},

	{ /* 1 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_THOPTER,
		/* name                 */ "'Thopter",
		/* stringID_full        */ STR_ORNITHIPTER,
		/* wsa                  */ "orni.wsa",
		{ /* flags */
		/* hasShadow            */ true,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 25,
		/* fogUncoverRadius     */ 5,
		/* spriteID             */ 97,
		/* buildCredits         */ 600,
		/* buildTime            */ 96,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_HOUSE_OF_IX,
		/* sortPriority         */ 28,
		/* upgradeLevelRequired */ 1,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 75,
		/* priorityTarget       */ 30,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ORDOS | FLAG_HOUSE_ATREIDES,
		},
		/* indexStart           */ 0,
		/* indexEnd             */ 10,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ true,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 24,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 7,
		/* movingSpeedFactor    */ 150,
		/* turningSpeed         */ 2,
		/* groundSpriteID       */ 289,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_STOP,
		/* displayMode          */ DISPLAYMODE_ORNITHOPTER,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 50,
		/* fireDistance         */ 50,
		/* damage               */ 50,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_MISSILE_TROOPER,
		/* bulletSound          */ 42
	},

	{ /* 2 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_INFANTRY,
		/* name                 */ "Infantry",
		/* stringID_full        */ STR_LIGHT_INFANTRY_SQUAD,
		/* wsa                  */ "infantry.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 50,
		/* fogUncoverRadius     */ 1,
		/* spriteID             */ 93,
		/* buildCredits         */ 100,
		/* buildTime            */ 32,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 4,
		/* upgradeLevelRequired */ 1,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 20,
		/* priorityTarget       */ 20,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ORDOS | FLAG_HOUSE_ATREIDES,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_FOOT,
		/* animationSpeed       */ 15,
		/* movingSpeedFactor    */ 5,
		/* turningSpeed         */ 3,
		/* groundSpriteID       */ 329,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_INFANTRY_4_FRAMES,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 45,
		/* fireDistance         */ 2,
		/* damage               */ 3,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 58
	},

	{ /* 3 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_TROOPERS,
		/* name                 */ "Troopers",
		/* stringID_full        */ STR_HEAVY_TROOPER_SQUAD,
		/* wsa                  */ "hyinfy.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ true,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 110,
		/* fogUncoverRadius     */ 1,
		/* spriteID             */ 103,
		/* buildCredits         */ 200,
		/* buildTime            */ 56,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 8,
		/* upgradeLevelRequired */ 1,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 50,
		/* priorityTarget       */ 50,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ORDOS | FLAG_HOUSE_HARKONNEN,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_FOOT,
		/* animationSpeed       */ 15,
		/* movingSpeedFactor    */ 10,
		/* turningSpeed         */ 3,
		/* groundSpriteID       */ 341,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_INFANTRY_4_FRAMES,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 50,
		/* fireDistance         */ 5,
		/* damage               */ 5,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 59
	},

	{ /* 4 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_SOLDIER,
		/* name                 */ "Soldier",
		/* stringID_full        */ STR_INFANTRY_SOLDIER,
		/* wsa                  */ "infantry.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 20,
		/* fogUncoverRadius     */ 1,
		/* spriteID             */ 102,
		/* buildCredits         */ 60,
		/* buildTime            */ 32,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 2,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 10,
		/* priorityTarget       */ 10,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ORDOS | FLAG_HOUSE_ATREIDES,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ true,
		/* isTracked            */ false,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_FOOT,
		/* animationSpeed       */ 12,
		/* movingSpeedFactor    */ 8,
		/* turningSpeed         */ 3,
		/* groundSpriteID       */ 311,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_INFANTRY_3_FRAMES,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 45,
		/* fireDistance         */ 2,
		/* damage               */ 3,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 58
	},

	{ /* 5 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_TROOPER,
		/* name                 */ "Trooper",
		/* stringID_full        */ STR_HEAVY_TROOPER,
		/* wsa                  */ "hyinfy.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ true,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 45,
		/* fogUncoverRadius     */ 1,
		/* spriteID             */ 88,
		/* buildCredits         */ 100,
		/* buildTime            */ 56,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 6,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 20,
		/* priorityTarget       */ 30,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ORDOS | FLAG_HOUSE_HARKONNEN,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ true,
		/* isTracked            */ false,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_FOOT,
		/* animationSpeed       */ 12,
		/* movingSpeedFactor    */ 15,
		/* turningSpeed         */ 3,
		/* groundSpriteID       */ 320,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_INFANTRY_3_FRAMES,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 50,
		/* fireDistance         */ 5,
		/* damage               */ 5,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 59
	},

	{ /* 6 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_SABOTEUR,
		/* name                 */ "Saboteur",
		/* stringID_full        */ STR_SABOTEUR,
		/* wsa                  */ "saboture.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 10,
		/* fogUncoverRadius     */ 1,
		/* spriteID             */ 96,
		/* buildCredits         */ 120,
		/* buildTime            */ 48,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_SABOTAGE, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 700,
		/* availableHouse       */ FLAG_HOUSE_ORDOS,
		},
		/* indexStart           */ 20,
		/* indexEnd             */ 21,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 8,
		/* movementType         */ MOVEMENT_FOOT,
		/* animationSpeed       */ 7,
		/* movingSpeedFactor    */ 40,
		/* turningSpeed         */ 3,
		/* groundSpriteID       */ 301,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_SABOTAGE,
		/* displayMode          */ DISPLAYMODE_INFANTRY_3_FRAMES,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 45,
		/* fireDistance         */ 2,
		/* damage               */ 2,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 58
	},

	{ /* 7 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_LAUNCHER,
		/* name                 */ "Launcher",
		/* stringID_full        */ STR_ROCKET_LAUNCHER,
		/* wsa                  */ "rtank.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ true,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 100,
		/* fogUncoverRadius     */ 5,
		/* spriteID             */ 85,
		/* buildCredits         */ 450,
		/* buildTime            */ 72,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 26,
		/* upgradeLevelRequired */ 2,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 100,
		/* priorityTarget       */ 150,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ATREIDES | FLAG_HOUSE_HARKONNEN,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_TRACKED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 30,
		/* turningSpeed         */ 1,
		/* groundSpriteID       */ 111,
		/* turretSpriteID       */ 146,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 162,
		/* fireDelay            */ 120,
		/* fireDistance         */ 9,
		/* damage               */ 75,
		/* explosionType        */ EXPLOSION_IMPACT_EXPLODE,
		/* bulletType           */ UNIT_MISSILE_ROCKET,
		/* bulletSound          */ -1
	},

	{ /* 8 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_DEVIATOR,
		/* name                 */ "Deviator",
		/* stringID_full        */ STR_DEVIATOR_LAUNCHER,
		/* wsa                  */ "ordrtank.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 120,
		/* fogUncoverRadius     */ 5,
		/* spriteID             */ 98,
		/* buildCredits         */ 750,
		/* buildTime            */ 80,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_HOUSE_OF_IX,
		/* sortPriority         */ 30,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 50,
		/* priorityTarget       */ 175,
		/* availableHouse       */ FLAG_HOUSE_ORDOS,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_TRACKED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 30,
		/* turningSpeed         */ 1,
		/* groundSpriteID       */ 111,
		/* turretSpriteID       */ 146,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 162,
		/* fireDelay            */ 180,
		/* fireDistance         */ 7,
		/* damage               */ 0,
		/* explosionType        */ EXPLOSION_IMPACT_EXPLODE,
		/* bulletType           */ UNIT_MISSILE_DEVIATOR,
		/* bulletSound          */ -1
	},

	{ /* 9 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_TANK,
		/* name                 */ "Tank",
		/* stringID_full        */ STR_COMBAT_TANK,
		/* wsa                  */ "ltank.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ true,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 200,
		/* fogUncoverRadius     */ 3,
		/* spriteID             */ 90,
		/* buildCredits         */ 300,
		/* buildTime            */ 64,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 22,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 80,
		/* priorityTarget       */ 100,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_TRACKED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 25,
		/* turningSpeed         */ 1,
		/* groundSpriteID       */ 111,
		/* turretSpriteID       */ 116,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 162,
		/* fireDelay            */ 80,
		/* fireDistance         */ 4,
		/* damage               */ 25,
		/* explosionType        */ EXPLOSION_IMPACT_MEDIUM,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 57
	},

	{ /* 10 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_SIEGE_TANK,
		/* name                 */ "Siege Tank",
		/* stringID_full        */ STR_HEAVY_SIEGE_TANK,
		/* wsa                  */ "htank.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ true,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 300,
		/* fogUncoverRadius     */ 4,
		/* spriteID             */ 84,
		/* buildCredits         */ 600,
		/* buildTime            */ 96,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 24,
		/* upgradeLevelRequired */ 3,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 130,
		/* priorityTarget       */ 150,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 24,
		/* movementType         */ MOVEMENT_TRACKED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 20,
		/* turningSpeed         */ 1,
		/* groundSpriteID       */ 121,
		/* turretSpriteID       */ 126,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 162,
		/* fireDelay            */ 90,
		/* fireDistance         */ 5,
		/* damage               */ 30,
		/* explosionType        */ EXPLOSION_IMPACT_MEDIUM,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 57
	},

	{ /* 11 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_DEVASTATOR,
		/* name                 */ "Devastator",
		/* stringID_full        */ STR_DEVASTATOR_TANK,
		/* wsa                  */ "harktank.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 400,
		/* fogUncoverRadius     */ 4,
		/* spriteID             */ 87,
		/* buildCredits         */ 800,
		/* buildTime            */ 104,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_HOUSE_OF_IX,
		/* sortPriority         */ 32,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_DESTRUCT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 175,
		/* priorityTarget       */ 180,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_HARKONNEN,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 24,
		/* movementType         */ MOVEMENT_TRACKED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 10,
		/* turningSpeed         */ 1,
		/* groundSpriteID       */ 131,
		/* turretSpriteID       */ 136,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 165,
		/* fireDelay            */ 100,
		/* fireDistance         */ 5,
		/* damage               */ 40,
		/* explosionType        */ EXPLOSION_IMPACT_MEDIUM,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 57
	},

	{ /* 12 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_SONIC_TANK,
		/* name                 */ "Sonic Tank",
		/* stringID_full        */ STR_SONIC_WAVE_TANK,
		/* wsa                  */ "stank.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 110,
		/* fogUncoverRadius     */ 4,
		/* spriteID             */ 91,
		/* buildCredits         */ 600,
		/* buildTime            */ 104,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_HOUSE_OF_IX,
		/* sortPriority         */ 34,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 80,
		/* priorityTarget       */ 110,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ATREIDES,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ true,
		/* canWobble            */ false,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_TRACKED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 30,
		/* turningSpeed         */ 1,
		/* groundSpriteID       */ 111,
		/* turretSpriteID       */ 141,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 162,
		/* fireDelay            */ 80,
		/* fireDistance         */ 8,
		/* damage               */ 60,
		/* explosionType        */ EXPLOSION_INVALID,
		/* bulletType           */ UNIT_SONIC_BLAST,
		/* bulletSound          */ 43
	},

	{ /* 13 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_TRIKE,
		/* name                 */ "Trike",
		/* stringID_full        */ STR_LIGHT_ATTACK_TRIKE,
		/* wsa                  */ "trike.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 100,
		/* fogUncoverRadius     */ 2,
		/* spriteID             */ 92,
		/* buildCredits         */ 150,
		/* buildTime            */ 40,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 10,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 50,
		/* priorityTarget       */ 50,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ATREIDES,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ true,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_WHEELED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 45,
		/* turningSpeed         */ 2,
		/* groundSpriteID       */ 243,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 50,
		/* fireDistance         */ 3,
		/* damage               */ 5,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 59
	},

	{ /* 14 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_RAIDER_TRIKE,
		/* name                 */ "Raider Trike",
		/* stringID_full        */ STR_FAST_RAIDER_TRIKE,
		/* wsa                  */ "otrike.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 80,
		/* fogUncoverRadius     */ 2,
		/* spriteID             */ 99,
		/* buildCredits         */ 150,
		/* buildTime            */ 40,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 12,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 55,
		/* priorityTarget       */ 60,
		/* availableHouse       */ FLAG_HOUSE_MERCENARY | FLAG_HOUSE_SARDAUKAR | FLAG_HOUSE_FREMEN | FLAG_HOUSE_ORDOS,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ true,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_WHEELED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 60,
		/* turningSpeed         */ 2,
		/* groundSpriteID       */ 243,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 50,
		/* fireDistance         */ 3,
		/* damage               */ 5,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 59
	},

	{ /* 15 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_QUAD,
		/* name                 */ "Quad",
		/* stringID_full        */ STR_HEAVY_ATTACK_QUAD,
		/* wsa                  */ "quad.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 130,
		/* fogUncoverRadius     */ 2,
		/* spriteID             */ 86,
		/* buildCredits         */ 200,
		/* buildTime            */ 48,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 14,
		/* upgradeLevelRequired */ 1,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_MOVE, ACTION_RETREAT, ACTION_GUARD },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 60,
		/* priorityTarget       */ 60,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ true,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ true,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_WHEELED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 40,
		/* turningSpeed         */ 2,
		/* groundSpriteID       */ 238,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 50,
		/* fireDistance         */ 3,
		/* damage               */ 7,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_BULLET,
		/* bulletSound          */ 59
	},

	{ /* 16 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_HARVESTER,
		/* name                 */ "Harvester",
		/* stringID_full        */ STR_SPICE_HARVESTER,
		/* wsa                  */ "harvest.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 128,
		/* hitpoints            */ 150,
		/* fogUncoverRadius     */ 2,
		/* spriteID             */ 100,
		/* buildCredits         */ 300,
		/* buildTime            */ 64,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 18,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_HARVEST, ACTION_MOVE, ACTION_RETURN, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 10,
		/* priorityTarget       */ 150,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 24,
		/* movementType         */ MOVEMENT_HARVESTER,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 20,
		/* turningSpeed         */ 1,
		/* groundSpriteID       */ 248,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HARVEST,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 165,
		/* fireDelay            */ 0,
		/* fireDistance         */ 0,
		/* damage               */ 0,
		/* explosionType        */ EXPLOSION_INVALID,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ 0
	},

	{ /* 17 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_MCV,
		/* name                 */ "MCV",
		/* stringID_full        */ STR_MOBILE_CONST_VEHICLE,
		/* wsa                  */ "mcv.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ true,
		/* noMessageOnDeath     */ false,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ false,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 64,
		/* hitpoints            */ 150,
		/* fogUncoverRadius     */ 2,
		/* spriteID             */ 101,
		/* buildCredits         */ 900,
		/* buildTime            */ 80,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 20,
		/* upgradeLevelRequired */ 1,
		/* actionsPlayer        */ { ACTION_DEPLOY, ACTION_MOVE, ACTION_RETREAT, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 10,
		/* priorityTarget       */ 150,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 22,
		/* indexEnd             */ 101,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ true,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ false,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ true
		},
		/* dimension            */ 24,
		/* movementType         */ MOVEMENT_TRACKED,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 20,
		/* turningSpeed         */ 1,
		/* groundSpriteID       */ 253,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_HUNT,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 0,
		/* damage               */ 0,
		/* explosionType        */ EXPLOSION_INVALID,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ 0
	},

	{ /* 18 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_NULL,
		/* name                 */ "Death Hand",
		/* stringID_full        */ STR_NULL,
		/* wsa                  */ "gold-bb.wsa",
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ false
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 70,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 0,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_HARKONNEN,
		},
		/* indexStart           */ 12,
		/* indexEnd             */ 15,
		{ /* flags */
		/* isBullet             */ true,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 32,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 250,
		/* turningSpeed         */ 2,
		/* groundSpriteID       */ 278,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_ROCKET,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 15,
		/* damage               */ 100,
		/* explosionType        */ EXPLOSION_DEATH_HAND,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ 42
	},

	{ /* 19 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_NULL,
		/* name                 */ "Rocket",
		/* stringID_full        */ STR_NULL,
		/* wsa                  */ NULL,
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ false
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 70,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 0,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 12,
		/* indexEnd             */ 15,
		{ /* flags */
		/* isBullet             */ true,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ true,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ true,
		/* notAccurate          */ true,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 7,
		/* movingSpeedFactor    */ 200,
		/* turningSpeed         */ 2,
		/* groundSpriteID       */ 258,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_ROCKET,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 8,
		/* damage               */ 75,
		/* explosionType        */ EXPLOSION_IMPACT_EXPLODE,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ 42
	},

	{ /* 20 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_NULL,
		/* name                 */ "ARocket",
		/* stringID_full        */ STR_NULL,
		/* wsa                  */ NULL,
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ false
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 70,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 0,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 12,
		/* indexEnd             */ 15,
		{ /* flags */
		/* isBullet             */ true,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ true,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ true,
		/* notAccurate          */ false,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 7,
		/* movingSpeedFactor    */ 160,
		/* turningSpeed         */ 8,
		/* groundSpriteID       */ 258,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_ROCKET,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 60,
		/* damage               */ 75,
		/* explosionType        */ EXPLOSION_IMPACT_EXPLODE,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ 42
	},

	{ /* 21 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_NULL,
		/* name                 */ "GRocket",
		/* stringID_full        */ STR_NULL,
		/* wsa                  */ NULL,
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ false
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 70,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 0,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 12,
		/* indexEnd             */ 15,
		{ /* flags */
		/* isBullet             */ true,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ true,
		/* notAccurate          */ true,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 16,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 7,
		/* movingSpeedFactor    */ 200,
		/* turningSpeed         */ 2,
		/* groundSpriteID       */ 258,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_ROCKET,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 7,
		/* damage               */ 75,
		/* explosionType        */ EXPLOSION_DEVIATOR_GAS,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ 42
	},

	{ /* 22 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_NULL,
		/* name                 */ "MiniRocket",
		/* stringID_full        */ STR_NULL,
		/* wsa                  */ NULL,
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ false
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 70,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 0,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 12,
		/* indexEnd             */ 15,
		{ /* flags */
		/* isBullet             */ true,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ true,
		/* notAccurate          */ false,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 8,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 7,
		/* movingSpeedFactor    */ 180,
		/* turningSpeed         */ 5,
		/* groundSpriteID       */ 268,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_ROCKET,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 3,
		/* damage               */ 0,
		/* explosionType        */ EXPLOSION_MINI_ROCKET,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ 64
	},

	{ /* 23 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_NULL,
		/* name                 */ "Bullet",
		/* stringID_full        */ STR_NULL,
		/* wsa                  */ NULL,
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ false
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 1,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 0,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 12,
		/* indexEnd             */ 15,
		{ /* flags */
		/* isBullet             */ true,
		/* explodeOnDeath       */ true,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 8,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 250,
		/* turningSpeed         */ 0,
		/* groundSpriteID       */ 174,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_SINGLE_FRAME,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 0,
		/* damage               */ 0,
		/* explosionType        */ EXPLOSION_IMPACT_SMALL,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ -1
	},

	{ /* 24 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_NULL,
		/* name                 */ "Sonic Blast",
		/* stringID_full        */ STR_NULL,
		/* wsa                  */ NULL,
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ true,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ false
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 1,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 0,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 12,
		/* indexEnd             */ 15,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 32,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 7,
		/* movingSpeedFactor    */ 200,
		/* turningSpeed         */ 0,
		/* groundSpriteID       */ 160,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_SINGLE_FRAME,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 10,
		/* damage               */ 25,
		/* explosionType        */ EXPLOSION_INVALID,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ -1
	},

	{ /* 25 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_SANDWORM,
		/* name                 */ "Sandworm",
		/* stringID_full        */ STR_SANDWORM2,
		/* wsa                  */ NULL,
		{ /* flags */
		/* hasShadow            */ false,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ true,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ true,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 1000,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 105,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_ATTACK, ACTION_ATTACK, ACTION_ATTACK, ACTION_ATTACK },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_FREMEN,
		},
		/* indexStart           */ 16,
		/* indexEnd             */ 17,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ true,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 24,
		/* movementType         */ MOVEMENT_SLITHER,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 35,
		/* turningSpeed         */ 3,
		/* groundSpriteID       */ 161,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 20,
		/* fireDistance         */ 0,
		/* damage               */ 300,
		/* explosionType        */ EXPLOSION_SANDWORM_SWALLOW,
		/* bulletType           */ UNIT_SANDWORM,
		/* bulletSound          */ 63
	},

	{ /* 26 */
		{ /* objectInfo */
		/* stringID_abbrev      */ STR_NULL,
		/* name                 */ "Frigate",
		/* stringID_full        */ STR_NULL,
		/* wsa                  */ NULL,
		{ /* flags */
		/* hasShadow            */ true,
		/* factory              */ false,
		/* notOnConcrete        */ false,
		/* busyStateIsIncoming  */ false,
		/* blurTile             */ false,
		/* hasTurret            */ false,
		/* conquerable          */ false,
		/* canBePickedUp        */ false,
		/* noMessageOnDeath     */ true,
		/* tabSelectable        */ false,
		/* scriptNoSlowdown     */ true,
		/* targetAir            */ false,
		/* priority             */ true
		},
		/* spawnChance          */ 0,
		/* hitpoints            */ 100,
		/* fogUncoverRadius     */ 0,
		/* spriteID             */ 0,
		/* buildCredits         */ 0,
		/* buildTime            */ 0,
		/* availableCampaign    */ 0,
		/* structuresRequired   */ FLAG_STRUCTURE_NONE,
		/* sortPriority         */ 0,
		/* upgradeLevelRequired */ 0,
		/* actionsPlayer        */ { ACTION_STOP, ACTION_STOP, ACTION_STOP, ACTION_STOP },
		/* available            */ 0,
		/* hintStringID         */ STR_NULL,
		/* priorityBuild        */ 0,
		/* priorityTarget       */ 0,
		/* availableHouse       */ FLAG_HOUSE_ALL,
		},
		/* indexStart           */ 11,
		/* indexEnd             */ 11,
		{ /* flags */
		/* isBullet             */ false,
		/* explodeOnDeath       */ false,
		/* sonicProtection      */ false,
		/* canWobble            */ false,
		/* isTracked            */ false,
		/* isGroundUnit         */ false,
		/* mustStayInMap        */ false,
		/* firesTwice           */ false,
		/* impactOnSand         */ false,
		/* isNotDeviatable      */ true,
		/* hasAnimationSet      */ false,
		/* notAccurate          */ false,
		/* isNormalUnit         */ false
		},
		/* dimension            */ 32,
		/* movementType         */ MOVEMENT_WINGER,
		/* animationSpeed       */ 0,
		/* movingSpeedFactor    */ 130,
		/* turningSpeed         */ 2,
		/* groundSpriteID       */ 298,
		/* turretSpriteID       */ -1,
		/* actionAI             */ ACTION_INVALID,
		/* displayMode          */ DISPLAYMODE_UNIT,
		/* destroyedSpriteID    */ 0,
		/* fireDelay            */ 0,
		/* fireDistance         */ 0,
		/* damage               */ 0,
		/* explosionType        */ EXPLOSION_INVALID,
		/* bulletType           */ UNIT_INVALID,
		/* bulletSound          */ -1
	}
};
