/* $Id: endian.h 1051 2010-04-04 20:43:30Z truebrain $ */

#ifndef OS_ENDIAN_H
#define OS_ENDIAN_H

#if defined(_WIN32)
	#define __BYTE_ORDER __LITTLE_ENDIAN
	#if defined(_MSC_VER)
		static uint32 __builtin_bswap32(uint32 x)
		{
			__asm {
				mov eax, x;
				bswap eax;
			}
		}
	#endif /* _MSC_VER */
#elif defined(__APPLE__)
	#include <machine/endian.h>
#else
	#include <endian.h>
	#ifdef __arm__
		static __inline__ uint32 __builtin_bswap32(uint32 val)
		{
			__asm__ volatile (
				"eor     r3, %1, %1, ror #16\n\t"
				"bic     r3, r3, #0x00FF0000\n\t"
				"mov     %0, %1, ror #8\n\t"
				"eor     %0, %0, r3, lsr #8"
				: "=r" (val)
				: "0"(val)
				: "r3" 
			);
			return val;
		}
	#else
		static __inline__ uint32 __builtin_bswap32(uint32 val)
		{
			__asm__ volatile (
				"movl %1, %%eax\n"
				"bswap %%eax\n"
				"movl %%eax, %0;"
				: "=r" (val)
				: "r" (val)
				: "%eax"
			);
			return val;
		}
	#endif
#endif /* _WIN32 */

#if __BYTE_ORDER == __LITTLE_ENDIAN
	#define HTOBE32(x) __builtin_bswap32(x)
	#define BETOH32(x) __builtin_bswap32(x)
	#define HTOBE16(x) (__builtin_bswap32(x) >> 16)
	#define BETOH16(x) (__builtin_bswap32(x) >> 16)
#else
	#define HTOBE32(x) (x)
	#define BETOH32(x) (x)
	#define BETOH16(x) (x)
	#define BETOH16(x) (x)
#endif

#endif /* OS_ENDIAN_H */
