#!/usr/bin/env python

import logging
import pygame

import config


_moduleLogger = logging.getLogger(__name__)


SUPER_STATE_START = pygame.USEREVENT + 1
SUPER_STATE_OVER = SUPER_STATE_START + 1
PLAYER_EATEN = SUPER_STATE_OVER + 1


class purpleMan(pygame.sprite.Sprite):

	def __init__(self, centerPoint, level, cache):
		pygame.sprite.Sprite.__init__(self)
		self._cache = cache

		path = level.data.get_cell_image("P", "")
		img = self._cache.get_item("image", path)
		self._normal_image = img

		path = level.data.get_cell_image("P", "chomped")
		img = self._cache.get_item("image", path)
		self._closed_image = img

		self._image = self._normal_image
		self._rect = self._image.get_rect()
		self._rect.center = centerPoint
		config.purpleHits = 0
		self._openclosed = 1
		self.rect.inflate_ip(-6, -6)
		self._original_rect = pygame.Rect(self.rect)
		self.lives = config.lives
		self.pellets = 0
		self.supers = 0
		self.superState = False

		self._x_dist = config.player_speed
		self._y_dist = config.player_speed
		self._xMove = 0
		self._yMove = 0
		self._hdirect = 2
		self._vdirect = 0

		if config.gameSound:
			path = level.data.get_action_sound("bite")
			snd = self._cache.get_item("sound", path)
			self._biteSound = snd
			path = level.data.get_action_sound("super")
			snd = self._cache.get_item("sound", path)
			self._superSound = snd
			path = level.data.get_action_sound("kill")
			snd = self._cache.get_item("sound", path)
			self._killSound = snd
		else:
			self._biteSound = None
			self._superSound = None
			self._killSound = None

	@property
	def image(self):
		# Used by pygame
		return self._image

	@property
	def rect(self):
		# Used by pygame
		return self._rect

	def OpenAndClose(self):
		if self._openclosed == 1:
			self._image = self._closed_image
			self._openclosed = 2
		else:
			self._image = self._normal_image
			self._openclosed = 1
		if self._hdirect == 1:
			self._image = pygame.transform.flip(self.image, 1, 0)
		if self._vdirect == 2:
			if self._hdirect == 1:
				self._image = pygame.transform.rotate(self.image, -90)
			elif self._hdirect == 2:
				self._image = pygame.transform.rotate(self.image, 90)
		elif self._vdirect == 1:
			if self._hdirect == 1:
				self._image = pygame.transform.rotate(self.image, 90)
			if self._hdirect == 2:
				self._image = pygame.transform.rotate(self.image, -90)

	def MoveKeyDown(self, key):
		if (key == pygame.locals.K_f):
			self._xMove = self._x_dist
			if self._hdirect == 1:
				self._image = pygame.transform.flip(self.image, 1, 0)
				self._hdirect = 2
		elif (key == pygame.locals.K_s):
			self._xMove = -self._x_dist
			if self._hdirect == 2:
				self._image = pygame.transform.flip(self.image, 1, 0)
				self._hdirect = 1
		elif (key == pygame.locals.K_e):
			self._yMove = -self._y_dist
			if self._vdirect == 0:
				if self._hdirect == 2:
					self._image = pygame.transform.rotate(self.image, 90)
				if self._hdirect == 1:
					self._image = pygame.transform.rotate(self.image, -90)
			self._vdirect = 2
		elif (key == pygame.locals.K_c):
			self._yMove = self._y_dist
			if self._vdirect == 0:
				if self._hdirect == 2:
					self._image = pygame.transform.rotate(self.image, -90)
				if self._hdirect == 1:
					self._image = pygame.transform.rotate(self.image, 90)
			self._vdirect = 1

	def MoveKeyUp(self, key):
		if self._openclosed == 2:
			self.OpenAndClose()
		if (key == pygame.locals.K_f):
			if 0 < self._xMove:
				self._xMove = 0
		elif (key == pygame.locals.K_s):
			if self._xMove < 0:
				self._xMove = 0
		elif (key == pygame.locals.K_e):
			if self._yMove < 0:
				self._yMove = 0
			if self._hdirect == 2:
				self._image = pygame.transform.rotate(self.image, -90)
			if self._hdirect == 1:
				self._image = pygame.transform.rotate(self.image, 90)
			self._vdirect = 0
		elif (key == pygame.locals.K_c):
			if 0 < self._yMove:
				self._yMove = 0
			if self._hdirect == 2:
				self._image = pygame.transform.rotate(self.image, 90)
			if self._hdirect == 1:
				self._image = pygame.transform.rotate(self.image, -90)
			self._vdirect = 0

	def update(self, block_group, pellet_group, super_pellet_group, monster_group):
		hasMoved = self._xMove !=0 or self._yMove != 0
		if hasMoved:
			self.rect.move_ip(self._xMove, self._yMove)
			if pygame.sprite.spritecollideany(self, block_group):
				self.rect.move_ip(-self._xMove, -self._yMove)

		lst_monsters = pygame.sprite.spritecollide(self, monster_group, False)
		if lst_monsters:
			self.MonsterCollide(lst_monsters)
			return

		if not hasMoved:
			# small bit of an optimization
			return

		lstCols = pygame.sprite.spritecollide(self, pellet_group, True)
		if lstCols:
			self.pellets += len(lstCols)
			self.OpenAndClose()
			if config.gameSound:
				self._biteSound.play(loops=0, maxtime=0, fade_ms=0)
			return

		lstSupers = pygame.sprite.spritecollide(self, super_pellet_group, True)
		if lstSupers:
			self.superState = True
			self.supers += 1
			if config.gameSound:
				self._superSound.play(loops=0, maxtime=0, fade_ms=0)
			pygame.event.post(pygame.event.Event(SUPER_STATE_START, {}))
			pygame.time.set_timer(SUPER_STATE_OVER, 0)
			pygame.time.set_timer(SUPER_STATE_OVER, 8000)
			return

	def MonsterCollide(self, lstMonsters):
		for monster in lstMonsters:
			if monster.scared:
				monster.Eaten()
				config.purpleHits += 1
				if config.gameSound:
					self._killSound.play(loops=0, maxtime=0, fade_ms=0)
			else:
				self._openclosed = 2
				self.OpenAndClose()
				self.lives -= 1
				if self.lives >= 1:
					self._rect = self._original_rect
				if config.players == 2:
					if self.lives == 0:
						self._rect = self.rect.move(-800, -800)
				if config.gameSound:
					self._killSound.play(loops=0, maxtime=0, fade_ms=0)
				pygame.event.post(pygame.event.Event(PLAYER_EATEN, {}))
