#!/usr/bin/env python

from __future__ import with_statement
from __future__ import division

import logging


_moduleLogger = logging.getLogger(__name__)


class ItemCache(object):

	def __init__(self):
		self._cache = {}

	def add_item(self, category, key, item):
		self._category_check(category)
		self._cache[category][key] = item

	def get_item(self, category, key):
		return self._cache[category][key]

	def is_present(self, category, key):
		try:
			return self._cache[category][key] is not None
		except KeyError:
			return False

	def clear_category(self, category):
		if category in self._cache:
			del self._cache[category]

	def clear_cache(self):
		self._cache.clear()

	def _category_check(self, category):
		if category not in self._cache:
			self._cache[category] = {}


if __name__ == "__main__":
	pass

