#!/usr/bin/env python

from __future__ import with_statement
from __future__ import division

import logging

from PyQt4 import QtGui
from PyQt4 import QtCore

import constants
from util import qui_utils
from util import misc as misc_utils
_moduleLogger = logging.getLogger(__name__)


class SettingsDialog(object):

	def __init__(self, app):
		self._musicCheckbox = QtGui.QCheckBox("Music")
		self._musicCheckbox.setCheckState(QtCore.Qt.Unchecked)
		self._musicCheckbox.setEnabled(False)
		self._effectsCheckbox = QtGui.QCheckBox("Sound Effects")

		# @todo Simplify this and make it a part of the campaign results (beat level X on Y difficulty
		# Another difficulty variation is enemy UI
		self._playerLives = QtGui.QSpinBox()
		self._playerLives.setMinimum(1)
		self._playerLives.setMaximum(2)
		self._playerLives.setProperty("value", 2)
		self._playerSpeed = QtGui.QSpinBox()
		self._playerSpeed.setMinimum(1)
		self._playerSpeed.setMaximum(20)
		self._playerSpeed.setProperty("value", 8)
		self._enemySpeed = QtGui.QSpinBox()
		self._enemySpeed.setMinimum(1)
		self._enemySpeed.setMaximum(20)
		self._enemySpeed.setProperty("value", 6)

		self._settingsLayout = QtGui.QGridLayout()
		self._settingsLayout.addWidget(QtGui.QLabel("Sound"), 0, 0)
		self._settingsLayout.addWidget(self._musicCheckbox, 1, 1)
		self._settingsLayout.addWidget(self._effectsCheckbox, 2, 1)

		self._settingsLayout.addWidget(QtGui.QLabel("Difficulty"), 3, 0)
		self._settingsLayout.addWidget(QtGui.QLabel("Player Lives"), 4, 0)
		self._settingsLayout.addWidget(self._playerLives, 4, 1)
		self._settingsLayout.addWidget(QtGui.QLabel("Player Speed"), 5, 0)
		self._settingsLayout.addWidget(self._playerSpeed, 5, 1)
		self._settingsLayout.addWidget(QtGui.QLabel("Enemy Speed"), 6, 0)
		self._settingsLayout.addWidget(self._enemySpeed, 6, 1)

		self._entryWidget = QtGui.QWidget()
		self._entryWidget.setLayout(self._settingsLayout)
		self._entryWidget.setContentsMargins(0, 0, 0, 0)
		self._scrollEntry = QtGui.QScrollArea()
		self._scrollEntry.setWidget(self._entryWidget)
		self._scrollEntry.setWidgetResizable(True)
		self._scrollEntry.setVerticalScrollBarPolicy(QtCore.Qt.ScrollBarAsNeeded)
		self._scrollEntry.setHorizontalScrollBarPolicy(QtCore.Qt.ScrollBarAlwaysOff)

		self._applyButton = QtGui.QPushButton("&Apply")
		self._buttonLayout = QtGui.QDialogButtonBox(QtGui.QDialogButtonBox.Cancel)
		self._buttonLayout.addButton(self._applyButton, QtGui.QDialogButtonBox.AcceptRole)

		self._layout = QtGui.QVBoxLayout()
		self._layout.addWidget(self._scrollEntry)
		self._layout.addWidget(self._buttonLayout)

		self._dialog = QtGui.QDialog()
		self._dialog.setWindowTitle("Settings")
		self._dialog.setLayout(self._layout)
		self._buttonLayout.accepted.connect(self._dialog.accept)
		self._buttonLayout.rejected.connect(self._dialog.reject)

		self._closeWindowAction = QtGui.QAction(None)
		self._closeWindowAction.setText("Close")
		self._closeWindowAction.setShortcut(QtGui.QKeySequence("CTRL+w"))
		self._closeWindowAction.triggered.connect(self._on_close_window)

		self._dialog.addAction(self._closeWindowAction)
		self._dialog.addAction(app.quitAction)
		self._dialog.addAction(app.fullscreenAction)

	def _is_music_enabled(self):
		return self._musicCheckbox.isChecked()

	def _enable_music(self, isEnabled):
		self._musicCheckbox.setChecked(isEnabled)

	musicEnabled = property(_is_music_enabled, _enable_music)

	def _is_effects_enabled(self):
		return self._effectsCheckbox.isChecked()

	def _enable_effects(self, isEnabled):
		self._effectsCheckbox.setChecked(isEnabled)

	effectsEnabled = property(_is_effects_enabled, _enable_effects)

	def _get_player_lives(self):
		return self._playerLives.value()

	def _set_player_lives(self, value):
		self._playerLives.setValue(value)

	playerLives = property(_get_player_lives, _set_player_lives)

	def _get_player_speed(self):
		return self._playerSpeed.value()

	def _set_player_speed(self, value):
		self._playerSpeed.setValue(value)

	playerSpeed = property(_get_player_speed, _set_player_speed)

	def _get_enemy_speed(self):
		return self._enemySpeed.value()

	def _set_enemy_speed(self, value):
		self._enemySpeed.setValue(value)

	enemySpeed = property(_get_enemy_speed, _set_enemy_speed)

	def run(self, parent=None):
		self._dialog.setParent(parent, QtCore.Qt.Dialog)

		response = self._dialog.exec_()
		return response

	def close(self):
		try:
			self._dialog.reject()
		except RuntimeError:
			_moduleLogger.exception("Oh well")

	@misc_utils.log_exception(_moduleLogger)
	def _on_close_window(self, checked = True):
		with qui_utils.notify_error(self._app.errorLog):
			self._dialog.reject()


class AboutDialog(object):

	def __init__(self, app):
		self._title = QtGui.QLabel(
			"<h1>%s</h1><h3>Version: %s</h3>" % (
				constants.__pretty_app_name__, constants.__version__
			)
		)
		self._title.setTextFormat(QtCore.Qt.RichText)
		self._title.setAlignment(QtCore.Qt.AlignCenter)
		self._copyright = QtGui.QLabel("<h6>Developed by Luke Thomas and Ed Page<h6>")
		self._copyright.setTextFormat(QtCore.Qt.RichText)
		self._copyright.setAlignment(QtCore.Qt.AlignCenter)
		self._link = QtGui.QLabel('<a href="http://talk.maemo.org/showthread.php?t=67508">Website</a>')
		self._link.setTextFormat(QtCore.Qt.RichText)
		self._link.setAlignment(QtCore.Qt.AlignCenter)
		self._link.setOpenExternalLinks(True)

		self._buttonLayout = QtGui.QDialogButtonBox(QtGui.QDialogButtonBox.Cancel)

		self._layout = QtGui.QVBoxLayout()
		self._layout.addWidget(self._title)
		self._layout.addWidget(self._copyright)
		self._layout.addWidget(self._link)
		self._layout.addWidget(self._buttonLayout)

		self._dialog = QtGui.QDialog()
		self._dialog.setWindowTitle("About")
		self._dialog.setLayout(self._layout)
		self._buttonLayout.rejected.connect(self._dialog.reject)

		self._closeWindowAction = QtGui.QAction(None)
		self._closeWindowAction.setText("Close")
		self._closeWindowAction.setShortcut(QtGui.QKeySequence("CTRL+w"))
		self._closeWindowAction.triggered.connect(self._on_close_window)

		self._dialog.addAction(self._closeWindowAction)
		self._dialog.addAction(app.quitAction)
		self._dialog.addAction(app.fullscreenAction)

	def run(self, parent=None):
		self._dialog.setParent(parent, QtCore.Qt.Dialog)

		response = self._dialog.exec_()
		return response

	def close(self):
		try:
			self._dialog.reject()
		except RuntimeError:
			_moduleLogger.exception("Oh well")

	@QtCore.pyqtSlot()
	@QtCore.pyqtSlot(bool)
	@misc_utils.log_exception(_moduleLogger)
	def _on_close_window(self, checked = True):
		with qui_utils.notify_error(self._app.errorLog):
			self._dialog.reject()


if __name__ == "__main__":
	pass

