/*
* ============================================================================
*  Name     : CGameAppUi from GameAppUi.cpp
*  Part of  : Game
*  Created  : 31.1.2004 by Sami Kystil
*  Implementation notes:
*     Initial content was generated by Series 60 AppWizard.
*  Version  :
*  Copyright: Sami Kystil
* ============================================================================
*/

// INCLUDE FILES
#include "GameAppUi.h"
#include "GameContainer.h" 
#include "GameEng.h"
#include "GameImageLoader.h"
#include <N-Speed.rsg>
#include "N-Speed.hrh"
#include "Config.h"

#include <avkon.hrh>
#include <reent.h>
#include <hal.h>
#include <stdio.h>
#include <sys/stat.h>

// ================= MEMBER FUNCTIONS =======================
//
// ----------------------------------------------------------
// CGameAppUi::ConstructL()
// ?implementation_description
// ----------------------------------------------------------
//
void CGameAppUi::ConstructL()
{
        BaseConstructL();

        TInt period;
        User::LeaveIfError(HAL::Get(HALData::ESystemTickPeriod, period));
        iTimerFreq = 1000000 / period;
		iTimerBase = User::TickCount();

        iEngine = Game::CreateEngine(this, 0, NULL);

        iAppContainer = new (ELeave) CGameContainer(iEngine);
        iAppContainer->SetMopParent(this);
        iAppContainer->ConstructL();
        AddToStackL(iAppContainer);

        CAknAppUi::SetKeyBlockMode(ENoKeyBlock);

        iAppContainer->StartDrawingL();
}

// ----------------------------------------------------
// CGameAppUi::~CGameAppUi()
// Destructor
// Frees reserved resources
// ----------------------------------------------------
//
CGameAppUi::~CGameAppUi()
{
        if (iAppContainer)
        {
                RemoveFromStack( iAppContainer );
                delete iAppContainer;
        }

        delete iEngine;

	CloseSTDLIB();
 }

// ------------------------------------------------------------------------------
// CGameAppUi::::DynInitMenuPaneL(TInt aResourceId,CEikMenuPane* aMenuPane)
//  This function is called by the EIKON framework just before it displays
//  a menu pane. Its default implementation is empty, and by overriding it,
//  the application can set the state of menu items dynamically according
//  to the state of application data.
// ------------------------------------------------------------------------------
//
void CGameAppUi::DynInitMenuPaneL(
    TInt /*aResourceId*/,CEikMenuPane* /*aMenuPane*/)
{
}

TKeyResponse CGameAppUi::HandleKeyEventL(
    const TKeyEvent& aKeyEvent,TEventCode aType)
{
        Game::Event event;

	if (!iAppContainer->iGameEng)
		return EKeyWasNotConsumed;

        if(!iAppContainer->iGameEng->Drawing())
        {
                if (aType == EEventKeyDown)
                {
                        iAppContainer->StartDrawingL();
                        return EKeyWasConsumed;
                }
                return EKeyWasNotConsumed;
        }

        switch(aType)
        {
        case EEventKeyDown:
                event.type = Game::Event::KeyPressEvent;
        break;
        case EEventKeyUp:
                event.type = Game::Event::KeyReleaseEvent;
        break;
        case EEventKey:
                event.type = Game::Event::KeyEvent;
        break;
        }

        event.key.code = aKeyEvent.iScanCode;
        iEngine->handleEvent(&event);

    return EKeyWasConsumed;
}

void CGameAppUi::HandleCommandL(TInt aCommand)
{
        switch ( aCommand )
        {
        case EEikCmdExit:
        {
                Game::Event event(Game::Event::ExitEvent);
                iEngine->handleEvent(&event);
                Exit();
                break;
        }
    default:
        break;      
    }
}

void CGameAppUi::exit()
{
        Exit();
}

unsigned int CGameAppUi::getTickCount()
{
        return User::TickCount() - iTimerBase;
}

unsigned int CGameAppUi::getTicksPerSecond()
{
        return iTimerFreq;
}

Game::Surface *CGameAppUi::loadImage(const char *name, Game::PixelFormat *pf)
{
	return CGameImageLoader::LoadImageL(GetFilenameDes(name),pf);
}

Game::SampleChunk *CGameAppUi::loadSample(const char *name, Game::SampleFormat *sf)
{
#ifdef _MSC_VER
#pragma pack(push, 1)
#endif
	typedef struct
	{
		unsigned int chunkID;
		unsigned int chunkSize;
		unsigned int format;
		unsigned int subChunk1ID;
		unsigned int subChunk1Size;
		unsigned short audioFormat;
		unsigned short numChannels;
		unsigned int sampleRate;
		unsigned int byteRate;
		unsigned short blockAlign;
		unsigned short bitsPerSample;
		unsigned int subChunk2ID;
		unsigned int subChunk2Size;
	} PACKED WaveHeader;
#ifdef _MSC_VER
#pragma pack(pop)
#endif

	FILE *f = fopen(name, "rb");
	Game::SampleChunk *sample = 0;
	
	if (f)
	{
		WaveHeader header;
		
		fread(&header, sizeof(WaveHeader), 1, f);
		
		if (header.audioFormat == 1)
		{
			Game::SampleFormat wavsf(header.bitsPerSample, header.numChannels);
			int samples = header.subChunk2Size / (header.numChannels * (header.bitsPerSample/8));
			int n, ch;
			
			if (sf)
				sample = new Game::SampleChunk(sf, samples, header.sampleRate);
			else
				sample = new Game::SampleChunk(&wavsf, samples, header.sampleRate);
			
			for(n=0; n<samples; n++)
			for(ch=0; ch<header.numChannels; ch++)
			{
				switch(header.bitsPerSample)
				{
				case 8:
				{
					Game::Sample8 s;
					fread(&s, sizeof(s), 1, f);
                    s+=0x80;
					sample->setSample(n,ch,sample->format.makeSample(s<<8));
				}
				break;
				case 16:
				{
					Game::Sample16 s;
					fread(&s, sizeof(s), 1, f);
                    s+=0x8000;
					sample->setSample(n,ch,sample->format.makeSample(s));
				}
				break;
				}
			}
		}
		
		fclose(f);
	}
	return sample;
}

TDesC& CGameAppUi::GetFilenameDes(const char *name)
{
	// hack: convert filename to unicode
	TText16 unicode[512];
	TText16 *t = unicode;
	const TText8 *s = (TText8*)name;

	while (*s)
		*t++ = (TText16)*s++;
	*t = 0;

	iResourcePathBuf = (TText*)unicode;
	return iResourcePathBuf;
}

const char *CGameAppUi::findResource(const char *name, bool mustExist)
{
	int i = 0;
	const char drive[] = {'c', 'd', 'e', 'z'};
	char *s;
	struct stat fileStat;

	for(i=0; i<sizeof(drive); i++)
	{
		sprintf(iResourcePath, "%c:\\system\\apps\\" PROGRAM "\\%.128s", drive[i], name);

		// replace forward slashes with backslashes
		s = iResourcePath;
		while(*s)
		{
			if (*s == '/') *s = '\\';
			s++;
		}

		if (!mustExist || stat(iResourcePath, &fileStat) == 0)
		{
			return iResourcePath;
		}
	}
	return "";
}

