/*
 *  Nameday desktop applet (widget) for Maemo.
 *  Copyright (C) 2009 Roman Moravcik
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NAMEDAY_APPLET_H
#define NAMEDAY_APPLET_H

#include <glib-object.h>
#include <libhildondesktop/libhildondesktop.h>

#include <libxml/parser.h>

#include <gconf/gconf-client.h>

#define DATADIR "/usr/share"

G_BEGIN_DECLS

typedef struct _NamedayDesktopApplet NamedayDesktopApplet;
typedef struct _NamedayDesktopAppletClass NamedayDesktopAppletClass;

#define NAMEDAY_TYPE_DESKTOP_APPLET   (nameday_desktop_applet_get_type ())

#define NAMEDAY_DESKTOP_APPLET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
                        NAMEDAY_TYPE_DESKTOP_APPLET, NamedayDesktopApplet))

#define NAMEDAY_DESKTOP_APPLET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
                        NAMEDAY_TYPE_DESKTOP_APPLET, NamedayDesktopAppletClass))

#define NAMEDAY_IS_DESKTOP_PLUGIN(obj)  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
                        NAMEDAY_TYPE_DESKTOP_APPLET))

#define NAMEDAY_IS_DESKTOP_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), \
                        NAMEDAY_TYPE_DESKTOP_APPLET))

#define NAMEDAY_DESKTOP_APPLET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), \
                        NAMEDAY_TYPE_DESKTOP_APPLET, NamedayDesktopAppletClass))

struct _NamedayDesktopApplet
{
	HDHomePluginItem hitem;

	xmlDocPtr db;
	gchar *db_filename;
	GConfClient *gconf_client;
	
	guint timeout_handler;
	guint previous_day;

	GtkWidget *label;

	GtkWidget *settings_window;
	GtkWidget *calendar_window;

	gchar *searched_name;

	cairo_surface_t* background;
};

struct _NamedayDesktopAppletClass
{
	HDHomePluginItemClass parent_class;
};

GType nameday_desktop_applet_get_type(void);

G_END_DECLS

void
nameday_desktop_applet_show_notification (NamedayDesktopApplet *priv,
                                          const gchar *text);

gboolean
nameday_desktop_applet_on_timeout (gpointer data);

void
nameday_desktop_get_current_date (guint *year,
				  guint *month,
				  guint *day);

#endif
