#!/usr/bin/env python

# -*- coding: utf-8 -*-

# N900FTP 
# Author: Johannes Schwarz
# E-mail: n900ftp@dremadur.de

"""
Module implementing MainWindow.
"""

#TODO 
#uploading go --> not working with files -> fixed
#Umlaut directories cd in not working
#active mode on ftp_lib
import sys

from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtNetwork import *
from PyQt4.QtCore import Qt
from PyQt4 import QtCore, QtGui, QtNetwork

import ftplib
from ftplib import FTP

from collections import deque

import os
import os.path



from Ui_mainwindow import Ui_MainWindow
from openserver import OpenServer
from settings import SettingWindow
#from helper.ftpfilehelper import ftpFileHelper
from helper.xmlbookmark import XmlBookmark
from helper.sftphelper import SFTPHelper
from helper.ftphelper import FTPHelper



class mMainWindow(QMainWindow, Ui_MainWindow):
    """
    Class documentation goes here.
    """
  
    def __init__(self, parent = None):
		"""
		Constructor
		"""
		QMainWindow.__init__(self, parent)
		self.setupUi(self)
		
		#Add menu
		fremantle = self.menuBar().addMenu("Edit");
		openloc_act = fremantle.addAction("Open Location")
		QObject.connect(openloc_act, SIGNAL("triggered()"), self.openlocationWindow)
		switchlocdir_act = fremantle.addAction("Switch Locale Dir")
		QObject.connect(switchlocdir_act,  SIGNAL("triggered()"),  self.switchLocalDir)
		settingwindow_act = fremantle.addAction("Settings")
		QObject.connect(settingwindow_act,  SIGNAL("triggered()"),  self.settingWindow)

		self.m_lw_local.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
		self.connect(self.m_lw_local, QtCore.SIGNAL("customContextMenuRequested(const QPoint &)"), self.openLeftContextMenu)

		self.m_lw_remote.setContextMenuPolicy(QtCore.Qt.CustomContextMenu)
		self.connect(self.m_lw_remote, QtCore.SIGNAL("customContextMenuRequested(const QPoint &)"), self.openRightContextMenu)

		#Declare openLocation as StackedWindow
		self.openLocation=OpenServer(self)
		#Declare settingWindow as StackedWindow
		self.settingWindow = SettingWindow(self)
		self.localViewMode=0
		#1=passive / 0=active
		self.transferMode=1
		
		self.connectiontype ="FTP"

		try :
			self.setAttribute(Qt.WA_Maemo5StackedWindow, True)
			self.settingWindow.setAttribute(Qt.WA_Maemo5StackedWindow,  True)
			USE_MAEMO=True
		except :
			USE_MAEMO=False	
			
		self.isLocalDirectory = {}		
		self.isRemoteDirectory = {}
		
		self.remoteDirs = []
		self.remoteFiles =[]
		
		
		#self.localdir=QDir("/home/user/MyDocs")
		#self.localdir=QDir("c:")
		self.localdir=QDir().home()
		self.localPath=self.localdir.path()
		self.changeLocalDirectory(".")
		
		
		#store local Directory e.g. /home/MyDocs
		self.currentLocalPath=self.localdir.path()
		#store remote Directory-Path  e.g. /home/sld/lkj
		self.currentRemotePath = QString("/")
		
		#the last piece of currentLocalPath
		self.currentLocalDir = QString("")
		#the latsw piece of currentRemotePath
		self.currentRemoteDir = QString("")
		
		#store local directory when starting an action
		self.startLocalPath=self.localdir.path()
		#store remote dirctory when starting an action
		self.startRemotePath = QString("")
		
		#actionRemotePath
		self.actionRemotePath=QString("")
		
		#for recursive stuff
		#self.pendingDirectories = deque()
		self.pendingDirectories = QStringList()
		self.startingDownloadRemoteDirectory=""
		
		#self.ftpHelper = None
		
		self.server =""
		self.user =""
		self.pwd =""
		self.port =21
		
		self.xmlBookmark = XmlBookmark(self)
		self.readBookmarkList()

		

		#ProgressDialog
		self.progressDialog = QtGui.QProgressDialog(self)
		self.progressDialog.setMinimum(0)
		self.progressDialog.setMaximum(0)
		self.progressDialog.hide()
		self.progressDialog.setGeometry(30, 250, 740, 100)

 
		self.timer = QtCore.QBasicTimer()
		self.step = 0;
		
		self.ftp = None
	
    def ftpListRemote(self,  dirlist,  filelist):
		self.m_lw_remote.clear()
		self.isRemoteDirectory.clear()
		self.m_lw_remote.addItem("..")
		for d in dirlist:
			self.m_lw_remote.addItem(QListWidgetItem(QIcon("/opt/n900ftp/ressource/folder.xpm"), d, self.m_lw_remote))
			self.isRemoteDirectory[QString(d)]=True
		for f in filelist:
			self.m_lw_remote.addItem(f)
		self.endProgressDialog()
	
    def doChangeRemoteDir(self,  newDir):
		self.endProgressDialog()
		self.startProgressDialog("Changing Directories ...")		
		self.ftp.changeRemoteDir(newDir)
		
    def doChangeLocalDir(self,  newDir):
		self.endProgressDialog()
		self.changeLocalDirectory(newDir)	
	
    def connectionEstablished(self):
		self.m_label_remote.setText("Remote:")
		self.m_bu_disconnect.setEnabled(True)
		self.endProgressDialog()
		self.startProgressDialog("Changing Directories ...")			
		self.ftp.changeRemoteDir(".")
		
    def errorOccured(self,  message):
		self.endProgressDialog()		
		QMessageBox.information(self,  "FTP",  message)	

    def informMessage(self,  message):
        QMessageBox.information(self,  "FTP",  message)
	
    def timerStart(self):
        if self.timer.isActive():
            self.timer.stop()
            self.isConnected = False
        else:
            self.timer.start(500, self)
            self.isConnected = True
			
    def timerEvent(self, event):
		#if self.step >= 100:
		#	self.timer.stop()
		#	return
		self.step = self.step + 5
		self.progressDialog.setValue(self.step)
			
    def startProgressDialog(self,  message):
		self.step = 0
		self.progressDialog.setLabelText(message)
		self.progressDialog.show()
		self.timerStart()	
		
    def endProgressDialog(self):
		self.timer.stop()
		self.progressDialog.hide()
		
    def switchLocalDir(self):
		self.backupLocalDir = self.localdir
		newDir = ""
		if self.localdir.path().startsWith("/home"):
			newDir = "/media/mmc1"
		else :
			newDir = QDir().home().path()
		(newDirSel,  ok) = QInputDialog.getText(self,  "Please enter new dir!",  "New Directory:",  QLineEdit.Normal,  newDir)
		if ok:
			self.localdir=QDir(newDirSel)
			self.currentLocalPath = self.localdir.path()
		self.changeLocalDirectory(".")

	#Open the StackedWindow to enter Login information
    def openlocationWindow(self):	
		self.openLocation.show()
		
    def settingWindow(self):
		self.settingWindow.show()
		
    def openLeftContextMenu(self, point):
		entry = self.m_lw_local.currentItem()
		file = QString("")
		
		menu = QMenu(self)
		
		#Is it a directory
		delDirAction = None
		delFileAction = None
		transferFile = None
		
		if type(entry).__name__ != "NoneType":
			file = entry.text()
			if entry.text()=="..":
				file = QString("")
			#A file is clicked 
			else:
				#Are we connected?
				if self.m_label_remote.text() == "Remote:":
					transferFile = menu.addAction("Upload")
					menu.addSeparator()
				
				if self.isLocalDirectory.get(file):
					delDirAction = menu.addAction("Delete Directory")
				#so it must be a file
				else :
					delFileAction = menu.addAction("Delete File")
				renameAction = menu.addAction("Rename File ...")
				menu.addSeparator()
		
		newDirAction = menu.addAction("New Directory ...")
		
		action = menu.exec_(self.mapToGlobal(point))
		if action == transferFile:
			if self.isLocalDirectory.get(file ):
				self.startProgressDialog("Uploading files ...")
				self.ftp.putDirectory(file,  self.currentLocalPath)
					
			#Upload one single file
			else :
				self.startProgressDialog("Uploading file ...")
				self.ftp.putFile(self.currentLocalPath+os.sep+file,  file)
		
		elif action == delFileAction:
			print "Deleting file "+file
			ret = QMessageBox.question(self,  "FTP Delete", "Do you really want to delete the file?",  "",  "No")
			if ret == 0:
				file = QFile(self.currentLocalPath+os.sep+file)
				if file.remove():
					QMessageBox.information(self,  "FTP",  "File has been deleted successfully!")
				else:
					QMessageBox.information(self,  "FTP",  "File couldn't be deleted!")			
			self.changeLocalDirectory(".")		
					
		elif action == delDirAction:
			ret = QMessageBox.question(self,  "FTP Delete", "Do you really want to delete the directory and all subcontent?",  "",  "No")
			if ret == 0:			
				ga = os.popen("rm -rf "+str(self.currentLocalPath+os.sep+file)).read()
				ga = ga.strip()#[11:]		
				print "Delete dir command="+ga.strip()
				self.changeLocalDirectory(".")

		elif action == newDirAction:
			(newDir,  ok) = QInputDialog.getText(self,  "Please enter new Directory!",  "New Directory:",  QLineEdit.Normal)
			if ok:
				curDir = QDir(self.currentLocalPath) 
				if (curDir.mkdir(newDir)):
					QMessageBox.information(self,  "FTP",  "New directory created!")			
				else :	
					QMessageBox.information(self,  "FTP",  "New directory couldn't be created!")	
			self.changeLocalDirectory(".")		
					
    def openRightContextMenu(self, point):
		if self.m_label_remote.text()=="Bookmarks:":
			return
		entry = self.m_lw_remote.currentItem()
		file = QString("")
		
		menu = QMenu(self)
		
		#Is it a directory
		delDirAction = None
		delFileAction = None
		renameAction = None
		transferFile = None
		
		if type(entry).__name__ != "NoneType":
			file = entry.text()
			if entry.text()=="..":
				file = QString("")
			#A file is clicked 
			else:
				transferFile = menu.addAction("Download")
				menu.addSeparator()
				if self.isRemoteDirectory.get(file):
					delDirAction = menu.addAction("Delete Directory")
				#so it must be a file
				else :
 					delFileAction = menu.addAction("Delete File")
				renameAction = menu.addAction("Rename File ...")
				menu.addSeparator()
		newDirAction = menu.addAction("New Directory ...")
		
		action = menu.exec_(self.mapToGlobal(point))
		if action == transferFile:
			if self.isRemoteDirectory.get(file ):
				self.startProgressDialog("Downloading Files ...")
				self.ftp.getDirectory(file,  self.currentLocalPath)

			#Download one single file
			else :
				self.startProgressDialog("Downloading file ...")
				self.ftp.getFile(file,  self.currentLocalPath+os.sep+file)
	
		elif action == delFileAction:
			print "Deleting file "+file
			ret = QMessageBox.question(self,  "FTP Delete", "Do you really want to delete the file?",  "",  "No")
			if ret == 0:
				self.startProgressDialog("Deleting File ...")
				self.ftp.rmFile(file)
		elif action == delDirAction:
			ret = QMessageBox.question(self,  "FTP Delete", "Do you really want to delete the directory and all subcontent?",  "",  "No")
			if ret == 0:
				self.startProgressDialog("Delete Directory ...")
				self.ftp.rmDir(file)
		elif action == renameAction:
			(newName,  ok) = QInputDialog.getText(self,  "Please enter new name!",  "New Filename:",  QLineEdit.Normal)
			if ok:
				self.startProgressDialog("Renaming ...")
				self.ftp.rename(file, newName)
		elif action == newDirAction:
			(newDir,  ok) = QInputDialog.getText(self,  "Please enter new Directory!",  "New Directory:",  QLineEdit.Normal)
			if ok:
				self.startProgressDialog("Creating New Directory ...")
				self.ftp.mkDir(newDir)
			
	#Connect to Host with the login information
    def connectToServer(self, serverc,  userc,  pwdc,  portc=21,  connectionc="FTP"):
		self.server = serverc
		self.user = userc
		self.pwd = pwdc
		self.port= portc
		self.connectiontype = connectionc
		
		self.startProgressDialog("Connecting to the server!")
		
		#SFTP
		if connectionc!="FTP":

			self.ftp = SFTPHelper(self)
			
			(portInt,  ok)=self.port.toInt()
			if not ok:
				portInt = 22

			self.ftp.connectFTP(self.server,  portInt,  self.user,  self.pwd,  '')

		#FTP
		else:	
			self.ftp = FTPHelper(self)
			
			(portInt,  ok)=self.port.toInt()
			if not ok:
				portInt = 21
				
			self.ftp.connectFTP(self.server,  portInt,  self.user,  self.pwd,  self.transferMode)
			
		self.connect(self.ftp, SIGNAL("listDir(PyQt_PyObject, PyQt_PyObject)"), self.ftpListRemote)
		self.connect(self.ftp, SIGNAL("errorOccured(QString)"),  self.errorOccured)
		self.connect(self.ftp, SIGNAL("informMessage(QString)"),  self.informMessage)
		self.connect(self.ftp, SIGNAL("connected"),  self.connectionEstablished)
		self.connect(self.ftp, SIGNAL("changeDirRemote(QString)"),  self.doChangeRemoteDir)
		self.connect(self.ftp, SIGNAL("changeDirLocal(QString)"),  self.doChangeLocalDir)		
		
		return
   
    @pyqtSignature("QModelIndex")
    def on_m_lw_local_doubleClicked(self, index):
		self.changeLocalDirectory(self.m_lw_local.currentItem().text())
		
    @pyqtSignature("QModelIndex")
    def on_m_lw_remote_doubleClicked(self, index):
		if self.m_label_remote.text() == "Bookmarks:":
			servername = self.m_lw_remote.currentItem().text()
			if not self.xmlBookmark.initialize():
				QMessageBox.inform(self.parentWindow,  "FTP", "Bookmarklist can not be loaded!")
			server = self.xmlBookmark.getServer(servername)
			self.connectToServer(server.server,  server.login,  server.password,  server.port, server.connection)
		else:
			self.changeRemoteDirectory(self.m_lw_remote.currentItem().text())		
		
    def changeLocalDirectory(self,  newDir):
		#clear locallist first
		self.m_lw_local.clear()
		self.isLocalDirectory.clear()		
		#print "Before changing localeDir :"+self.currentLocalPath
		self.localdir.cd(newDir)
		#print "After changing localeDir :"+self.currentLocalPath
		
		self.currentLocalDir=newDir
		if  newDir!=".":
			self.currentLocalPath = self.localdir.path()
		
		#self.currentRemotePath = self.localdir.path()
		#add directories to the listwidget first together with an icon
		filelist = None
		if self.localViewMode==1:
			filelist = self.localdir.entryList(QDir.AllDirs|QDir.Hidden)
		else:
			filelist = self.localdir.entryList(QDir.AllDirs)
			
		for i in filelist:
			if i == "..":
				self.m_lw_local.addItem(i)
			elif i != ".":
				self.m_lw_local.addItem(QListWidgetItem(QIcon("/opt/n900ftp/ressource/folder.xpm"), i, self.m_lw_local))
				self.isLocalDirectory[i]=1

		#now the normal files are added
		if self.localViewMode==1:
			filelist = self.localdir.entryList(QDir.Files|QDir.Hidden)
		else:
			filelist = self.localdir.entryList(QDir.Files)	
			
		for i in filelist:
			self.m_lw_local.addItem(i)		
    
    def changeRemoteDirectory(self,  newDir):
			self.startProgressDialog("Changing Directory")
			self.ftp.changeRemoteDir(newDir)
			
    @pyqtSignature("")
    def on_m_bu_disconnect_clicked(self):
        self.ftp.disconnect()

        self.m_lw_remote.clear()
        self.currentRemoteDir = QString("")
        self.currentRemotePath = QString("")
        self.m_bu_disconnect.setEnabled(False)
        self.readBookmarkList()
		
    def readBookmarkList(self):
		self.m_label_remote.setText("Bookmarks:")
		self.m_lw_remote.clear()
		self.m_lw_remote.setEnabled(True)

		if not self.xmlBookmark.initialize():
			QMessageBox.inform(self.parentWindow,  "FTP", "Bookmarklist can not be loaded")
		self.serverList = self.xmlBookmark.getServerList()
		for i in self.serverList:
			self.m_lw_remote.addItem(i.name)					


