# -*- coding: utf-8 -*-

# N900FTP
# Author: Johannes Schwarz
# E-mail: n900ftp@dremadur.de


from PyQt4.QtGui import *
from PyQt4.QtCore import *
from PyQt4.QtNetwork import *
from PyQt4.QtCore import Qt
from PyQt4 import QtCore, QtGui, QtNetwork	

import paramiko
import stat

from os import path
import os
import glob


class SFTPHelper(QThread):
	def __init__(self, parent=None):
		#QObject.__init__(self, parent)
		QThread.__init__(self, parent)
		
		# 1 = ChangeRemoteDir and ListDir
		# 2 = conncetTo Server
		# 3 = Get File
		# 4 = Put File
		#5 = Get Directory Recursive
		self.action = 0
		
		self.fileToGet = ""
		self.fileToGetLocal = ""
		
		self.fileToPut=""
		self.fileToPutRemote=""
		
		self.actionDownloadStartRemotePath = ""
		self.actionDownloadStartLocalPath = ""
		
		self.actionUploadStartRemotePath = ""
		self.actionUploadStartLocalPath	= ""	
		
		self.changeToDir =""
		self.currentRemoteDir = QString("")
		self.currentRemotePath=QString("/")
		

		self.pwidget = parent
		self.server = str("")
		self.login = str("")
		self.pwd = str("")
		self.port = 22

		self.ssh = paramiko.SSHClient()
		self.ssh.set_missing_host_key_policy(paramiko.AutoAddPolicy())
			
		
	def connectFTP(self,  server,  port,  login,  pwd,  transferMode=""):
		self.server=str(server)
		self.port=port
		self.login=str(login)
		self.pwd=str(pwd)
		self.action = 2
		self.start()
		
	def disconnect(self):
		try:
			self.ftp.close()
		except:
			self.emit(SIGNAL("errorOccured(QString)"),  "Error while disconnecting!")	
			return	
		self.action = 0
		self.changeToDir=""
		
	def changeRemoteDir(self,  newDir):
		self.action = 1
		self.changeToDir = newDir
		self.start()
		
	def mkDir(self,  newDir):
		try:
			self.ftp.mkdir(str(newDir))
		except:
			self.emit(SIGNAL("errorOccured(QString)"),  "Directory couldn't be created!")	
			return			
		self.emit(SIGNAL("informMessage(QString)"),  QString("New Dir successfully created!"))
		self.emit(SIGNAL("changeDirRemote(QString)"),  QString("."))
		
	def rmDir(self, dirToRemove):
		try:
			self.ftp.rmdir(str(dirToRemove))
		except:
			self.emit(SIGNAL("errorOccured(QString)"),  "Directory not empty!")	
			return			
		self.emit(SIGNAL("informMessage(QString)"),  QString("Dir successfully deleted!"))		
		self.emit(SIGNAL("changeDirRemote(QString)"),  QString("."))
		
	def rmFile(self, fileToRemove):
		try:
			self.ftp.remove(str(fileToRemove))
		except:
			self.emit(SIGNAL("errorOccured(QString)"),  "File couldn't be deleted!")	
			return		
		self.emit(SIGNAL("informMessage(QString)"),  QString("File successfully deleted!"))		
		self.emit(SIGNAL("changeDirRemote(QString)"),  QString("."))		
		
	def rename(self, old,  new):
		try:
			self.ftp.rename(str(old),  str(new))
		except:
			self.emit(SIGNAL("errorOccured(QString)"),  "File couldn't be renamed!")	
			return			
		self.emit(SIGNAL("informMessage(QString)"),  QString("Name successfully changed!"))		
		self.emit(SIGNAL("changeDirRemote(QString)"),  QString("."))			
		
	def getFile(self,  remoteFile,  localFile):
		self.action=3
		self.fileToGet=remoteFile
		self.fileToGetLocal=localFile
		self.start()
		
	def getDirectory(self,  remoteDir,  localPath):
		self.action = 5
		self.actionDownloadStartRemotePath = self.currentRemotePath
		self.actionDownloadStartLocalPath = localPath
		print "Downloading dir "+remoteDir+" to local dir "+localPath
		self.fileToGet = remoteDir
		self.start()
		
	def putDirectory(self,  localDir,  localPath):
		self.action = 6
		self.actionUploadStartRemotePath = self.currentRemotePath
		self.actionUploadStartLocalPath = localPath
		self.fileToPut= localDir
		#print "Downloading dir "+remoteDir+" to local dir "+localPath
		self.start()		
		
	def putFile(self,  localFile,  remoteFile):
		self.action = 4
		self.fileToPut = localFile
		self.fileToPutRemote=remoteFile
		self.start()
		
		
	def run(self):
		if self.action == 1:

			#When parent Directory is selected, then cut away the last piece of self.currentRemotePath after the last /
			#/home/www/hello  --> .. --> /home/www/
			if self.changeToDir == "..":
				lastslash = self.currentRemotePath.lastIndexOf("/")
				#print "Before:"+self.currentRemotePath
				self.currentRemotePath = self.currentRemotePath.mid(0, lastslash) 
				#print "After:"+self.currentRemotePath
			elif self.changeToDir != "." :
				if self.currentRemotePath=="/" or self.currentRemotePath.endsWith("/"):
					self.currentRemotePath+=QString(self.changeToDir)
				else :
					self.currentRemotePath += QString("/"+self.changeToDir)
			#print "Change Remote path to"+self.currentRemotePath		
            
			self.currentRemoteDir = self.changeToDir			
			
			
			self.ftp.chdir(str(self.currentRemoteDir))
			remoteFiles = self.ftp.listdir()
			dirs = [] 
			files = [] 
			for fileEntry in remoteFiles:
				if stat.S_ISDIR(self.ftp.stat(fileEntry).st_mode):
					dirs.append(fileEntry)
				else:
					files.append(fileEntry)
			dirs.sort()
			files.sort()
			self.emit(SIGNAL("listDir(PyQt_PyObject, PyQt_PyObject)"), dirs,  files)
			
			print "Remote-Dir :"+self.currentRemoteDir
			print "Remote-Path :"+self.currentRemotePath
			
		#Connecting
		elif self.action == 2:
			try:
				self.ssh.connect(self.server,  self.port,  self.login, self.pwd)
				self

				self.ftp = self.ssh.open_sftp()

				self.emit(SIGNAL("connected"))
			except paramiko.BadHostKeyException: 
				self.emit(SIGNAL("errorOccured(QString)"),  "Host Key could not be verified!")
			except paramiko.AuthenticationException:
				self.emit(SIGNAL("errorOccured(QString)"),  "Authentication failed!")				
			except paramiko.SSHException:
				self.emit(SIGNAL("errorOccured(QString)"),  "Connection Error!")				
		
		#Download File
		elif self.action == 3:
			print "Downloading File: "+self.fileToGet+ " to "+ self.fileToGetLocal 
			self.ftp.get(str(self.fileToGet),  str(self.fileToGetLocal))
			self.emit(SIGNAL("informMessage(QString)"),  QString("Finished File download!"))
			self.emit(SIGNAL("changeDirLocal(QString)"),  QString("."))	
		
		#Upload File
		elif self.action == 4:
			print "Uploading File: "+self.fileToPut+ " to "+ self.fileToPutRemote 
			self.ftp.put(str(self.fileToPut),  str(self.fileToPutRemote))
			self.emit(SIGNAL("informMessage(QString)"),  QString("Finished File upload!"))
			self.emit(SIGNAL("changeDirRemote(QString)"),  QString("."))

		#Download All recursiv
		elif self.action == 5:
			self.downloadDirectory(self.actionDownloadStartLocalPath, "",  self.fileToGet)
			self.ftp.chdir(str(self.actionDownloadStartRemotePath))	
			self.currentRemotePath = self.actionDownloadStartRemotePath
			self.emit(SIGNAL("changeDirLocal(QString)"),  QString("."))
			self.emit(SIGNAL("informMessage(QString)"),  QString("All files have been downloaded!"))				
		
		#Upload All recursiv
		elif self.action == 6:
			print "Create Remote Dir ="+self.fileToPut
			self.ftp.mkdir(str(self.fileToPut))
			self.ftp.chdir(str(self.fileToPut))

			self.uploadDirectory(self.currentRemotePath, QDir(self.actionUploadStartLocalPath+os.sep+self.fileToPut))
			
			self.ftp.chdir(str(self.actionUploadStartRemotePath))	
			self.currentRemotePath = self.actionUploadStartRemotePath		
			self.emit(SIGNAL("changeDirRemote(QString)"),  QString("."))
			self.emit(SIGNAL("informMessage(QString)"),  QString("All files have been uploaded!"))			

			#print "Files from "+self.actionUploadStartLocalPath+os.sep+self.fileToPut
			#for file in glob.glob(str(self.actionUploadStartLocalPath+os.sep+self.fileToPut+"/*")):
			#	print file

		self.action = 0
		self.changeToDir =""
			
	def downloadDirectory(self,  baselocalPath,  relativeRemoteDir,  dir):	
		#print "Create new local dir ="+baselocalPath+os.sep+dir
		QDir(".").mkpath(baselocalPath+os.sep+dir)
		
		#print "CDing remotely to "+str(self.actionDownloadStartRemotePath+"/"+relativeRemoteDir+"/"+dir+"/")
		if relativeRemoteDir=="":
			self.ftp.chdir(str(self.actionDownloadStartRemotePath+"/"+dir+"/"))
		else:
			self.ftp.chdir(str(self.actionDownloadStartRemotePath+"/"+relativeRemoteDir+"/"+dir+"/"))
			
		remoteFiles = self.ftp.listdir()
		
		for fileEntry in remoteFiles:
			#print "Do I want to get start for file "+str(self.actionDownloadStartRemotePath+"/"+relativeRemoteDir+"/"+fileEntry)
			if stat.S_ISDIR(self.ftp.stat(str(self.actionDownloadStartRemotePath+"/"+relativeRemoteDir+"/"+dir+"/"+fileEntry)).st_mode):
				#print "Recursiv call with: "+str(baselocalPath+os.sep+dir)+ " and "+relativeRemoteDir+"/"+dir+" and "+fileEntry
				self.downloadDirectory(str(baselocalPath+os.sep+dir), relativeRemoteDir+"/"+dir,  fileEntry)
			else:
				#print "Download File from "+str(self.actionDownloadStartRemotePath+"/"+relativeRemoteDir+"/"+dir+"/"+fileEntry)+" to "+str(baselocalPath+os.sep+dir+os.sep+fileEntry)
				self.ftp.get(str(self.actionDownloadStartRemotePath+"/"+relativeRemoteDir+"/"+dir+"/"+fileEntry),  str(baselocalPath+os.sep+dir+os.sep+fileEntry))

			
	def uploadDirectory(self, baseremotePath,  dir):
		dir.setSorting(QDir.DirsFirst);
		dir.setFilter(QDir.Files | QDir.Dirs | QDir.NoSymLinks | QDir.NoDotAndDotDot)
		dirlist = dir.entryList(QDir.Dirs | QDir.NoSymLinks | QDir.NoDotAndDotDot)
		for i in dirlist:
			#print "New Directory ="+i
			if i !="." and i!="..":
				#print "CDing into new remote dir "+str(baseremotePath+"/"+dir.dirName()+"/")
				self.ftp.chdir(str(baseremotePath+"/"+dir.dirName()+"/"))
				try :
					self.ftp.mkdir(str(i))	
				except : 
					self.emit(SIGNAL("errorOccured(QString)"),  "Directory "+i+" cannot be created!\n Aborting!")	
					return
				nextDir = QDir(dir.absolutePath()+os.sep+i)
				self.uploadDirectory(baseremotePath+"/"+dir.dirName(),  nextDir)

		dir.setFilter(QDir.Files | QDir.Dirs | QDir.NoSymLinks | QDir.NoDotAndDotDot)
		filelist = dir.entryList(QDir.Files| QDir.NoSymLinks)
		for i in filelist:
			if i !="." and i!="..":
				#print "Uploading file "+str(dir.path()+os.sep+i) +" TO "+str(baseremotePath+"/"+i)
				self.ftp.put(str(dir.path()+os.sep+i), str(baseremotePath+"/"+dir.dirName()+"/"+i))	
				

