#!/usr/bin/env python
# -*- coding: utf-8 -*-

import platform
import sys
import os
import Utils
import UMD
import zlib
import md5
from PyQt4.QtCore import *
from PyQt4.QtGui import *
from PyQt4.QtMaemo5 import QMaemo5InformationBox
from datetime import datetime
from Controller import *
from UI import *
from Logger import *
#import dbus, gobject
#from dbus.mainloop.glib import DBusGMainLoop
#DBusGMainLoop(set_as_default=True)

class MainWindow(QMainWindow):
    def __init__(self, parent=None):
        super(MainWindow, self).__init__(parent)

        #load the settings
        self.config=self.load_config()
        self.orientation=self.config["orientation"]
        self.filepath=self.config["storagePath"]

        if self.orientation==1:
            self.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
        elif self.orientation==2:
            self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            self.connect(QApplication.desktop(), SIGNAL("resized(int)"),self.orientation_changed)
        
        #init the log window and the logger
        self.logWin=LogWindow(self)
        self.charm = FlickCharm()
        self.charm.activateOn(self.logWin.textEdit)
#        self.logger = logging.getLogger('NDR')
        self.logger=Logger(self.logWin)
        self.connect(self.logger, SIGNAL("log(QString)"),
                     self.logWin.write)

        self.logger.info("__init__")
        self.logger.debug("init controller, updateThread, searchThread")
        self.controller = Controller(self.logger)
        self.updateThread=UpdateThread(self.logger,self)
        self.searchThread=SearchThread(self.logger,self)

        self.logger.debug("read websites data from db")
        self.websites=self.controller.get_all_websites()
        self.websitesDict={}
        for website in self.websites:
            self.websitesDict[website["id"]]=website
            
        #init all forms
        self.logger.debug("init all windows")
        self.create_books_window()
        self.create_chapters_window()
        self.create_content_window()
        self.chaptersManaWin=None
        self.configForm=None
        self.newBookForm=None
        self.aboutForm=None
        self.delBookForm=None
        self.searchConfigForm=None
        self.searchResultsForm=None

        #init the signals and slots
        self.logger.debug("init signals and slots")
        self.connect(self.booksListView,
                     SIGNAL("clicked(const QModelIndex&)"),
                     self.show_chapters_window)
        self.connect(self.chaptersWin.chaptersListView,
                     SIGNAL("clicked(const QModelIndex&)"),
                     self.show_content_window)
        self.connect(self.updateThread, SIGNAL("finished(bool,int,int,int)"),
                     self.update_finished)
        self.connect(self.updateThread, SIGNAL("end_download_one_chapter(int,int)"),
                     self.refresh_after_download_a_chapter)
        self.connect(self.searchThread, SIGNAL("finished(bool,int,int)"),
                     self.search_finished)
        self.connect(self.searchThread, SIGNAL("show_progress(int)"),
                     self.show_search_progress)

        #define shortcut keys
        self.logger.debug("init shortcut keys")
#        QShortcut(QKeySequence(Qt.Key_Up), self.contentWin, self.zoom_in)
#        QShortcut(QKeySequence(Qt.Key_Down), self.contentWin, self.zoom_out)
#        QShortcut(QKeySequence(Qt.Key_Left), self.contentWin, self.go_previous_chapter)
#        QShortcut(QKeySequence(Qt.Key_Right), self.contentWin, self.go_next_chapter)
        #WSAD for scrachbox testing
        QShortcut(QKeySequence(Qt.Key_W), self.contentWin, self.zoom_in)
        QShortcut(QKeySequence(Qt.Key_S), self.contentWin, self.zoom_out)
        QShortcut(QKeySequence(Qt.Key_A), self.contentWin, self.go_previous_chapter)
        QShortcut(QKeySequence(Qt.Key_D), self.contentWin, self.go_next_chapter)

        #keep references for currentBook, currentChapter
        self.logger.debug("init all virians")
        self.currentBook=None
        self.currentChapter=None
        self.searchResults=[]

        #show the books window at first
        self.show_books_window()

        #scroll to last viewed book
        if self.config["lastViewedBookId"]!=-1:
            self.scroll_to(self.config["lastViewedBookId"])
        self.scheduledUpdateInterval=-1
        self.timerId=0
        #setup scheduled update timer
        if self.config["scheduledUpdate"]:
            self.scheduledUpdateInterval=self.config["scheduledUpdateTime"]
            self.logger.info("start scheduled update timer, time interval:"+str(self.scheduledUpdateInterval))
            self.timerId=self.startTimer(self.scheduledUpdateInterval*60000)
            if self.timerId==0:
                self.logger.error("start scheduled update timer failed!")
                self.show_notice(unicode("自动更新定时器启动失败"),QMaemo5InformationBox.NoTimeout)
        #update when start
        if self.config["autoUpdateWhenStart"]:
            self.logger.info("update all books when startup")
            self.update_all_books()


#functions for creating all windows

    def create_books_window(self):
        self.booksListView=QListView()
        self.booksListView.setSelectionMode(QAbstractItemView.SingleSelection)
        self.booksListView.setVerticalScrollMode(QAbstractItemView.ScrollPerItem)
        self.booksListView.setViewMode(QListView.ListMode)
        self.booksListView.setMovement(QListView.Static)
        self.booksListView.setItemDelegate(HtmlCellDelegate(self.orientation))
        self.booksListView.setResizeMode(QListView.Adjust)
        self.setCentralWidget(self.booksListView)
        self.setAttribute(Qt.WA_Maemo5StackedWindow)
        bookNewAction = self.create_action(unicode("新建"), self.show_new_book_form)
        bookImportAction= self.create_action(unicode("导入"), self.show_book_import_form)
        self.bookUpdateAllAction = self.create_action(unicode("更新所有"), self.update_all_books)
        self.bookStopUpdateAction = self.create_action(unicode("停止更新"), self.stop_update)
        self.bookStopUpdateAction.setEnabled(0)
        appConfigAction = self.create_action(unicode("配置"), self.show_config_form)
        logAction = self.create_action(unicode("显示日志"), self.show_log_window)
        aboutAction=self.create_action(unicode("关于"), self.show_about_form)
        self.booksMenuBar=QMenuBar()
        self.add_actions(self.booksMenuBar, (bookNewAction,bookImportAction,
                         self.bookUpdateAllAction,self.bookStopUpdateAction,appConfigAction,
                         logAction,aboutAction))
        self.setMenuBar(self.booksMenuBar)


    def create_chapters_window(self):
        self.chaptersWin=ChaptersWindow(self,self.orientation)
        self.bookUpdateAction = self.create_action(unicode("更新"), self.update_a_book)
        chapterGoToNewAction = self.create_action(unicode("转至未读"), self.go_to_new_chapter )
        self.chapterManageAction = self.create_action(unicode("章节管理"), self.show_chapters_mana_window )
        chapterAllReadAction = self.create_action(unicode("全部标记为已读"), self.mark_all_chapters_readed )
        self.chaptersMenuBar=QMenuBar()
        self.add_actions(self.chaptersMenuBar, (self.bookUpdateAction,self.bookStopUpdateAction,
            chapterGoToNewAction,self.chapterManageAction,chapterAllReadAction))
        self.chaptersWin.setMenuBar(self.chaptersMenuBar)

    def create_content_window(self):
        self.contentWin=ContentWindow(self.chaptersWin,self.orientation)
        self.chapterDownloadAction = self.create_action(unicode("下载"), self.download_a_chapter )
#        contentReloadAction = self.create_action(unicode("刷新"), self.show_content_window )
        self.contentLoadRemoteAction = self.create_action(unicode("载入原始网页"), self.load_remote_content )
        nightModeAction=self.create_action(unicode("夜间模式"), self.switch_night_mode,None,None,None,True )
        self.contentMenuBar=QMenuBar()
        self.add_actions(self.contentMenuBar, (self.chapterDownloadAction,
            self.contentLoadRemoteAction,nightModeAction))
        self.contentWin.setMenuBar(self.contentMenuBar)
        self.nightMode=False
        self.charm.activateOn(self.contentWin.chapterContentView)
#        self.contentWin.chapterContentView.grabGesture(Qt.SwipeGesture)

    
#functions for showing books window
    def show_books_window(self):
        self.setWindowTitle("N3DR")
        #reload all books from db
        self.load_books()
        self.show()
        
    def load_books(self):
        books=self.controller.get_all_books()
        self.booksModel=BooksModel(books)
        self.booksListView.setModel(self.booksModel)

    def scroll_to(self,bookId):
        cindex=None
        if bookId>=0:
            for row in range(self.booksModel.rowCount()):
                cindex=self.booksModel.index(row,0)
                c=self.booksModel.data(cindex, Qt.EditRole)
                if c["id"]==bookId:
                    break
        if not cindex==None:
            self.booksListView.scrollTo(cindex)


#functions for showing chapters window
    def show_chapters_window(self,index):
        #reload all chapters for the currentBook from db and reset view to chaptersTable
        self.currentBook=self.booksModel.data(index,Qt.EditRole)
        if self.currentBook["websiteId"]==Utils.UMD_WEBSITE_ID:
            self.bookUpdateAction.setVisible(0)
            self.chapterManageAction.setVisible(0)
        else:
            self.bookUpdateAction.setVisible(1)
            self.chapterManageAction.setVisible(1)

        bookId=self.currentBook["id"]
        self.currentChapters = self.controller.get_chapters_for_a_book(bookId)
        self.chaptersWin.load_chapters(self.currentChapters)
        self.chaptersWin.setWindowTitle(unicode(self.currentBook["name"]))
        #scroll the list to the last viewed chapter.
        cid=self.currentBook["lastViewedChapterId"]
        self.chaptersWin.scroll_to(cid)
        self.chaptersWin.show()

    def mark_all_chapters_readed(self):
#        bookId=self.currentBook["id"]
        chapters = self.currentChapters
        for chapter in chapters:
            chapter["readed"]=1
        self.controller.update_chapters(chapters)
        self.currentBook["unreadChapterNum"]=0
        self.controller.save_a_book(self.currentBook)
        self.chaptersWin.load_chapters(chapters)

    def go_to_new_chapter(self):
        self.chaptersWin.scroll_to_new()

#functions for showing content window
    def show_content_window(self,index):
        #show the content of currentChapter
        self.currentChapter=self.chaptersWin.chaptersModel.data(index,Qt.EditRole)
        if self.currentBook["websiteId"]==Utils.UMD_WEBSITE_ID:
            self.chapterDownloadAction.setEnabled(0)
            self.contentLoadRemoteAction.setEnabled(0)
        else:
            self.chapterDownloadAction.setEnabled(1)
            self.contentLoadRemoteAction.setEnabled(1)
        self.contentWin.setWindowTitle(unicode(self.currentChapter["title"]+"-"+str(index.row()+1)
                +"/"+str(self.chaptersWin.chaptersModel.rowCount())))
        self.load_chapter_content(self.currentChapter)
        self.contentWin.show()

    def load_chapter_content(self,chapter):
        #setup the window title
#        index=self.chaptersWin.current_index()
#        self.contentWin.setWindowTitle(unicode(chapter["title"]+"-"+str(index.row()+1)
#                +"/"+str(self.chaptersWin.chaptersModel.rowCount())))
#        if chapter["downloaded"] ==1:
#            filename = chapter["filename"]
#            filename=self.filepath+filename
#            if os.access(filename, os.W_OK) == 0:
#                filename = Utils.INSTALL_PATH+Utils.NO_CONTENT_FILE_NAME
#            #update the unread status.
#            if chapter["readed"]==0:
#                chapter["readed"]=1
#                self.currentBook["unreadChapterNum"]-=1
#                self.controller.update_chapters([chapter])
#                self.controller.save_a_book(self.currentBook)
#        else:
#            filename = Utils.INSTALL_PATH+Utils.NO_CONTENT_FILE_NAME
#        self.contentWin.load_content(filename)
#        self.currentBook["lastViewedChapterId"]=chapter["id"]
#        self.controller.save_a_book(self.currentBook)

        baseUrl=QUrl()
        
        if self.currentBook["websiteId"]==Utils.UMD_WEBSITE_ID:
            contentHtml=Utils.CONTENT_HTML
            umdcontent= chapter["filename"]
            if umdcontent==None or umdcontent=="":
                self.load_umd_chapter_content()
                umdcontent= chapter["filename"]
            titlePlaceHolder = Utils.TITLE_PLACE_HOLDER
            contentPlaceHolder = Utils.CONTENT_PLACE_HOLDER
            contentHtml=contentHtml.replace(titlePlaceHolder, self.currentChapter["title"])
            contentHtml=contentHtml.replace(contentPlaceHolder, umdcontent)
#            print contentHtml
            if chapter["readed"]==0:
                chapter["readed"]=1
                self.currentBook["unreadChapterNum"]-=1
                chapter["filename"]=""
                self.controller.update_chapters([chapter])
                chapter["filename"]=umdcontent
                self.controller.save_a_book(self.currentBook)
            
        else:
        
            if chapter["downloaded"] ==1:
                filename = chapter["filename"]
                filename=self.filepath+filename
                if os.access(filename, os.W_OK) == 0:
                    contentHtml=unicode(Utils.NO_CONTENT_HTML)
                else:
                    baseUrl=QUrl.fromLocalFile(self.filepath+str(self.currentBook["id"])+"/")
                    contentHtml=Utils.CONTENT_HTML
                    try:
                        fsock = open(filename)
                        chapterContentHtml = fsock.read()
                        fsock.close()
                        if chapterContentHtml.startswith("<HTML>"):
    #                            for downward compability
                            contentHtml=chapterContentHtml.decode("gbk")
                        else:
                            titlePlaceHolder = Utils.TITLE_PLACE_HOLDER
                            contentPlaceHolder = Utils.CONTENT_PLACE_HOLDER
                            contentHtml = string.replace(contentHtml, titlePlaceHolder, self.currentChapter["title"])
                            contentHtml = string.replace(contentHtml, contentPlaceHolder, chapterContentHtml.decode("gbk"))
    #                            contentHtml=contentHtml.decode("gbk")
                    except:
                        self.logger.error(sys.exc_info()[0])
                        contentHtml=unicode(Utils.NO_CONTENT_HTML)
                #update the unread status
                if chapter["readed"]==0:
                    chapter["readed"]=1
                    self.currentBook["unreadChapterNum"]-=1
                    self.controller.update_chapters([chapter])
                    self.controller.save_a_book(self.currentBook)
            else:
    #                filename = "no_content.html"
                contentHtml=unicode(Utils.NO_CONTENT_HTML)
    #            self.chapterContentView.update_content(filename)
    #            print contentHtml
        self.contentWin.load_content_html(contentHtml,baseUrl)
        self.currentBook["lastViewedChapterId"]=chapter["id"]
        self.controller.save_a_book(self.currentBook)

    def load_umd_chapter_content(self):
#        print "load_umd_chapter_content"
        chapters = self.currentChapters
        book=self.currentBook
        file=book["url"]
        zipedSegStartString=book["lastModified"][0:-1]
        zipedSegLenString=book["eTag"][0:-1]
        zipedSegStart=zipedSegStartString.split(",")
        zipedSegLen=zipedSegLenString.split(",")
#        print zipedSegStart
#        print zipedSegLen
        fa=open(file,"rb")
        extlist=[]
        for i in xrange(len(zipedSegStart)):
            start=int(zipedSegStart[i])
            leng=int(zipedSegLen[i])
            fa.seek(start)
            ziped=fa.read(leng)
            extlist.append(zlib.decompress(ziped))
        totalcontent=''.join(extlist)
        for i in xrange(len(chapters)):
            chapter=chapters[i]
            stt=int(chapter["url"])
            if i<len(chapters)-1:
                ed=int(chapters[i+1]["url"])
            else:
                ed=len(totalcontent)
#            print stt,ed
            chaptersContent=totalcontent[stt:ed].decode('utf-16-le')
            chapter["filename"]=chaptersContent.replace(u"\u2029","<br>")
#            print chapter["sequence"]
#            print chapter["title"]
#            print chapter["url"]
#            print chaptersContent
        

    def load_remote_content(self):
        url = self.currentChapter["url"]
        self.contentWin.load_content(url)

    def switch_night_mode(self):
        if self.nightMode:
            self.nightMode=False
            self.contentWin.switch_to_day_mode()
        else:
            self.nightMode=True
            self.contentWin.switch_to_night_mode()
        self.load_chapter_content(self.currentChapter)

    def zoom_in(self):
        self.contentWin.zoom_in()

    def zoom_out(self):
        self.contentWin.zoom_out()

    def go_previous_chapter(self):
        index=self.chaptersWin.current_index()
        if index.row()>0:
            newIndex=self.chaptersWin.chaptersModel.index(index.row()-1,0)
            self.chaptersWin.set_current_index(newIndex)
            self.show_content_window(newIndex)

    def go_next_chapter(self):
        index=self.chaptersWin.current_index()
        if index.row()+1<self.chaptersWin.chaptersModel.rowCount():
            newIndex=self.chaptersWin.chaptersModel.index(index.row()+1,0)
            self.chaptersWin.set_current_index(newIndex)
            self.show_content_window(newIndex)


#functions for chapters management
    def show_chapters_mana_window(self):
        #reload all chapters for the currentBook from db and reset view to chaptersTable
#        self.currentBook=self.booksModel.data(index,Qt.EditRole)
#        bookId=self.currentBook["id"]
#        chapters = self.controller.get_chapters_for_a_book(bookId)
        chapters=self.currentChapters
        self.chaptersManaWin=ChaptersManaWindow(self.chaptersWin,chapters,self.orientation)
#        self.chaptersWin.load_chapters(chapters)
        self.chaptersManaWin.setWindowTitle(unicode(self.currentBook["name"]+":章节管理"))
        #scroll the list to the last viewed chapter.
#        cid=self.currentBook["lastViewedChapterId"]
#        self.chaptersWin.scroll_to(cid)
        self.connect(self.chaptersManaWin.confirmButton,
                     SIGNAL("clicked()"),
                     self.chapters_mana_confirm)
        self.connect(self.chaptersManaWin.cancelButton,
                     SIGNAL("clicked()"),
                     self.chapters_mana_cancel)
        self.chaptersManaWin.show()

    def chapters_mana_confirm(self):
        chapters=self.chaptersManaWin.output_chapters()
        self.controller.update_chapters(chapters)
        chapters = self.controller.get_chapters_for_a_book(self.currentBook["id"])
        self.currentChapters=chapters
        unreadNum=0
        downloadedNum=0
        for chapter in chapters:
            if chapter["readed"]==0:
                unreadNum+=1
            if chapter["downloaded"]==1:
                downloadedNum+=1
        self.currentBook["unreadChapterNum"]=unreadNum
        self.currentBook["downloadedChapterNum"]=downloadedNum
        self.currentBook["chapterNum"]=len(chapters)
        self.controller.save_a_book(self.currentBook)
        self.chaptersWin.load_chapters(chapters)
        self.chaptersManaWin.reset()
    
    def chapters_mana_cancel(self):
#        bookId=self.currentBook["id"]
#        chapters = self.controller.get_chapters_for_a_book(bookId)
        chapters=self.currentChapters
        self.chaptersManaWin.reset(chapters)

#functions for add, edit, delete a book
    def show_new_book_form(self,book=None):
        self.newBookForm= NewBookForm(self.websites,book,self,self.orientation)
        if book is None:
            self.newBookForm.setWindowTitle(unicode("新建"))
            self.newBookForm.update_new_book(Utils.build_a_default_book())
        else:
            self.newBookForm.setWindowTitle(unicode("编辑"))
        self.connect(self.newBookForm.confirmButton, SIGNAL("clicked()"), self.new_book_confirm)
        self.connect(self.newBookForm.searchButton, SIGNAL("clicked()"), self.search_book)
        self.connect(self.newBookForm.searchConfigButton, SIGNAL("clicked()"), self.show_search_config_form)
        self.connect(self.newBookForm.cancelButton, SIGNAL("clicked()"), self.newBookForm.hide)
        self.newBookForm.show()

    def show_book_import_form(self):
        path = QFileDialog.getOpenFileName(self,
                    unicode("请选择文件"),"/home/user/MyDocs","UMD Files (*.umd *.UMD)")
        if path:
#            print path
            uf=UMD.UMDFile()
            fa=open(path,"rb")
            try:
                uf.read(fa)
            except:
                fa.close()
                self.show_notice("导入失败，该文件不是一个有效的UMD文件")
                return
            if uf.type!='1':
                self.show_notice("导入失败，仅支持文本UMD文件")
                return
            else:
                book=uf.book
                chapters=uf.chapters
                book["url"]=str(path)
                chapterNum=len(chapters)
                book["chapterNum"]=chapterNum
                book["unreadChapterNum"]=chapterNum
                book["downloadedChapterNum"]=chapterNum
                book["sequence"]=Utils.generate_md5(path)
                book=self.controller.save_a_book(book)
                for chapter in chapters:
                    chapter["bookId"]=book["id"]
                chapters=self.controller.add_chapters(chapters)
                self.show_notice("导入<<"+book["name"]+">>成功")
                self.load_books()
                for row in range(self.booksModel.rowCount()):
                    bindex=self.booksModel.index(row,0)
                    b=self.booksModel.data(bindex, Qt.EditRole)
                    if b["id"]==book["id"]:
                        break
                self.booksListView.scrollTo(bindex)

    def edit_book(self,index):
        if self.updateThread.isRunning():
            self.show_notice(unicode("正在进行更新，请等待更新结束后继续"))
            return
        book=self.booksModel.data(index,Qt.EditRole)
        self.show_new_book_form(book)

    def delete_book(self,index):
        if self.updateThread.isRunning():
            self.show_notice(unicode("正在进行更新，请等待更新结束后继续"))
            return
        book=self.booksModel.data(index,Qt.EditRole)
        self.delBookForm=DeleteBookForm(book,self,self.orientation)
        self.connect(self.delBookForm.confirmButton, SIGNAL("clicked()"), self.delete_book_confirm)
        self.connect(self.delBookForm.cancelButton, SIGNAL("clicked()"), self.delBookForm.hide)
        self.delBookForm.show()

    def delete_book_confirm(self):
        book=self.delBookForm.book
        filepath=None
        if self.delBookForm.fileCB.checkState()>0:
            filepath=self.filepath
        self.controller.delete_a_book(book,filepath)
        self.logger.info("book deleted. id="+str(book["id"])+",name="+unicode(book["name"]))
        self.load_books()
        self.show_notice(unicode("<<"+book["name"]+">>已删除."), QMaemo5InformationBox.NoTimeout)
        self.currentBook=None

    def new_book_confirm(self):
        book=self.newBookForm.output_book(self.show_notice)
        if book is not None:
            book["websiteName"]=self.websitesDict[book["websiteId"]]["name"]
            book=self.controller.save_a_book(book,self.filepath)
            self.load_books()
            self.logger.info("book saved. id="+str(book["id"])+", name="+unicode(book["name"]))
            self.newBookForm.hide()
            for row in range(self.booksModel.rowCount()):
                bindex=self.booksModel.index(row,0)
                b=self.booksModel.data(bindex, Qt.EditRole)
                if b["id"]==book["id"]:
                    break
            self.booksListView.scrollTo(bindex)
            self.show_notice(unicode("<<"+book["name"]+">>已保存."), QMaemo5InformationBox.NoTimeout)

#functions for searching config
    def show_search_config_form(self):
        self.searchConfigForm=SearchConfigForm(self.websites,self.orientation,self)
        self.connect(self.searchConfigForm.confirmButton, SIGNAL("clicked()"), self.search_config_confirm)
        self.connect(self.searchConfigForm.cancelButton, SIGNAL("clicked()"), self.searchConfigForm.hide)
        self.searchConfigForm.show()

    def search_config_confirm(self):
        self.websites=self.searchConfigForm.output_websites()
        self.controller.update_websites(self.websites)
        self.searchConfigForm.hide()

    def show_search_results_table(self):
        self.searchResultsForm=SearchResultsForm(self.searchResults,self.orientation,self)
        self.connect(self.searchResultsForm.confirmButton, SIGNAL("clicked()"), self.search_results_confirm)
        self.connect(self.searchResultsForm.cancelButton, SIGNAL("clicked()"), self.searchResultsForm.hide)
        self.searchResultsForm.show()

    def search_results_confirm(self):
        rowNum = self.searchResultsForm.get_selected()
        if rowNum==-1:
            self.show_notice(unicode("请选择搜索结果"))
            return
        book=self.searchResults[rowNum]
        self.logger.info("search result choosed, name: "+unicode(book["name"])+", website:"+unicode(book["websiteName"]))
        self.newBookForm.update_new_book(book)
        self.searchResultsForm.hide()

    
#functions for config
    def show_config_form(self):
        self.config=self.load_config()
        self.configForm=ConfigForm(self.config,self,self.orientation)
        self.connect(self.configForm.confirmButton, SIGNAL("clicked()"), self.config_form_confirm)
        self.connect(self.configForm.cancelButton, SIGNAL("clicked()"), self.configForm.hide)
        self.configForm.show()
        
    def config_form_confirm(self):
        self.config=self.configForm.output_config()
        self.save_config()
        self.configForm.hide()
        self.show_notice(unicode("配置保存成功"))

    def load_config(self):
        settings = QSettings(Utils.CONF_FILE_PATH,QSettings.IniFormat)
        orientation=settings.value("Config/orientation",QVariant(0)).toInt()[0]
        lastViewedBookId=settings.value("Config/lastViewedBookId",QVariant(-1)).toInt()[0]
        autoUpdateWhenStart=settings.value("Config/autoUpdateWhenStart",QVariant(0)).toInt()[0]
        scheduledUpdate=settings.value("Config/scheduledUpdate",QVariant(0)).toInt()[0]
        scheduledUpdateTime=settings.value("Config/scheduledUpdateTime",QVariant(60)).toInt()[0]
        storagePath=str(settings.value("Config/storagePath",QVariant(Utils.DEFAULT_DOWNLOADS_PATH)).toString())
        config={"orientation":orientation,"lastViewedBookId":lastViewedBookId,"autoUpdateWhenStart":autoUpdateWhenStart,"scheduledUpdate":scheduledUpdate,
                    "scheduledUpdateTime":scheduledUpdateTime,"storagePath":storagePath}
        return config

    def save_config(self):
        self.logger.info("save_config ")
        settings = QSettings(Utils.CONF_FILE_PATH,QSettings.IniFormat)
        settings.setValue("Config/orientation", QVariant(self.config["orientation"]))
        settings.setValue("Config/lastViewedBookId", QVariant(self.currentBook is None and -1 or self.currentBook["id"]))
        settings.setValue("Config/autoUpdateWhenStart", QVariant(self.config["autoUpdateWhenStart"]))
        settings.setValue("Config/scheduledUpdate", QVariant(self.config["scheduledUpdate"]))
        settings.setValue("Config/scheduledUpdateTime", QVariant(self.config["scheduledUpdateTime"]))
        settings.setValue("Config/storagePath", QVariant(self.config["storagePath"]))
        self.logger.info("save_config done ")

        #switch orientation
        self.switch_orientation(self.config["orientation"])
        #update the scheduledUpdate time interval or start the timer or shutdown the timer
        if self.config["scheduledUpdate"]:
            if self.scheduledUpdateInterval!=self.config["scheduledUpdateTime"]:
                self.scheduledUpdateInterval=int(self.config["scheduledUpdateTime"])
                if self.timerId:
                    self.logger.info("save_config. kill the old timer")
                    self.killTimer(self.timerId)
                self.logger.info("save_config. try to start scheduled update timer, time interval: "+str(self.scheduledUpdateInterval))
                self.timerId=self.startTimer(self.scheduledUpdateInterval*60000)
                if self.timerId==0:
                    self.logger.error("save_config. start scheduled update timer failed!")
                    self.show_notice(unicode("自动更新定时器启动失败"),QMaemo5InformationBox.NoTimeout)
        elif self.timerId:
            self.logger.info("save_config. kill the timer")
            self.killTimer(self.timerId)

    
#functions for updating books
    def update_a_book(self):
#        self.check_connection()
        if self.updateThread.isRunning():
            return
        if self.currentBook is None:
            self.show_notice(unicode("请选择需要更新的小说"))
        else:
            self.logger.info("update_a_book:"+str(self.currentBook["id"])+":"+unicode(self.currentBook["name"]))
            self.bookUpdateAction.setEnabled(0)
            self.bookUpdateAllAction.setEnabled(0)
            self.chapterDownloadAction.setEnabled(0)
            self.bookStopUpdateAction.setEnabled(1)
            self.updateThread.initialize((self.currentBook,),None,self.filepath)
            self.updateThread.start()
            self.set_windows_status(1)

    def update_all_books(self):
#        self.check_connection()
        if self.updateThread.isRunning():
            return
        self.logger.info("update_all_books")
        self.bookUpdateAction.setEnabled(0)
        self.bookUpdateAllAction.setEnabled(0)
        self.chapterDownloadAction.setEnabled(0)
        self.bookStopUpdateAction.setEnabled(1)
        books=self.controller.get_all_books()
        self.updateThread.initialize(books,None,self.filepath)
        self.updateThread.start()
        self.set_windows_status(1)

    def download_a_chapter(self):
#        self.check_connection()
        if self.updateThread.isRunning():
            return
        self.logger.info("download_a_chapter:"+str(self.currentChapter["id"])+":"+unicode(self.currentChapter["title"]))
        self.bookUpdateAction.setEnabled(0)
        self.bookUpdateAllAction.setEnabled(0)
        self.chapterDownloadAction.setEnabled(0)
        self.bookStopUpdateAction.setEnabled(1)
        self.updateThread.initialize(None,(self.currentChapter,),self.filepath)
        self.updateThread.start()
        self.set_windows_status(1)

    def stop_update(self):
        self.logger.info("stop_update")
        if self.updateThread.isRunning():
            self.logger.info("stop_update:update thread is running, try to stop it, please wait")
            self.bookStopUpdateAction.setEnabled(0)
            self.show_notice(unicode("正在停止更新,请等待当前任务结束"))
            self.updateThread.stop()
#            self.updateThread.wait()
        else:
            self.bookUpdateAction.setEnabled(1)
            self.bookUpdateAllAction.setEnabled(1)
            self.chapterDownloadAction.setEnabled(1)
            self.bookStopUpdateAction.setEnabled(0)

    def update_finished(self, completed,updateBooksNum,newChaptersNum,downloadChaptersNum):
        self.logger.info("update_finished")
        self.logger.debug(locals())
        self.logger.info("updated books number:"+str(updateBooksNum)+", new chapters number:"+
            str(newChaptersNum)+", downloaded chapters number:"+str(downloadChaptersNum))
        time=str(datetime.now()).split(".")[0]
        if updateBooksNum +newChaptersNum +downloadChaptersNum>=0:
            if completed:
                message="更新完成于"
            else:
                message="更新终止于"
            message+=time+"\n共更新%s部小说,发现%s个新章节,已下载%s个章节" % (updateBooksNum,newChaptersNum,downloadChaptersNum)
            self.show_notice(unicode(message))
        self.bookUpdateAction.setEnabled(1)
        self.bookUpdateAllAction.setEnabled(1)
        self.chapterDownloadAction.setEnabled(1)
        self.bookStopUpdateAction.setEnabled(0)
        self.set_windows_status(0)

    #once updateThread has download one chapter or updated the catalog, will invoke this
    #to refresh the books list and/or chapters list and/or chapters content view.
    def refresh_after_download_a_chapter(self,bookId,chapterId):
        #always need to refresh the books list
        self.load_books()
        #check if need to refresh the chapters list
        if self.currentBook !=None and bookId==self.currentBook["id"]:
            chapters = self.controller.get_chapters_for_a_book(bookId)
            self.currentChapters=chapters
            self.chaptersWin.load_chapters(chapters)
            #check if need to reload the chapter content form
            if self.currentChapter!=None and chapterId==self.currentChapter["id"]:
                self.load_chapter_content(self.currentChapter)

#functions for searching books
    def search_book(self):
        self.logger.info("search_book")
        if self.newBookForm.bookNameLE.text() is None:
            self.show_notice(unicode("请输入要搜索的小说名称"))
            return
        bookName=str(self.newBookForm.bookNameLE.text()).strip()
        if len(bookName)==0:
            self.show_notice(unicode("请输入要搜索的小说名称"))
            return
        websiteSelected=0
        for website in self.websites:
            if website["enabled"]:
                websiteSelected=1
                break
        if websiteSelected==0:
            self.show_notice(unicode("未选择搜索网站"))
            return
#        self.check_connection()
        self.logger.info("search_book:name:"+unicode(bookName))
        self.searchResults=[]
        self.searchThread.initialize(self.websites,bookName)
        self.progressWin=QProgressDialog(self)
        self.progressWin.setWindowTitle(unicode("搜索  "+bookName))
        self.searchCancelBtn=QPushButton(unicode("停止"))
        self.progressWin.setCancelButton(self.searchCancelBtn)
        self.connect(self.searchCancelBtn, SIGNAL("clicked()"),
                     self.stop_search)
        self.progressWin.show()
        self.searchThread.start()

    def show_search_progress(self,int):
        self.progressWin.setValue(int)

    def search_finished(self,completed,websiteNum=0,resultsNum=0):
        self.logger.info("search_finished")
        self.logger.debug(locals())
        self.logger.info("searched websites number:"+str(websiteNum)+", found matched results number:"+str(resultsNum))
        self.show_search_progress(100)
        self.progressWin.hide()
        if completed:
                message="搜索已完成"
        else:
            message="搜索被终止"
        message+="\n共搜索%s个网站,返回%s条记录" % (websiteNum,resultsNum)
        self.show_notice(unicode(message))
#        self.show_progress(100)
        self.searchResults=self.searchThread.searchResults
        if len(self.searchResults)>0:
            self.show_search_results_table()

    def stop_search(self):
        self.logger.info("stop_search")
        if self.searchThread.isRunning():
            self.logger.info("stop_search: search thread is running, try to stop it,please wait")
            self.show_notice(unicode("正在停止搜索..."))
            self.searchCancelBtn.setEnabled(0)
            self.searchThread.stop()

#functions for others
    def show_about_form(self):
        self.aboutForm=AboutForm(self)
        self.aboutForm.show()

    def show_log_window(self):
        self.logWin.show()

    def show_notice(self,message,timeout=QMaemo5InformationBox.DefaultTimeout):
        QMaemo5InformationBox.information(self,"\n"+unicode(message)+"\n",timeout)

    def switch_orientation(self,newOrientation):
        if newOrientation=='2':
            self.setAttribute(Qt.WA_Maemo5AutoOrientation, True)
            self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, False)
            self.setAttribute(Qt.WA_Maemo5PortraitOrientation, False)
            self.connect(QApplication.desktop(), SIGNAL("resized(int)"),self.orientation_changed)
        elif newOrientation=='0':
            self.orientation=0
            self.contentWin.switch(self.orientation)
            self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, True)
            self.setAttribute(Qt.WA_Maemo5AutoOrientation, False)
            self.setAttribute(Qt.WA_Maemo5PortraitOrientation, False)
        elif newOrientation=='1':
            self.orientation=1
            self.contentWin.switch(self.orientation)
            self.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
            self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, False)
            self.setAttribute(Qt.WA_Maemo5AutoOrientation, False)
#        self.create_books_window()
#        self.show_books_window()

    def orientation_changed(self):
        screenGeometry = QApplication.desktop().screenGeometry();
        if (screenGeometry.width() > screenGeometry.height()):
            self.orientation=0
#            self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, True)
#            self.setAttribute(Qt.WA_Maemo5PortraitOrientation, False)
        else:
            self.orientation=1
#            self.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
#            self.setAttribute(Qt.WA_Maemo5LandscapeOrientation, False)
#        self.booksListView.setItemDelegate(HtmlCellDelegate(self.orientation))
#        self.booksListView.repaint()
        if self.contentWin!=None:
            self.contentWin.switch(self.orientation)
        if self.configForm!=None:
            self.configForm.switch(self.orientation)
        if self.newBookForm!=None:
            self.newBookForm.switch(self.orientation)
        if self.delBookForm!=None:
            self.delBookForm.switch(self.orientation)
        if self.searchConfigForm!=None:
            self.searchConfigForm.switch(self.orientation)
        if self.searchResultsForm!=None:
            self.searchResultsForm.switch(self.orientation)
        if self.chaptersManaWin!=None:
            self.chaptersManaWin.switch(self.orientation)

    def set_windows_status(self,busy):
        if busy>0:
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            self.chaptersWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            self.contentWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            self.logWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
            if self.chaptersManaWin!=None:
                self.chaptersManaWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Checked)
        else:
            self.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            self.chaptersWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            self.contentWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            self.logWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)
            if self.chaptersManaWin!=None:
                self.chaptersManaWin.setAttribute(Qt.WA_Maemo5ShowProgressIndicator, Qt.Unchecked)

    def create_action(self, text, slot=None, shortcut=None, icon=None,
                  tip=None, checkable=False, signal="triggered()"):
        action = QAction(text, self)
        if icon is not None:
            action.setIcon(QIcon(":/%s.png" % icon))
        if shortcut is not None:
            action.setShortcut(shortcut)
        if tip is not None:
            action.setToolTip(tip)
        if slot is not None:
            self.connect(action, SIGNAL(signal), slot)
        if checkable:
            action.setCheckable(True)
        return action

    def add_actions(self, target, actions):
        for action in actions:
            if action is None:
                target.addSeparator()
            else:
                target.addAction(action)

            
#    def icd2_state_listener(self, *args):
#        print "icd2_state_listener got args:\n";
#        print args
#        self.expect_state_signals = self.expect_state_signals -1
#        if self.expect_state_signals <= 0:
#            self.loop.quit()

#    def icd2_state(self):
#        self.icd2_obj.connect_to_signal('state_sig', self.icd2_state_listener, 'com.nokia.icd2', byte_arrays=True)
#        self.expect_state_signals = self.icd2_iface.state_req()
#        self.loop.run()

#    def check_connection(self):
#        pass
#        self.bus = dbus.SystemBus()
#        self.loop = gobject.MainLoop()
#        self.expect_state_signals = 0
##        self.icd_obj = self.bus.get_object('com.nokia.icd', '/com/nokia/icd')
##        self.icd_iface = dbus.Interface(self.icd_obj, 'com.nokia.icd')
#        self.icd2_obj = self.bus.get_object('com.nokia.icd2', '/com/nokia/icd2')
#        self.icd2_iface = dbus.Interface(self.icd2_obj, 'com.nokia.icd2')
#        self.icd2_obj.connect_to_signal('state_sig', self.icd2_state_listener, 'com.nokia.icd2', byte_arrays=True)
#        self.expect_state_signals = self.icd2_iface.state_req()
#        print "aaaa",self.expect_state_signals
##        if self.expect_state_signals==0:
##            self.icd2_iface.connect_req(
##                #dbus.UInt32(0), # ICD_CONNECTION_FLAG_APPLICATION_EVENT 0x0
##                dbus.UInt32(32768))
#        self.loop.run()

#        ret = self.icd2_iface.connect_req(
#            #dbus.UInt32(0), # ICD_CONNECTION_FLAG_APPLICATION_EVENT 0x0
#            dbus.UInt32(32768), # ICD_CONNECTION_FLAG_UI_EVENT 0x8000
#            #dbus.UInt32(1), # ICD_CONNECTION_FLAG_USER_EVENT 0x1
#            dbus.Array( # API Documentation seems to be wrong, dbus-monitor shows array of structs and the earlier approach gave exceptions
#                [
#                    dbus.Struct(
#                        [
#                            dbus.String(""),
#                            dbus.UInt32(0),
#                            dbus.String(""),
#                            dbus.String("GPRS"),
#                            dbus.UInt32(83886080), # CD_NW_ATTR_AUTOCONNECT   0x04000000 & ICD_NW_ATTR_IAPNAME   0x01000000
#                            dbus.Array(connection_array)
#                        ]
#                    )
#                ]
#            )
#        )
#        print ret

    def closeEvent(self, event):
        if self.ok_to_exit():
#            for k,v in self.booksLastViewdChapter.items():
#                book=self.booksDict[k]
#                book["lastViewedChapterId"]=v
#                self.controller.save_a_book(book,self.filepath)
            self.save_config()
        else:
            event.ignore()

    def timerEvent (self, event):
        self.update_all_books()

    def contextMenuEvent (self, event):
        popup=QMenu(self)
#        bookEditAction = self.create_action(unicode("编辑"), self.edit_book)
#        bookDeleteAction = self.create_action(unicode("删除"), self.delete_book)
        bookEditAction = QAction(unicode("编辑"),None)
        bookDeleteAction =QAction(unicode("删除"),None)

        popup.addAction(bookEditAction)
        popup.addAction(bookDeleteAction)

#        index=self.booksListView.indexAt(event.globalPos())
        index=self.booksListView.currentIndex()
        book=self.booksModel.data(index,Qt.EditRole)
        if book["websiteId"]==Utils.UMD_WEBSITE_ID:
            bookEditAction.setEnabled(0)
        action=popup.exec_(event.globalPos())
        if action is bookEditAction:
            self.edit_book(index)
        elif action is bookDeleteAction:
            self.delete_book(index)

    def ok_to_exit(self):
        if self.updateThread.isRunning():
            self.stop_update()
            return False
        if self.searchThread.isRunning():
            self.stop_search()
            return False
        return True

def main():
    reload(sys)
    sys.setdefaultencoding('utf8')
    QTextCodec.setCodecForCStrings(QTextCodec.codecForName("UTF-8"))
    app = QApplication(sys.argv)
    app.setOrganizationName("SkyBlue Works")
    app.setOrganizationDomain("michaelwong.cn")
    app.setApplicationName("N3DR")
    form = MainWindow()
#    logWin=LogWindow(form)
#    form.set_log_win(logWin)

#    logging.basicConfig(level=logging.INFO,
#                        format='%(asctime)s %(name)-12s %(levelname)-8s %(message)s',
#                        datefmt='%y-%m-%d %H:%M',
#                        filename='n3dr.log',
#                        filemode='w')
#    # define a Handler which writes INFO messages or higher to the sys.stderr
#    console = logging.StreamHandler(logWin)
#    console.setLevel(logging.INFO)
#    # set a format which is simpler for console use
#    formatter = logging.Formatter('%(asctime)s %(name)-12s %(levelname)-8s %(message)s')
#    # tell the handler to use this format
#    console.setFormatter(formatter)
#    # add the handler to the root self.logger
#    logging.getLogger('').addHandler(console)
    
    form.show()
    app.exec_()


main()
