# -*- coding: utf-8 -*-

'''
Created on 2010-1-15

@author: Michael
'''

import urllib2
from urllib2 import URLError
import socket
import sys
from Exceptions import *

class Downloader():
    def __init__(self,logger):
#        self.logger = logging.getLogger('Downloader')
        self.logger=logger
        timeout = 40
        socket.setdefaulttimeout(timeout)

    def check_if_latest(self, book):
        """
        use HTTP Header Last-Modified and ETag to check if the web page is latest
        return value:
        headers{}, if it is latest, return None
        """
        self.logger.debug('Downloader.check_if_latest')
        self.logger.debug("book name:"+book["name"]+"; book url:"+book["url"])
        self.logger.debug(book)

        headers=self.get_headers(book["url"])

        if book["lastModified"]==None or book["eTag"]==None or book["lastModified"]=="" or book["eTag"]=="":
            self.logger.debug("this book is NOT latest")
            return headers
        if  book["lastModified"]==headers["last-modified"] and book["eTag"]==headers["etag"]:
            self.logger.debug("this book is latest")
            return None
        self.logger.debug("this book is NOT latest")
        return headers

    def get_headers(self, url):
        """
        get HTTP response headers
        """
        self.logger.debug('Downloader.get_headers')
        self.logger.debug(url)
        try:
            request = urllib2.Request(url)
            opener = urllib2.build_opener()
            s = opener.open(request)
            opener.close()
        except:
            self.logger.error(sys.exc_info()[0])
            raise NetworkError
        self.logger.debug(s.headers.dict)
        return s.headers.dict

    def download(self, url):
        """
        download the web page content or a picture
        return value:
        string
        """
        self.logger.debug('Downloader.download')
        self.logger.debug("downloading from url: "+url)
        try:
            sock = urllib2.urlopen(url)
            source = sock.read()
            sock.close()
        except URLError, e:
            if hasattr(e, 'reason'):
                print 'We failed to reach a server.'
                print 'Reason: ', e.reason
            elif hasattr(e, 'code'):
                print 'The server couldn\'t fulfill the request.'
                print 'Error code: ', e.code
            raise NetworkError
        except:
            self.logger.error(sys.exc_info()[0])
            raise NetworkError
        self.logger.debug("download completed")
        self.logger.debug(source)
        return source
