#define CTF_LOG_FORMAT_USE_TIME
#define CTF_THROW_EXIT

#include "../CTF/src/ctf.h"
#include <kernel/general.h>
#include <msa_module.h>
#include <gconf/gconf-client.h>
#include <glib.h>
#include "kernel_test_func.h"
#include "kernel/kernel.h"
#include "kernel/handler.h"
#include "handler_test_func.h"


GLOBAL_DECL();

CTF_TEST_DATA_FILE_NAME_DECL;
CTF_STAT_FILE_NAME_DECL;




CTF_TEST_CASE(create_xml_doc_with_root_test) {

    CTF_TEST_NAME("create_xml_doc_with_root_test");

    xmlNodePtr node = xmlNewNode(NULL, "root");

    xmlDocPtr doc = create_xml_doc_with_root_call(node);
    xmlNodePtr root_node = xmlDocGetRootElement(doc);
    CTF_CHECK(!strcmp(root_node->name, node->name));

    CTF_TEST_NAME("create_xml_doc_with_root_test(incorrect node)");
    doc = create_xml_doc_with_root_call(NULL);
    CTF_CHECK(doc == NULL);
}


/* Status for transit data structure, sets for each target */
typedef enum process_status {
    NOT_SEND = 0,       // Message not send yet.
    IN_PROCESS = 2,     // Message is processed by "target". 
    PROCESSED = 4,      // Message processed by "target".
    FORCE_REMOVE = 8,   // Remove "target" from send message process. 
    IGNORE = 16         // Ignore send message for "target'.
} process_status;


 typedef struct targets {
    xmlChar* name;          // Target name.
    gint order_number;      // Order number in query.
    process_status status;  // Target status.
    guint attempts_count;   // Count of send message. 
} target_data;


CTF_TEST_CASE(get_inner_content_test) {

    CTF_TEST_NAME("get_inner_content_test");

    xmlDocPtr test_data = xmlParseDoc("<?xml version=\"1.0\"?><TransitData><SourceID>ui</SourceID><TargetID>Target1</TargetID><TargetID>Target2</TargetID><Content><Request class=\"profile\" function=\"getProfile\"><Params></Params></Request></Content><new_root><new_sub_root></new_sub_root></new_root></TransitData>");

    xmlDocPtr new_doc = get_inner_content_call(test_data, "new_root");
    xmlNodePtr root_node = xmlDocGetRootElement(new_doc);
    CTF_CHECK(!strcmp(root_node->name, "new_sub_root"));

    CTF_TEST_NAME("get_inner_content_test(no node)");    
    new_doc = get_inner_content_call(test_data, "some_node");
    CTF_CHECK(new_doc == NULL);
    
    
    CTF_TEST_NAME("get_inner_content_test(name = NULL)");    
    new_doc = get_inner_content_call(test_data, NULL);
    CTF_CHECK(new_doc == NULL);
    
    CTF_TEST_NAME("get_inner_content_test(doc = NULL)");    
    new_doc = get_inner_content_call(NULL, "new_node");
    CTF_CHECK(new_doc == NULL);
    
    test_data = xmlParseDoc("<?xml version=\"1.0\"?>");
    
    CTF_TEST_NAME("get_inner_content_test(empty doc)");    
    new_doc = get_inner_content_call(test_data, "new_node");
    CTF_CHECK(new_doc == NULL);
 
}



CTF_TEST_CASE(convert_to_handler_format_test) {

    CTF_TEST_NAME("convert_to_handler_format_test");

    xmlDocPtr test_data = xmlParseDoc("<?xml version=\"1.0\"?><TransitData type=\"signal\">\
<SourceID>SignalSourceID</SourceID>\
<TargetID>SignalTargetID</TargetID>\
<Content>\
<Signal id=\"signalID\">\
<StartTime>15</StartTime>\
<Action>set</Action>\
<RepeatTime>10</RepeatTime>\
<Content>\
<TransitData id=\"trID\" type=\"data\">\
<SourceID>sID</SourceID>\
<TargetID>tID</TargetID>\
<Content>\
<TransitData id=\"0\" type=\"data\">\
<SourceID>kernel</SourceID>\
<TargetID>kernel</TargetID>\
<Content></Content>\
</TransitData>\
</Content>\
</TransitData>\
</Content>\
</Signal>\
</Content>\
</TransitData>");

    action_type action;
    
    signal_data* signal = convert_to_handler_format_call(test_data, &action);

    CTF_CHECK(!strcmp(signal->id, "signalID"));    
    CTF_CHECK(!strcmp(signal->source_id, "SignalSourceID"));        
    CTF_CHECK(signal->start_time == 15);        
    CTF_CHECK(signal->repeat_time == 10);        
    CTF_CHECK(action == SET_SIGNAL);        
    
    xmlNodePtr root_node = xmlDocGetRootElement(signal->data);
    CTF_CHECK(!strcmp(xmlGetProp(root_node, "id"), "trID"));    

   
    CTF_TEST_NAME("convert_to_handler_format_test(no signal)");
    
    test_data = xmlParseDoc("<?xml version=\"1.0\"?><TransitData type=\"signal\">\
    <SourceID>SignalSourceID</SourceID>\
<TargetID>SignalTargetID</TargetID>\
<Content>\
<Content>\
<TransitData id=\"trID\" type=\"data\">\
<SourceID>sID</SourceID>\
<TargetID>tID</TargetID>\
<Content>content</Content>\
</TransitData>\
</Content>\
</Content>\
</TransitData>");

    signal = convert_to_handler_format_call(test_data, &action);

    CTF_CHECK(signal == NULL);    

    
    CTF_TEST_NAME("convert_to_handler_format_test(incorrect doc)");
     
    test_data = xmlParseDoc("<?xml version=\"1.0\"?><TransitData type=\"signal\">\
</TransitData>");

    signal = convert_to_handler_format_call(test_data, &action);

    CTF_CHECK(signal == NULL);    
    
    
    CTF_TEST_NAME("convert_to_handler_format_test(doc == NULL)");
    signal = convert_to_handler_format_call(NULL, &action);
    CTF_CHECK(signal == NULL);    



    CTF_TEST_NAME("convert_to_handler_format_test(signal witout content)");

    test_data = xmlParseDoc("<?xml version=\"1.0\"?><TransitData type=\"signal\">\
<SourceID>SignalSourceID</SourceID>\
<TargetID>SignalTargetID</TargetID>\
<Content>\
<Signal id=\"signalID\">\
<StartTime>15</StartTime>\
<Action>set</Action>\
<RepeatTime>10</RepeatTime>\
</Signal>\
</Content>\
</TransitData>");

    signal = convert_to_handler_format_call(test_data, &action);
    CTF_CHECK(signal == NULL);    
        

 CTF_TEST_NAME("convert_to_handler_format_test(no signal content, signal remove)");

    test_data = xmlParseDoc("<?xml version=\"1.0\"?><TransitData type=\"signal\">\
<SourceID>SignalSourceID</SourceID>\
<TargetID>SignalTargetID</TargetID>\
<Content>\
<Signal id=\"signalID\">\
<StartTime>15</StartTime>\
<Action>remove</Action>\
<RepeatTime>10</RepeatTime>\
</Signal>\
</Content>\
</TransitData>");

    signal = convert_to_handler_format_call(test_data, &action);
    

    CTF_CHECK(!strcmp(signal->id, "signalID"));    
    CTF_CHECK(!strcmp(signal->source_id, "SignalSourceID"));        
    CTF_CHECK(signal->start_time == 15);        
    CTF_CHECK(signal->repeat_time == 10);        
    CTF_CHECK(action == REMOVE_SIGNAL);
    CTF_CHECK(signal->data == NULL);

}


