/*
 * ui.h - UI of MSA program.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Andrey Bogachev
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _MSA_UI_H
#define _MSA_UI_H

#include <glib/gprintf.h>
#include <glib.h>

#include <mysocials_driver.h>

#include "ui_general.h"
#include "ui_strings.h"
#include "../msa_module.h"

extern int msa_module_init(msa_module*);
static void ui_start(gpointer _data, gpointer list_drv, int argc, char* argv[]);
static void ui_thread(gpointer);
int ui_got_response(xmlDocPtr, xmlDocPtr*, msa_module* ui_info_not_use);
int set_profile(gpointer);
gboolean ui_driver_get_profile(gpointer);
gboolean ui_driver_get_friends(gpointer);

gboolean ui_show_error(gpointer);
gboolean ui_show_info(gpointer);
gboolean ui_show_img(gpointer);
gboolean ui_show_captcha(gpointer);
void ui_img_req(gpointer);

int ui_driver_get_messages(gpointer);
gpointer ui_friend(gpointer);
gboolean ui_driver_get_friends_profile(gpointer);
gpointer ui_message(gpointer);
int get_function_from_response(xmlDocPtr, char**, char**);
gboolean ui_driver_get_settings(gpointer);
static gpointer ui_init_detail(gchar*, gchar*);
static gpointer ui_init_date_chooser(gchar*, gchar*);
static gpointer ui_init_label(gchar*);
xmlNodePtr node_search(xmlNodePtr, char*);
gboolean remove_friends_img(gpointer, gpointer value, gpointer);

Friend *struct_friend_create();
void struct_friend_free(Friend *friend);

#endif

