<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:bio="http://purl.org/vocab/bio/0.1/"
    xmlns:foaf="http://xmlns.com/foaf/0.1/"
    xmlns:sonet="http://cs.karelia.ru/social_network/"
    xmlns:contact="http://www.w3.org/2000/10/swap/pim/contact"
    xmlns:ad="http://schemas.talis.com/2005/address/schema#"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:doclist="http://www.junkwork.net/xml/DocumentList#"
           
    version="1.0"
	exclude-result-prefixe="rdf sonet foaf bio xsl contact ad dc doclist"
    extension-element-prefixes="rdf sonet foaf bio xsl contact ad dc doclist" >

	<xsl:param name="ID"></xsl:param>
	<xsl:param name="FROM" select="1"></xsl:param>
	<xsl:param name="TO" select="10"></xsl:param>
	<xsl:param name="ALL"></xsl:param>	
	<xsl:param name="ONLINE"></xsl:param>
	<xsl:param name="SEARCH"></xsl:param>
	<xsl:param name="ORDER"></xsl:param>
		

    <xsl:variable name="lower">abcdefghijklmnopqrstuvwxyz йцукенгшщзхъфывапролджэячсмитьбю</xsl:variable> 
    <xsl:variable name="upper">ABCDEFGHIJKLMNOPQRSTUVWXYZ ЙЦУКЕНГШЩЗХЪФЫВАПРОЛДЖЭЯЧСМИТЬБЮ</xsl:variable>


    <xsl:output  method="xml" indent="yes"   encoding="UTF-8"/>

	<xsl:template match="rdf:RDF">
	<data>
        <xsl:choose>
            <xsl:when test="$ORDER = 1">
            	<xsl:apply-templates>
                    <xsl:sort order="descending" select="foaf:firstName" />
            	</xsl:apply-templates>                        
            </xsl:when>

            <xsl:when test="$ORDER = 2">
            	<xsl:apply-templates>
                    <xsl:sort order="ascending" select="foaf:firstName" />
            	</xsl:apply-templates>                        
            </xsl:when>

            <xsl:otherwise>
                <xsl:apply-templates />
            </xsl:otherwise>            
        </xsl:choose>       
	</data>	
	</xsl:template>

        <!-- "position() - 1" because have rdf:RDF -->
	<xsl:template match="sonet:Contact"> 
	        <xsl:variable name="contactName" select="translate(foaf:firstName, $upper, $lower)"/>   
        
			<xsl:if test="(position() - 1 >= $FROM and not(position() - 1 > $TO) and $ALL)
			or ($ONLINE and foaf:firstStatus = 1) 
			or ($SEARCH and contains($contactName, $SEARCH))" >

        	<struct>
			
				<xsl:attribute name="name">
					<xsl:text>contact</xsl:text>
				</xsl:attribute>

				<xsl:attribute name="id">
					<xsl:value-of select="@rdf:ID" />
				</xsl:attribute>		
		
				<string>
					<xsl:attribute name="name">
						<xsl:text>FriendName</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="foaf:firstName"/>			
				</string>
		
				<string>
					<xsl:attribute name="name">
						<xsl:text>FriendStatus</xsl:text>
					</xsl:attribute>				
					<xsl:value-of select="foaf:firstStatus"/>			
				</string>

				<img>
					<xsl:attribute name="uri">
						<xsl:value-of select="sonet:img/@sonet:BinaryID"/>
					</xsl:attribute>			
					<xsl:value-of select="sonet:img"/>			
				</img>

			</struct>

        </xsl:if>
	</xsl:template>

	
</xsl:stylesheet>
