/*
 * db_msa_logic.c - logic function for MSA db.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Alexander A. Lomov
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

// FIXME: fix all. rewrite functions
 
#include "db.h"
#include "db_logic.h"
#include "db_functions.h"
#include "db_xml_functions.h"

#define METACONTACTS_SCHEMA_NAME "metacontacts"
#define CONTACTS_SCHEMA_NAME "contacts"
#define METACONTAC_SCHEMA_NAME "messages"

//"//foaf:Person[@rdf:ID='0' and foaf:firstName='XXX' and foaf:surname='FFFF1']"

#define XPATH_METACONTACT_PATH "//foaf:Person[@rdf:ID=\"0\"" 
#define FOAF_NAME "foaf:firstName"
#define FOAF_SURNAME "foaf:surname"

#define XPATH_NAME_SURNAME "//Params/string[@name=\"FirstName\" or @name=\"LastName\"]"

#define XSLT_PARAM_POS_FROM "FROM"
#define XSLT_PARAM_POS_TO "TO"
#define XSLT_PARAM_ALL_NODES "ALL"
#define XSLT_PARAM_SEARCH_DATA "SEARCH"
#define XSLT_PARAM_ONLINE_CONTACS "ONLINE"
#define XSLT_PARAM_ORDER "ORDER"
#define XSLT_PARAM_ORDER_DESC "1"
#define XSLT_PARAM_ORDER_ASC "2"


gint create_owner_metacontact(xmlDocPtr doc) {
      
    if (doc == NULL) {
        return FAILURE;
    }
    
    
    xmlXPathObjectPtr result = db_get_nodeset(doc, BAD_CAST XPATH_NAME_SURNAME, NULL);

    xmlChar* first_name = NULL;
    xmlChar* surname = NULL;    
        
	if (result) {
   		xmlNodeSetPtr nodeset = result->nodesetval;

		if (nodeset->nodeNr == 2) {
		    xmlChar* firstname = xmlGetProp(nodeset->nodeTab[0], BAD_CAST "name");
            if (xmlStrcmp(firstname, BAD_CAST "FirstName") == 0) {
                first_name = xmlNodeGetContent(nodeset->nodeTab[0]);
                surname = xmlNodeGetContent(nodeset->nodeTab[1]);                		
                	
		    } else {
                first_name = xmlNodeGetContent(nodeset->nodeTab[1]);
                surname = xmlNodeGetContent(nodeset->nodeTab[0]);   		    
		    }
		    xmlFree(firstname);
		}
   		xmlXPathFreeObject(result);
	} 
    
    xmlChar* ns = BAD_CAST cm_get_namespaces_key(METACONTACTS_SCHEMA_NAME);
    xmlDocPtr metacontacts = get_table_from_list(METACONTACTS_SCHEMA_NAME);    
    
    xmlChar* xpath = BAD_CAST g_strconcat(XPATH_METACONTACT_PATH, " and ", FOAF_NAME, "=\"", first_name, "\" and ", FOAF_SURNAME, "=\"", surname, "\"]", NULL);    

    if (first_name != NULL && surname != NULL) {
        if (db_get_nodes_count(metacontacts, xpath, ns) == 0) {

            db_remove_node_by_id(SCHEMA_NAME_CONTACTS_LIST , "*");
            db_remove_node_by_id(SCHEMA_NAME_CONTACTS , "*");
            db_remove_node_by_id(SCHEMA_NAME_MESSAGES , "*");
            db_remove_node_by_id(SCHEMA_NAME_OWNER_MESSAGES, "*");    


            gchar* db_path = cm_get_db_path_by_name_or_default(NULL);

            xmlDocPtr doc = get_table_from_list(SCHEMA_NAME_CONTACTS_LIST);    
            db_save_table(doc, SCHEMA_NAME_CONTACTS_LIST, db_path);
            
            doc = get_table_from_list(SCHEMA_NAME_CONTACTS);    
            db_save_table(doc, SCHEMA_NAME_CONTACTS, db_path);
            
            doc = get_table_from_list(SCHEMA_NAME_MESSAGES);    
            db_save_table(doc, SCHEMA_NAME_MESSAGES, db_path);
            
            doc = get_table_from_list(SCHEMA_NAME_OWNER_MESSAGES);    
            db_save_table(doc, SCHEMA_NAME_OWNER_MESSAGES, db_path);

            g_free(db_path);

        }
    }
    
    
    g_free(xpath);      
    xmlFree(first_name);
    xmlFree(surname);
    xmlFree(ns);
    
    gchar** params = g_new(gchar*, 3);
                    
    params[0] = g_strdup("ID");
    params[1] = g_strdup("0");
    params[2] = NULL;       
    
    db_remove_node_by_id(METACONTACTS_SCHEMA_NAME , "*");
    
    db_add_data_to_db_with_id(METACONTACTS_SCHEMA_NAME, doc, (const gchar**)params);
    
    g_strfreev(params);
        
    return SUCCESS;
}


gchar* create_metacontact(xmlDocPtr doc) 
{
    return db_add_data_to_db(METACONTACTS_SCHEMA_NAME, doc, NULL);
}


#define LINK_PREFIX "contact"
#define LINK_NAMESPACE "http://www.w3.org/2000/10/swap/pim/contact"
#define DB_XPATH_KNOWNAS_ID_REQ "//foaf:Person/contact:knownAs[@rdf:ID"
#define ID_NAMESPACE "http://www.w3.org/1999/02/22-rdf-syntax-ns#"
#define ID_NAME "ID"
#define ID_PREFIX "rdf"
#define DB_XPATH_PERSON_REQ "//foaf:Person"
#define DB_XPATH_CONTACT_REQ "//sonet:Contact"
#define DB_XPATH_MESSAGE_REQ "//doclist:Document"
#define DB_XPATH_KNOWNAS_REQ "contact:knownAs"
#define RDF_ID "rdf:ID"
#define RDF_ID_ATTR "@rdf:ID"

#define XPATH_OWNER_CONTACTS_IDS DB_XPATH_PERSON_REQ"[@"RDF_ID"='0']/"DB_XPATH_KNOWNAS_REQ"/@"RDF_ID 


static xmlNodePtr create_link_node(const gchar* id_value)
{
    xmlNodePtr node = xmlNewNode(NULL, BAD_CAST "knownAs");
    xmlNsPtr ns = xmlNewNs(node, BAD_CAST LINK_NAMESPACE, BAD_CAST LINK_PREFIX);
    xmlSetNs(node, ns);
    xmlNsPtr id_ns = xmlNewNs(NULL, BAD_CAST ID_NAMESPACE, BAD_CAST ID_PREFIX);        
    xmlNewNsProp(node, id_ns, BAD_CAST ID_NAME, BAD_CAST id_value);
    
    return node;
}

static gchar* build_contacts_xpath(gboolean with_owner) 
{
    gchar* xpath_req = XPATH_OWNER_CONTACTS_IDS;
    GSList* nodes = get_nodes_ids(METACONTACTS_SCHEMA_NAME, xpath_req);

    gchar* xpath_contact = NULL;
    
    if (nodes != NULL && with_owner == FALSE) {
        gchar* filter = create_list_value_filter(RDF_ID_ATTR, nodes, "or");
        gchar** split_filter = g_strsplit_set(filter, "[]", 3);
        
        xpath_contact = g_strconcat(DB_XPATH_PERSON_REQ, "[not(", split_filter[1], ")]", NULL);
        g_strfreev(split_filter);   
        g_free(filter);
    } else {
        xpath_contact = g_strdup(DB_XPATH_PERSON_REQ);
    }
    
    GSList* list_walker = nodes;
    while (list_walker) {
        g_free(list_walker->data);
        list_walker->data = NULL;
        list_walker = g_slist_next(list_walker);
    }
    g_slist_free(nodes);

    return xpath_contact;    
}

GSList* db_get_owner_profile() 
{
    GSList* list = db_get_node_by_id(METACONTACTS_SCHEMA_NAME, "0");
    return list; 
}



static gint count_table_records(xmlDocPtr doc)
{
    if (doc == NULL) {
        return 0;
    }
    
    xmlNodePtr root = xmlDocGetRootElement(doc);
    
    if (root == NULL) {
        return 0;
    }
    
    if (root->children == NULL) {
        return 0;
    }    
    
    xmlNodePtr node = root->children;
    
    gint counter = 0;
    while (node != NULL) {
        ++counter;
        node = node->next;
    }

    return counter;
}



xmlDocPtr get_filtered_messages(const gchar* schema_name, const gchar* schema_name_filter,
        const gchar* from, const gchar* to, gint *quantity)
{
   xmlDocPtr messages_list_table = get_table_from_list(schema_name);    
    
    *quantity = count_table_records(messages_list_table);
    
    gchar** params = NULL;
    
    if (from == NULL || to == NULL) {
        params = g_new(gchar*, 3);    
        params[0] = g_strdup("ALL");
        params[1] = g_strdup("1");
        params[2] = NULL;       
    } else {
        params = g_new(gchar*, 5);    
        params[0] = g_strdup("FROM");
        params[1] = g_strdup(from);
        params[2] = g_strdup("TO");
        params[3] = g_strdup(to);
        params[4] = NULL;       
    }
    

    xmlDocPtr external_format = 
        db_apply_revers_stylesheet(schema_name_filter, 
            (const xmlDocPtr) messages_list_table, (const gchar**) params);
    g_strfreev(params);

    if (external_format == NULL) {
        return NULL;
    }    
    
    if (xmlDocGetRootElement(external_format) == NULL) {
        xmlFreeDoc(external_format);
        external_format = NULL;
    }

    return external_format;
}        

xmlDocPtr get_owner_messages_with_filter(const gchar* from, const gchar* to, gint *quantity) 
{
    return get_filtered_messages(SCHEMA_NAME_OWNER_MESSAGES, 
                SCHEMA_NAME_OWNER_MESSAGES_FILTER, from, to, quantity);
}


xmlDocPtr get_messages_with_filter(const gchar* from, const gchar* to, gint *quantity) 
{
    return get_filtered_messages(SCHEMA_NAME_MESSAGES, 
                SCHEMA_NAME_MESSAGES_FILTER, from, to, quantity);
}



GSList* get_messages() 
{

    xmlChar* ns = BAD_CAST cm_get_namespaces_key(SCHEMA_NAME_MESSAGES);
    xmlDocPtr messages_list_table = get_table_from_list(SCHEMA_NAME_MESSAGES);    
    gchar* xpath_req = g_strdup(DB_XPATH_MESSAGE_REQ);//build_contacts_xpath(with_owner);

    xmlXPathObjectPtr result = db_get_nodeset(messages_list_table, BAD_CAST xpath_req, ns);
    
    g_free(ns);
    g_free(xpath_req);

    GSList* doc_list = NULL; 

    if (result != NULL) {
	    xmlNodeSetPtr nodeset = result->nodesetval;

        for(gint i = nodeset->nodeNr - 1; i >= 0; --i) {
		    xmlNodePtr node = xmlCopyNode(nodeset->nodeTab[i], 1);
		    xmlBufferPtr buf = xmlBufferCreate();
		    xmlNodeDump(buf, NULL, node, 0, 1);
	        xmlChar* content = (xmlChar*)xmlBufferContent(buf);

	        xmlDocPtr elem = xmlParseDoc(content);
	        
            xmlDocPtr external_format = db_apply_revers_stylesheet(SCHEMA_NAME_MESSAGES, elem, NULL);
	        
   	        load_binary_data_to_doc(SCHEMA_NAME_MESSAGES, external_format);

	        doc_list = g_slist_prepend(doc_list, xmlCopyDoc(external_format,1));
   	        xmlFreeDoc(external_format);
   	        xmlFreeDoc(elem);    
   	        xmlFreeNode(node);
	        //xmlFree(content);
            xmlBufferFree(buf);
                    
        }
        
        xmlXPathFreeObject(result);	         
    }
    return doc_list;
}


GSList* get_owner_messages() 
{

    xmlChar* ns = BAD_CAST cm_get_namespaces_key(SCHEMA_NAME_OWNER_MESSAGES);
    xmlDocPtr messages_list_table = get_table_from_list(SCHEMA_NAME_OWNER_MESSAGES);    
    gchar* xpath_req = g_strdup(DB_XPATH_MESSAGE_REQ);//build_contacts_xpath(with_owner);

    xmlXPathObjectPtr result = db_get_nodeset(messages_list_table, BAD_CAST xpath_req, ns);

    g_free(ns);
    g_free(xpath_req);

    GSList* doc_list = NULL; 

    if (result != NULL) {
	    xmlNodeSetPtr nodeset = result->nodesetval;
		
        gint size = nodeset->nodeNr - 1;

        for(gint i = size; i >= 0; --i) {
		    xmlNodePtr node = xmlCopyNode(nodeset->nodeTab[i], 1);
		    xmlBufferPtr buf = xmlBufferCreate();
		    xmlNodeDump(buf, NULL, node, 0, 1);
	        xmlChar* content = (xmlChar*)xmlBufferContent(buf);
	        
	        xmlDocPtr elem = xmlParseDoc(content);
	        
            xmlDocPtr external_format = db_apply_revers_stylesheet(SCHEMA_NAME_OWNER_MESSAGES, elem, NULL);
	        
   	        load_binary_data_to_doc(SCHEMA_NAME_OWNER_MESSAGES, external_format);
   	        doc_list = g_slist_prepend(doc_list, external_format);  
            //xmlFreeDoc(external_format);
   	        xmlFreeDoc(elem);    
   	        xmlFreeNode(node);
	        //xmlFree(content);
            xmlBufferFree(buf);        
        }

        xmlXPathFreeObject(result);	         

    }
    return doc_list;
}




xmlDocPtr get_contacts_filter(const gchar* from, const gchar* to, gint order, gint *quantity) 
{

     xmlDocPtr contacts_list_table = get_table_from_list(SCHEMA_NAME_CONTACTS_LIST);    
    
    *quantity = count_table_records(contacts_list_table);

    gchar** params = g_new(gchar*, 9);
    params[0] = g_strdup(XSLT_PARAM_ALL_NODES);
    params[1] = g_strdup("1");
    params[2] = g_strdup(XSLT_PARAM_POS_FROM);
    params[4] = g_strdup(XSLT_PARAM_POS_TO);
    params[6] = g_strdup(XSLT_PARAM_ORDER);
    params[8] = NULL;       

    if (order == ORDER_DESC) {
        params[7] = g_strdup(XSLT_PARAM_ORDER_DESC);
    } else if (order == ORDER_ASC) {
        params[7] = g_strdup(XSLT_PARAM_ORDER_ASC);
    }

    if (from == NULL || to == NULL) {
        params[3] = g_strdup("0");
        params[5] = g_strdup("10");            
    } else { 
        params[3] = g_strdup(from);
        params[5] = g_strdup(to);
    }
    

    xmlDocPtr external_format = 
        db_apply_revers_stylesheet(SCHEMA_NAME_CONTACTS_LIST_FILTER, 
            contacts_list_table, params);
    g_strfreev(params);

    if (external_format == NULL) {
        return NULL;
    }    

    if (xmlDocGetRootElement(external_format) == NULL) {
        xmlFreeDoc(external_format);
        external_format = NULL;
    }

    return external_format;
}


xmlDocPtr get_online_contacts(gint order) 
{

     xmlDocPtr contacts_list_table = get_table_from_list(SCHEMA_NAME_CONTACTS_LIST);    
    
    gchar** params = g_new(gchar*, 5);
    params[0] = g_strdup(XSLT_PARAM_ONLINE_CONTACS);
    params[1] = g_strdup("1");
    params[2] = g_strdup(XSLT_PARAM_ORDER);
    params[4] = NULL;       

    if (order == ORDER_DESC) {
        params[3] = g_strdup(XSLT_PARAM_ORDER_DESC);
    } else if (order == ORDER_ASC) {
        params[3] = g_strdup(XSLT_PARAM_ORDER_ASC);
    }
    

    xmlDocPtr external_format = 
        db_apply_revers_stylesheet(SCHEMA_NAME_CONTACTS_LIST_FILTER, 
            contacts_list_table, params);
    g_strfreev(params);

    if (external_format == NULL) {
        return NULL;
    }    
    
    if (xmlDocGetRootElement(external_format) == NULL) {
        xmlFreeDoc(external_format);
        external_format = NULL;
    }

    return external_format;
}


xmlDocPtr search_contacts(const gchar* data) 
{

     xmlDocPtr contacts_list_table = get_table_from_list(SCHEMA_NAME_CONTACTS_LIST);    
    
    gchar** params = g_new(gchar*, 3);
    params[0] = g_strdup(XSLT_PARAM_SEARCH_DATA);
    params[1] = g_strconcat("\"", data, "\"", NULL);
    params[2] = NULL;       

    xmlDocPtr external_format = 
        db_apply_revers_stylesheet(SCHEMA_NAME_CONTACTS_LIST_FILTER, 
            contacts_list_table, params);
    g_strfreev(params);

    if (external_format == NULL) {
        return NULL;
    }    
    
    if (xmlDocGetRootElement(external_format) == NULL) {
        xmlFreeDoc(external_format);
        external_format = NULL;
    }

    return external_format;
}





GSList* get_contacts(gboolean with_owner) {

    xmlChar* ns = BAD_CAST cm_get_namespaces_key(SCHEMA_NAME_CONTACTS_LIST);
    xmlDocPtr contacts_list_table = get_table_from_list(SCHEMA_NAME_CONTACTS_LIST);    
    gchar* xpath_req = g_strdup(DB_XPATH_CONTACT_REQ);//build_contacts_xpath(with_owner);

    xmlXPathObjectPtr result = db_get_nodeset(contacts_list_table, BAD_CAST xpath_req, ns);
    
    g_free(ns);
    g_free(xpath_req);

    GSList* doc_list = NULL; 

    if (result != NULL) {
        xmlNodeSetPtr nodeset = result->nodesetval;
		
        gint size = nodeset->nodeNr - 1;

        for(gint i = size; i >= 0; --i) {
                xmlNodePtr node = xmlCopyNode(nodeset->nodeTab[i], 1);
                xmlBufferPtr buf = xmlBufferCreate();
                xmlNodeDump(buf, NULL, node, 0, 1);
	        xmlChar* content = (xmlChar*)xmlBufferContent(buf);
	        
	        xmlDocPtr elem = xmlParseDoc(content);

            xmlDocPtr external_format = db_apply_revers_stylesheet(SCHEMA_NAME_CONTACTS_LIST, elem, NULL);
                //xmlDocDump(stdout, external_format);
                
   	       
   	        load_binary_data_to_doc(SCHEMA_NAME_CONTACTS_LIST, external_format);
   	        doc_list = g_slist_prepend(doc_list, external_format);
   	        
   	        xmlFreeDoc(elem); 
   	        xmlFreeNode(node); 
	        //xmlFree(content);
            xmlBufferFree(buf); 
        }
        
        xmlXPathFreeObject(result);	      
    }

    return doc_list;
}

GSList* get_profiles(gboolean with_owner) {

    g_debug("\n get_profiles start! \n");

    xmlChar* ns = BAD_CAST cm_get_namespaces_key(SCHEMA_NAME_CONTACTS);
    xmlDocPtr contacts_list_table = get_table_from_list(SCHEMA_NAME_CONTACTS);    
    gchar* xpath_req = g_strdup(DB_XPATH_PERSON_REQ);//build_contacts_xpath(with_owner);

    xmlXPathObjectPtr result = db_get_nodeset(contacts_list_table, BAD_CAST xpath_req, ns);

    g_free(ns);
    g_free(xpath_req);

    GSList* doc_list = NULL; 

    if (result != NULL) {
	    xmlNodeSetPtr nodeset = result->nodesetval;
		
        gint size = nodeset->nodeNr - 1;	

        for(gint i = size; i >= 0; --i) {
		    xmlNodePtr node = xmlCopyNode(nodeset->nodeTab[i], 1);
		    xmlBufferPtr buf = xmlBufferCreate();
		    xmlNodeDump(buf, NULL, node, 0, 1);
	        xmlChar* content = (xmlChar*)xmlBufferContent(buf);
	        
	        xmlDocPtr elem = xmlParseDoc(content);

            xmlDocPtr external_format = db_apply_revers_stylesheet(SCHEMA_NAME_CONTACTS, elem, NULL);
	        
   	        ////g_printf("\n\nNODE Afte transform1: ");
   	        load_binary_data_to_doc(SCHEMA_NAME_CONTACTS, external_format);
   	        doc_list = g_slist_prepend(doc_list, external_format);
   	        //xmlFreeDoc(external_format);
   	        xmlFreeDoc(elem);    
   	        xmlFreeNode(node);
	        //xmlFree(content);
            xmlBufferFree(buf);        
        }
        xmlXPathFreeObject(result);	      

    }
    g_debug("\n get_profiles END! \n");
    return doc_list;
}


gint create_or_update_contact(xmlDocPtr contact, gchar* outer_id)
{

    gchar *id = g_strconcat("\"", outer_id, "\"", NULL);
    db_remove_node_by_id(SCHEMA_NAME_CONTACTS_LIST, id);
    
    gchar** params = g_new(gchar*, 3);    
    params[0] = g_strdup("ID");
    params[1] = g_strdup(id);
    params[2] = NULL;       

    db_add_data_to_db_with_id(SCHEMA_NAME_CONTACTS_LIST, contact, (const gchar**)params);
    g_free(id);
    g_strfreev(params);            
    
    return 0;
}


gint create_or_update_profile(xmlDocPtr contact, gchar* outer_id)
{

    gchar* id = g_strconcat("\"", outer_id, "\"", NULL);
    db_remove_node_by_id(SCHEMA_NAME_CONTACTS, id);
    
    gchar** params = g_new(gchar*, 3);    
    params[0] = g_strdup("ID");
    params[1] = g_strdup(id);
    params[2] = NULL;       

    db_add_data_to_db_with_id(SCHEMA_NAME_CONTACTS, contact, (const gchar**)params);
    g_free(id);
    g_strfreev(params);            
    
    return 0;
}


gint create_or_update_message(xmlDocPtr message, gchar* outer_id)
{
    gchar *id = g_strconcat("\"", outer_id, "\"", NULL);
    db_remove_node_by_id(SCHEMA_NAME_MESSAGES, id);

    gchar** params = g_new(gchar*, 3);    
    params[0] = g_strdup("ID");
    params[1] = g_strdup(id);
    params[2] = NULL;       

    db_add_data_to_db_with_id(SCHEMA_NAME_MESSAGES, message, (const gchar**)params);
    
    g_free(id);
    g_strfreev(params);            
    return 0;
}

gint create_or_update_owner_message(xmlDocPtr message, gchar* outer_id)
{
    gchar *id = g_strconcat("\"", outer_id, "\"", NULL);

    db_remove_node_by_id(SCHEMA_NAME_OWNER_MESSAGES, id);
    
    gchar** params = g_new(gchar*, 3);    
    params[0] = g_strdup("ID");
    params[1] = g_strdup(id);
    params[2] = NULL;       

    db_add_data_to_db_with_id(SCHEMA_NAME_OWNER_MESSAGES, message, (const gchar**)params);
    
    g_free(id);
    g_strfreev(params);            
    
    return 0;
}




GSList* db_get_profile(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list = db_get_node_by_id(SCHEMA_NAME_CONTACTS, tmp_id);
    g_free(tmp_id);
    return list;
}


GSList* db_get_message(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list = db_get_node_by_id(SCHEMA_NAME_MESSAGES, tmp_id);
    g_free(tmp_id);
    return list;
}

GSList* db_get_owner_message(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list = db_get_node_by_id(SCHEMA_NAME_OWNER_MESSAGES, tmp_id);
    g_free(tmp_id);
    return list;
}


GSList* db_get_contact(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list = db_get_node_by_id(SCHEMA_NAME_CONTACTS_LIST, tmp_id);
    g_free(tmp_id);
    return list;
}


GSList* db_get_owner_metacontact(gchar* id)
{
    gchar* tmp_id = g_strconcat("\"", id, "\"", NULL);
    GSList* list =  db_get_node_by_id(METACONTACTS_SCHEMA_NAME, tmp_id);
    g_free(tmp_id);
    return list;
}

GSList* db_get_owner_contacts(gchar* id)
{
    return db_get_node_by_id(METACONTACTS_SCHEMA_NAME, id);
}

gchar* get_binary_data_content(const gchar* binary_id) 
{
    return db_get_binary_data_content(binary_id);
}

gboolean set_binary_data_content(const gchar* binary_id, const gchar* content)
{
    return db_set_binary_data_content(binary_id, content);
}

