/*
 * driver.h - interface of jabber driver.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - Alexander A. Lomov.
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with <program name>; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */

#ifndef _DRIVER_H
#define	_DRIVER_H

#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <glib-2.0/glib.h>
#include <glib-2.0/glib/gprintf.h>
#include <gconf/gconf-client.h>
#include "../../msa_module.h"
#include "jabber.h"

#include <libxml/tree.h>
#include <libxml/parser.h>
#include <libxml/xpath.h>
#include <libxml/xmlstring.h>




#ifdef	__cplusplus
extern "C" {
#endif

#include "converter.h"

//#define NORMAL_PROXY      // Using then normal proxy exists.
#define DEBUG_PROXY_HOST ""
#define DEBUG_PROXY_PORT 0

//TODO: move to .c file and add static or remove (remove - best way).
gchar* proxy_host;
gint proxy_port;

gint msa_driver_init(msa_module* module_setup);
gint driver_send(xmlDocPtr request, xmlDocPtr* response, msa_driver_info* info);    
    
#ifdef	__cplusplus
}
#endif

#endif	/* _DRIVER_H */

