<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    xmlns:rel="http://purl.org/vocab/relationship/"
    xmlns:foaf="http://xmlns.com/foaf/0.1/"
    xmlns:sonet="http://cs.karelia.ru/social_network/"
    version="1.0">

    <xsl:output method="xml" indent="yes"  encoding="UTF-8"/>

    <xsl:param name="ID"></xsl:param>
    <xsl:template match="content" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
                xmlns:sonet="http://cs.karelia.ru/social_network/">
       <rdf:RDF  xmlns:foaf="http://xmlns.com/foaf/0.1/">

            <foaf:Group>
                <xsl:attribute name="rdf:nodeID">
                    <xsl:if test="$nodeID > 0">
                        <xsl:value-of select="$nodeID" />
                    </xsl:if>
                    <xsl:if test="not($nodeID > 0)">
                        <xsl:text></xsl:text>
                    </xsl:if>
                </xsl:attribute>
                
                <xsl:apply-templates select="Group"/>

        	</foaf:Group>
	
      </rdf:RDF>
  </xsl:template>


  <xsl:template match="Group">
     <foaf:name>
         <xsl:value-of select="name" />
    </foaf:name>
    
   
    <sonet:rating>
        <xsl:if test="rating >= 0">
            <xsl:value-of select="rating" />
        </xsl:if>
        <xsl:if test="not(rating >= 0)">
            <xsl:text>0</xsl:text>
        </xsl:if>
    </sonet:rating>
    
    <sonet:color>
         <xsl:value-of select="color" />
    </sonet:color>
    
    <xsl:apply-templates select="member"/>

  </xsl:template>
  
    <xsl:template match="member">
        <foaf:member>
            <xsl:attribute name="rdf:ID">
                <xsl:value-of select="$ID"/>
            </xsl:attribute>
        </foaf:member>    
    </xsl:template>  
  
</xsl:stylesheet>
