/*
 * kernel.h - interface for kernel
 * This file is part of MAS program
 *
 * Copyright (C) 2009 - Alexander A. Lomov
 *
 * MAS program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MAS program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MAS program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
  // $id$

#ifndef _KERNEL_H_
#define _KERNEL_H_

#include "general.h"
#include "dispatcher.h"
#include "repository.h"
#include "handler.h"

gint kernel_initialization();
gint kernel_put_data(xmlDocPtr data);
gint kernel_put_text_data(xmlChar* data);
void kernel_shutdown();
//FIXME 
gint kernel_ext_put_text_data(xmlDocPtr request, xmlDocPtr* response);


#define KERNEL_DEBUG_LEVEL 3
#define KERNEL_DEBUG_ON
#ifdef KERNEL_DEBUG_ON
#define KERNEL_DEBUG(level) if (level <= KERNEL_DEBUG_LEVEL) g_debug
//#define KERNEL_PDEBUG(level, message, params) if (level <= KERNEL_DEBUG_LEVEL) g_debug(message,params);
#else
#define KERNEL_DEBUG(level) //
//#define KERNEL_DEBUG
//#define KERNEL_PDEBUG
#endif 

#define KERNEL_MESSAGE_LEVEL 5
#define KERNEL_MESSAGE_ON
#ifdef KERNEL_MESSAGE_ON
#define KERNEL_MESSAGE(level) if (level <= KERNEL_MESSAGE_LEVEL) g_message
#else
#define KERNEL_MESSAGE(level) //
#endif 

#define KERNEL_ERROR_LEVEL 0
#define KERNEL_ERROR_ON
#ifdef KERNEL_ERROR_ON
#define KERNEL_ERROR(level) if (level <= KERNEL_ERROR_LEVEL) g_error
#else
#define KERNEL_ERROR(level) //
#endif 


#endif /* _KERNEL_H_ */

