/*
 * db_msa_logic.h - interface fo msa db logic.
 * This file is part of DB-Maemo.
 *
 * Copyright (C) 2009 - Alexander A. Lomov
 *
 * DB-Maemo is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * DB-Maemo is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with DB-Maemo; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */
 
#ifndef __DB_MSA_LOGIC_H__
#define __DB_MSA_LOGIC_H__
 
gint create_owner_metacontact(xmlDocPtr doc);
gint create_owner_contacts(xmlDocPtr doc);
GSList* db_get_owner_metacontact(gchar* id);
GSList* db_get_owner_contacts(gchar* id);


GSList* db_get_owner_profile();
GSList* get_contacts(gboolean with_owner);
GSList* get_profiles(gboolean with_owner);
GSList* get_messages();
GSList* get_owner_messages();

gint create_or_update_profile(xmlDocPtr contact, gchar* outer_id);
gint create_or_update_contact(xmlDocPtr contact, gchar* outer_id);
gint create_or_update_owner_message(xmlDocPtr message, gchar* outer_id);
gint create_or_update_message(xmlDocPtr message, gchar* outer_id);

GSList* db_get_contact(gchar* id);
GSList* db_get_profile(gchar* id);
GSList* db_get_message(gchar* id);
GSList* db_get_owner_message(gchar* id);
 
gchar* get_binary_data_content(const gchar* binary_id);
gboolean set_binary_data_content(const gchar* binary_id, const gchar* content);

 
#endif /* __DB_MSA_LOGIC_H__ */
 
