/*
 * ui_init.c - UI of MSA program.
 * This file is part of MSA program.
 *
 * Copyright (C) 2009 - 2010 - Andrey Bogachev
 *
 * MSA program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * MSA program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with MSA program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor,
 * Boston, MA  02110-1301  USA
 */
 
#include "ui_general.h"

/**
 * @brief user interface initialization
 * @param
 * @return  
**/
void ui_init()
{
    /* program and window */    
    ui_data->program = HILDON_PROGRAM(hildon_program_get_instance());
    ui_data->window = HILDON_WINDOW(hildon_stackable_window_new());    
    gtk_window_set_title(GTK_WINDOW(ui_data->window), STR_PROG);
    g_signal_connect(G_OBJECT(ui_data->window), "destroy", G_CALLBACK(callback_exit), NULL);    
    HeFullscreenButton* fullscreenbutton = he_fullscreen_button_new(GTK_WINDOW(ui_data->window));
    ui_data->ui_request = NULL;    
    ui_init_tasks();
    ui_init_menu();    
    gtk_widget_show(GTK_WIDGET(ui_data->window));
}

/**
 * @brief init tasks
 * @param  
 * @return  
**/
static void ui_init_tasks()
{
    GtkWidget* img[4];
    GtkWidget* box[4];
    char* strings[20];
    int i;
    GtkWidget* label;
    img[0] = gtk_image_new_from_file(IMG_PRFL);
    img[1] = gtk_image_new_from_file(IMG_FRND);
    img[2] = gtk_image_new_from_file(IMG_MSSG);
    img[3] = gtk_image_new_from_file(IMG_SETS);    
    //FIXME replace notebook
    ui_data->tasks = gtk_notebook_new();
    //gtk_notebook_set_show_border(GTK_NOTEBOOK(ui_data->tasks), FALSE);
    gtk_container_add(GTK_CONTAINER(ui_data->window), ui_data->tasks);
    gtk_notebook_set_tab_pos(GTK_NOTEBOOK(ui_data->tasks), GTK_POS_LEFT);
    for (i = 0; i < 4; i++) {
        ui_data->taskboxes[i] = gtk_vbox_new(FALSE, 0);
        gtk_notebook_append_page(GTK_NOTEBOOK(ui_data->tasks), ui_data->taskboxes[i], img[i]);
    }
    i = 0;    
    /* PROFILE */ 
    ui_data->box_profile = gtk_hbox_new(FALSE, 0);
    GtkWidget* box_prfl = gtk_hbox_new(TRUE, 0);

// !!!
//    GtkWidget* box_service = gtk_hbox_new(FALSE, 0);
    GtkWidget* button_prfl_1 = GTK_WIDGET(ui_init_button_service());
    GtkWidget* button_prfl_2 = GTK_WIDGET(hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT, NULL, STR_UPDT, NULL));
    GtkWidget* button_prfl_3 = GTK_WIDGET(hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT, NULL, STR_SAVE, NULL));
    hildon_button_set_image(button_prfl_2, gtk_image_new_from_icon_name("general_refresh", GTK_ICON_SIZE_BUTTON));
    hildon_button_set_image(button_prfl_3, gtk_image_new_from_icon_name("widgets_tickmark_list", GTK_ICON_SIZE_BUTTON));
    gtk_box_pack_start(GTK_BOX(ui_data->taskboxes[0]), ui_data->box_profile, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ui_data->taskboxes[0]), box_prfl, FALSE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_prfl), button_prfl_1, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_prfl), button_prfl_2, TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(box_prfl), button_prfl_3, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(button_prfl_2), "clicked", G_CALLBACK(callback_button_profile_update), NULL);
    g_signal_connect(G_OBJECT(button_prfl_3), "clicked", G_CALLBACK(callback_button_profile_save), NULL);    
    /* FRIENDS */
    GtkWidget* box_friends_list = gtk_vbox_new(FALSE, 0);
    GtkWidget* box_friends_tool = gtk_hbox_new(FALSE, 0);
    ui_data->box_friends_list = gtk_vbox_new(TRUE, 0);
    ui_data->box_friends = gtk_hbox_new(FALSE, 0);    
    ui_data->box_friend = gtk_vbox_new(FALSE, 0);    
    gtk_box_pack_start(GTK_BOX(box_friends_list), ui_data->box_friends_list, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_friends_list), gtk_hseparator_new(), FALSE, FALSE, 0);    
    gtk_box_pack_start(GTK_BOX(ui_data->taskboxes[1]), ui_data->box_friends, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends), box_friends_list, TRUE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX(box_friends_list), box_friends_tool, FALSE, TRUE, 0);
    ui_data->page_frds = 0;
    ui_data->ascending = FALSE;
    ui_data->friends_offline = FALSE;      
    /* FRIENDS NAVIGATION */
    ui_data->box_friends_navi = gtk_hbox_new(FALSE, 0);
    GtkWidget* box_friends_show_offl = gtk_vbox_new(FALSE, 0);
    ui_data->label_friends_page = gtk_label_new(STR_EMPT);
    ui_data->button_friends_show_offl = GTK_WIDGET(hildon_gtk_toggle_button_new(HILDON_SIZE_FINGER_HEIGHT)); 
    gtk_toggle_button_set_active(GTK_BUTTON(ui_data->button_friends_show_offl), !ui_data->friends_offline);
    ui_data->button_friends_page_prev = GTK_WIDGET(hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL));
    ui_data->button_friends_page_next = GTK_WIDGET(hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL));
    ui_data->button_friends_page_frst = GTK_WIDGET(hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL));
    ui_data->button_friends_page_last = GTK_WIDGET(hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL));    
    gtk_button_set_relief(GTK_BUTTON(ui_data->button_friends_page_prev), GTK_RELIEF_NONE);
    gtk_button_set_relief(GTK_BUTTON(ui_data->button_friends_page_next), GTK_RELIEF_NONE);
    gtk_button_set_relief(GTK_BUTTON(ui_data->button_friends_page_frst), GTK_RELIEF_NONE);
    gtk_button_set_relief(GTK_BUTTON(ui_data->button_friends_page_last), GTK_RELIEF_NONE);
    gtk_button_set_label (GTK_BUTTON(ui_data->button_friends_show_offl), STR_SHOW);
    //hildon_button_set_image(ui_data->button_friends_page_prev, gtk_image_new_from_stock(GTK_STOCK_GO_BACK, GTK_ICON_SIZE_SMALL_TOOLBAR));
    hildon_button_set_image(ui_data->button_friends_page_prev, gtk_image_new_from_file(IMG_PREV));
    hildon_button_set_image(ui_data->button_friends_page_next, gtk_image_new_from_file(IMG_NEXT));
    hildon_button_set_image(ui_data->button_friends_page_frst, gtk_image_new_from_file(IMG_FRST));
    hildon_button_set_image(ui_data->button_friends_page_last, gtk_image_new_from_file(IMG_LAST));
    //hildon_button_set_image(ui_data->button_friends_page_prev, gtk_image_new_from_icon_name("general_back", GTK_ICON_SIZE_SMALL_TOOLBAR));
    //hildon_button_set_image(ui_data->button_friends_page_next, gtk_image_new_from_icon_name("general_forward", GTK_ICON_SIZE_SMALL_TOOLBAR));
    //hildon_button_set_image(ui_data->button_friends_page_frst, gtk_image_new_from_icon_name("gtk_stock_goto_first", GTK_ICON_SIZE_SMALL_TOOLBAR));
    //hildon_button_set_image(ui_data->button_friends_page_last, gtk_image_new_from_icon_name("pdf_viewer_last_page", GTK_ICON_SIZE_SMALL_TOOLBAR));
    gtk_box_pack_start(GTK_BOX(box_friends_show_offl), ui_data->button_friends_show_offl, TRUE, TRUE, 0); 
    gtk_box_pack_start(GTK_BOX(box_friends_tool), box_friends_show_offl, TRUE, TRUE, 0); 
    gtk_box_pack_start(GTK_BOX(box_friends_tool), ui_data->box_friends_navi, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_navi), ui_data->button_friends_page_frst, FALSE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_navi), ui_data->button_friends_page_prev, FALSE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_navi), ui_data->label_friends_page, TRUE, TRUE, 0); 
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_navi), ui_data->button_friends_page_next, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_navi), ui_data->button_friends_page_last, FALSE, FALSE, 0);    
    g_signal_connect(G_OBJECT(ui_data->button_friends_page_prev), "clicked", G_CALLBACK(callback_button_friends_page_prev), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_friends_page_next), "clicked", G_CALLBACK(callback_button_friends_page_next), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_friends_page_frst), "clicked", G_CALLBACK(callback_button_friends_page_frst), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_friends_page_last), "clicked", G_CALLBACK(callback_button_friends_page_last), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_friends_show_offl), "clicked", G_CALLBACK(callback_button_friends_show_offline), NULL);
    /* FRIENDS FILTER */
    ui_data->box_friends_result = gtk_hbox_new(FALSE, PADDING);
    ui_data->label_friends_filter = gtk_label_new(NULL);
    //gtk_misc_set_alignment(GTK_MISC(ui_data->label_friends_filter), 1, 0.5);
    //gtk_label_set_line_wrap(GTK_LABEL(ui_data->label_friends_filter), FALSE);
    //gtk_label_set_single_line_mode(GTK_LABEL(ui_data->label_friends_filter), TRUE);
    
    GtkWidget* button_friends_result = GTK_WIDGET(hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL));
    gtk_button_set_relief(GTK_BUTTON(button_friends_result), GTK_RELIEF_NONE);
    g_signal_connect(G_OBJECT(button_friends_result), "clicked", G_CALLBACK(callback_button_friends_result), NULL);
    gtk_button_set_image(button_friends_result, gtk_image_new_from_icon_name("general_close", GTK_ICON_SIZE_BUTTON));
    //gtk_container_add(GTK_CONTAINER(button_friends_result), gtk_image_new_from_file(IMG_CLER));
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_result), ui_data->label_friends_filter, TRUE, TRUE, 0); 
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends_result), button_friends_result, FALSE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(box_friends_list), ui_data->box_friends_result, FALSE, TRUE, 0);
    /* FRIENDS TASKS */
    GtkWidget* box_friends_tasks = gtk_vbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(ui_data->box_friends), box_friends_tasks, FALSE, TRUE, 0);
    GtkWidget* button_friends_find = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL));
    GtkWidget* button_friends_refr = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL));
    GtkWidget* button_friends_sort = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL));
    GtkWidget* button_friends_addf = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL));
    gtk_widget_set_sensitive(GTK_WIDGET(button_friends_addf), FALSE);
    GtkWidget* box_friends_find = gtk_hbox_new(TRUE, 0);    
    GtkWidget* box_friends_refr = gtk_hbox_new(TRUE, 0);
    GtkWidget* box_friends_sort = gtk_hbox_new(TRUE, 0);
    GtkWidget* box_friends_addf = gtk_hbox_new(TRUE, 0);    
    gtk_box_pack_start(GTK_BOX(box_friends_find), gtk_image_new_from_file(IMG_FIND), TRUE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(box_friends_refr), gtk_image_new_from_file(IMG_REFR), TRUE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(box_friends_sort), gtk_image_new_from_file(IMG_SORT), TRUE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(box_friends_addf), gtk_image_new_from_file(IMG_ADDF), TRUE, FALSE, 0);    
    gtk_container_add(GTK_CONTAINER(button_friends_find), box_friends_find);
    gtk_container_add(GTK_CONTAINER(button_friends_refr), box_friends_refr);
    gtk_container_add(GTK_CONTAINER(button_friends_sort), box_friends_sort);
    gtk_container_add(GTK_CONTAINER(button_friends_addf), box_friends_addf);    
    gtk_box_pack_start(GTK_BOX(box_friends_tasks), button_friends_find, TRUE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(box_friends_tasks), button_friends_refr, TRUE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(box_friends_tasks), button_friends_sort, TRUE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(box_friends_tasks), button_friends_addf, TRUE, FALSE, 0);    
    g_signal_connect(G_OBJECT(button_friends_find), "clicked", G_CALLBACK(callback_button_friends_find), NULL);
    g_signal_connect(G_OBJECT(button_friends_refr), "clicked", G_CALLBACK(callback_button_friends_update), NULL);
    g_signal_connect(G_OBJECT(button_friends_sort), "clicked", G_CALLBACK(callback_button_friends_sort), NULL);
    /* MESSAGES */
    GtkWidget* box_msgs = gtk_hbox_new(FALSE, 0);
    GtkWidget* box_msgs_tasks = gtk_vbox_new(TRUE, 0);
    GtkWidget* box_msgs_list = gtk_vbox_new(FALSE, 0);
    GtkWidget* button_msgs_find = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL)); 
    GtkWidget* button_msgs_refr = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL));
    GtkWidget* button_msgs_comp = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL));
    GtkWidget* button_msgs_from = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL));
    ui_data->box_messages_list = gtk_vbox_new(TRUE, 0);
    ui_data->box_messages = box_msgs;
    ui_data->msgs_box = INBOX;
    ui_data->page_msgs = 0;
    ui_data->empty_messages = TRUE;
    gtk_widget_set_sensitive(GTK_WIDGET(button_msgs_find), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(button_msgs_comp), FALSE);
    gtk_widget_set_sensitive(GTK_WIDGET(button_msgs_from), FALSE);    
    gtk_container_add(GTK_CONTAINER(button_msgs_find), gtk_image_new_from_file(IMG_FIND));
    gtk_container_add(GTK_CONTAINER(button_msgs_refr), gtk_image_new_from_file(IMG_REFR));
    gtk_container_add(GTK_CONTAINER(button_msgs_comp), gtk_image_new_from_file(IMG_COMP));
    gtk_container_add(GTK_CONTAINER(button_msgs_from), gtk_image_new_from_file(IMG_FROM));
    gtk_box_pack_start(GTK_BOX(box_msgs_tasks), button_msgs_find, TRUE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(box_msgs_tasks), button_msgs_refr, TRUE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(box_msgs_tasks), button_msgs_comp, TRUE, FALSE, 0); 
    gtk_box_pack_start(GTK_BOX(box_msgs_tasks), button_msgs_from, TRUE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(box_msgs), box_msgs_list, TRUE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX(box_msgs), box_msgs_tasks, FALSE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (ui_data->taskboxes[2]), ui_data->box_messages, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_msgs_list), GTK_WIDGET(ui_data->box_messages_list), TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(button_msgs_refr), "clicked", G_CALLBACK(callback_button_messages_update), NULL);
    /* MESSAGES NAVIGATION */
    GtkWidget* box_msgs_navi = gtk_hbox_new(TRUE, 0);
    GtkWidget* box_msgs_type = gtk_hbox_new(TRUE, 0);
    GtkWidget* box_msgs_page = gtk_hbox_new(FALSE, 0);
    GtkWidget* rb1 = GTK_WIDGET(hildon_gtk_radio_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL));
    GtkWidget* rb2 = GTK_WIDGET(hildon_gtk_radio_button_new_from_widget(HILDON_SIZE_FINGER_HEIGHT, GTK_RADIO_BUTTON(rb1)));
    GtkWidget* rb3 = GTK_WIDGET(hildon_gtk_radio_button_new_from_widget(HILDON_SIZE_FINGER_HEIGHT, GTK_RADIO_BUTTON(rb1)));
    //gtk_button_set_label(GTK_BUTTON(rb1), _(STR_INCM));
    gtk_button_set_image(rb1, gtk_image_new_from_icon_name("email_inbox", GTK_ICON_SIZE_BUTTON));
    gtk_button_set_image(rb2, gtk_image_new_from_icon_name("general_outbox", GTK_ICON_SIZE_BUTTON));
    gtk_button_set_image(rb3, gtk_image_new_from_icon_name("chat_failed_sms", GTK_ICON_SIZE_BUTTON));
    //gtk_button_set_label(GTK_BUTTON(rb2), _(STR_SENT));
    gtk_box_pack_start(GTK_BOX(box_msgs_type), GTK_WIDGET(rb1), TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_msgs_type), GTK_WIDGET(rb2), TRUE, TRUE, 0);
    gtk_box_pack_end(GTK_BOX(box_msgs_type), GTK_WIDGET(rb3), TRUE, TRUE, 0);
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(rb1), FALSE);
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(rb2), FALSE); 
    gtk_toggle_button_set_mode(GTK_TOGGLE_BUTTON(rb3), FALSE);    
    ui_data->button_messages_page_prev = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    ui_data->button_messages_page_next = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    gtk_button_set_relief(GTK_WIDGET(ui_data->button_messages_page_prev), GTK_RELIEF_NONE);
    gtk_button_set_relief(GTK_WIDGET(ui_data->button_messages_page_next), GTK_RELIEF_NONE);
    ui_data->label_messages_page = gtk_label_new(STR_EMPT);
    //hildon_button_set_image(ui_data->button_messages_page_prev, gtk_image_new_from_icon_name("general_back", GTK_ICON_SIZE_SMALL_TOOLBAR));
    //hildon_button_set_image(ui_data->button_messages_page_next, gtk_image_new_from_icon_name("general_forward", GTK_ICON_SIZE_SMALL_TOOLBAR));
    gtk_container_add(GTK_CONTAINER(ui_data->button_messages_page_prev), gtk_image_new_from_file(IMG_PREV));
    gtk_container_add(GTK_CONTAINER(ui_data->button_messages_page_next), gtk_image_new_from_file(IMG_NEXT));
    g_signal_connect(G_OBJECT(rb1), "released", G_CALLBACK(callback_button_msgs), (gpointer)0);
    g_signal_connect(G_OBJECT(rb2), "released", G_CALLBACK(callback_button_msgs), (gpointer)1);
    g_signal_connect(G_OBJECT(ui_data->button_messages_page_prev), "clicked", G_CALLBACK(callback_button_msgs_page_prev), NULL);
    g_signal_connect(G_OBJECT(ui_data->button_messages_page_next), "clicked", G_CALLBACK(callback_button_msgs_page_next), NULL);
    gtk_box_pack_start(GTK_BOX(box_msgs_navi), box_msgs_type, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_msgs_navi), box_msgs_page, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_msgs_page), ui_data->button_messages_page_prev, FALSE, TRUE, PADDING); 
    gtk_box_pack_start(GTK_BOX(box_msgs_page), ui_data->label_messages_page, TRUE, TRUE, 0); 
    gtk_box_pack_start(GTK_BOX(box_msgs_page), ui_data->button_messages_page_next, FALSE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_msgs_list), gtk_hseparator_new(), FALSE, FALSE, 0);  
    gtk_box_pack_start(GTK_BOX(box_msgs_list), box_msgs_navi, FALSE, TRUE, 0);    
    /* SETTINGS */
    GtkWidget* hbox_sets = gtk_hbox_new(FALSE, 0);
    GtkWidget* box_sets = gtk_vbox_new(FALSE, 0);    
    GtkWidget* list_drivers = ui_init_list_drivers();
    GtkWidget* label_services = gtk_label_new(STR_SETP);
    gtk_misc_set_alignment(GTK_MISC(label_services), 0, 0.5);
    gtk_box_pack_start(GTK_BOX(ui_data->taskboxes[3]), hbox_sets, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_sets), box_sets, TRUE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX(box_sets), label_services, FALSE, FALSE, PADDING);
    gtk_box_pack_start(GTK_BOX(box_sets), list_drivers, TRUE, TRUE, 0);    
    gtk_widget_show_all(ui_data->tasks);
    gtk_widget_hide(GTK_WIDGET(ui_data->box_friends_result));
    g_signal_connect(G_OBJECT(ui_data->tasks), "switch-page", G_CALLBACK(callback_task_switch), NULL);
}

/**
 * @brief driver settings
 * @param  
 * @return
**/
void ui_init_driver_settings(gpointer data)
{
    GtkWidget* hbox_auto = gtk_hbox_new(FALSE, 0);
    GtkWidget* vbox_left = gtk_vbox_new(TRUE, 0);
    GtkWidget* vbox_edit = gtk_vbox_new(TRUE, 0);
    GtkWidget* labels[4];
    ui_data->box_setting = gtk_hbox_new(FALSE, 0); 
    int i;
    gtk_box_pack_start (GTK_BOX (ui_data->box_setting), vbox_left, FALSE, TRUE, PADDING);
    gtk_box_pack_start (GTK_BOX (ui_data->box_setting), vbox_edit, TRUE, TRUE, 0);
    labels[0] = gtk_label_new(STR_LOGIN);
    labels[1] = gtk_label_new(STR_PASSWORD);
    labels[2] = gtk_label_new(STR_AUTOUPDATE);
    labels[3] = gtk_label_new(STR_SECONDS);
    gtk_misc_set_alignment(GTK_MISC(labels[0]), 1, 0.5);
    gtk_misc_set_alignment(GTK_MISC(labels[1]), 1, 0.5);
    gtk_misc_set_alignment(GTK_MISC(labels[2]), 1, 0.5);
    gtk_misc_set_alignment(GTK_MISC(labels[3]), 0, 0.5);
    gtk_box_pack_start(GTK_BOX(vbox_left), labels[0], TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox_left), labels[1], TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(vbox_left), labels[2], TRUE, TRUE, 0);   
    ui_data->entry_logn = GTK_WIDGET(hildon_entry_new(NULL));
    ui_data->entry_pass = GTK_WIDGET(hildon_entry_new(NULL));
    gtk_entry_set_visibility(GTK_ENTRY(ui_data->entry_pass), FALSE);
    ui_data->entry_auto = GTK_WIDGET(hildon_number_editor_new(0, TIMEAUTO));    
    //GtkHScale *scale = GTK_HSCALE (hildon_gtk_hscale_new ());
    //GtkAdjustment *adjustment = GTK_ADJUSTMENT (gtk_range_get_adjustment (GTK_RANGE (scale)));
    //g_object_set (adjustment, "step-increment", 1, "lower", 0, NULL);
    //g_object_set (adjustment, "upper", 4, NULL);
    //g_object_set (adjustment, "value", 2, NULL);
    gtk_box_pack_start (GTK_BOX (vbox_edit), ui_data->entry_logn, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox_edit), ui_data->entry_pass, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (vbox_edit), hbox_auto, TRUE, TRUE, 0);
    gtk_box_pack_start (GTK_BOX (hbox_auto), ui_data->entry_auto, FALSE, TRUE, 0); 
    //gtk_box_pack_start (GTK_BOX (hbox[3]), scale, TRUE, TRUE, 0);    
    gtk_box_pack_start (GTK_BOX (hbox_auto), labels[3], TRUE, TRUE, PADDING);
}

/**
 * @brief drivers list init 
**/
static gpointer ui_init_list_drivers()
{
    /* widgets and vars */
    GtkWidget* vbox_services = gtk_vbox_new(FALSE, 0);
    ui_data->box_service = gtk_vbox_new(FALSE, 0);
    GtkWidget* button_setup[ui_data->num_srvs];
    GtkWidget* icon_service[ui_data->num_srvs];
    GtkWidget* separator;
    //char* strings[16];
    int i = 0;
    GList* node;
    msa_module* info;
    /* pannable */
    GtkWidget* panarea = GTK_WIDGET(hildon_pannable_area_new());
	hildon_pannable_area_add_with_viewport (panarea, vbox_services);
    ui_data->list_drvs = panarea;    
    /* LIST ELEMENTS */
    for(node = ui_data->drivers; node != NULL; node = node->next) {
        info = (msa_module*)node->data;
        GtkWidget* label_service = gtk_label_new(info->name);
        if (info->pic == NULL){
            icon_service[i] = gtk_image_new_from_file(IMG_SRVC);
        } else {
            int size;
            guchar* buff = g_base64_decode((gchar*)info->pic, &size);
            GdkPixbufLoader* pbloader;
            pbloader = gdk_pixbuf_loader_new_with_type ("png", NULL);
            gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
            GdkPixbuf *pixbuff = gdk_pixbuf_loader_get_pixbuf(pbloader);
            icon_service[i] = gtk_image_new_from_pixbuf(pixbuff);
	        g_free(buff);
            gdk_pixbuf_loader_close (pbloader, NULL);
            g_object_unref(pixbuff);
        }
        button_setup[i] = GTK_WIDGET(hildon_button_new(HILDON_SIZE_THUMB_HEIGHT, NULL));
        GtkWidget* box_button = gtk_hbox_new(FALSE, 0);        
        gtk_container_add (GTK_CONTAINER(button_setup[i]), box_button);
        gtk_box_pack_start (GTK_BOX (box_button), icon_service[i], FALSE, FALSE, PADDING);
        gtk_box_pack_start (GTK_BOX (box_button), label_service, TRUE, TRUE, 0);
        g_signal_connect(G_OBJECT(button_setup[i]), "clicked", G_CALLBACK(callback_button_setup_service), (gpointer)i);
        gtk_box_pack_start (GTK_BOX (vbox_services), button_setup[i], FALSE, FALSE, 0);
        if (i + 1 != ui_data->num_srvs){
            separator = gtk_hseparator_new();
            gtk_box_pack_start (GTK_BOX(vbox_services), separator, FALSE, FALSE, PADDING);
        }
        i++;
    }    
    return panarea;
}

/**
 * @brief menu initialization
 * @param
 * @return  
**/
static void ui_init_menu()
{
    HildonAppMenu* main_menu = HILDON_APP_MENU(hildon_app_menu_new());
    /* menu items */
    GtkWidget* menu_help = GTK_WIDGET(hildon_button_new(HILDON_SIZE_AUTO, NULL));
    GtkWidget* menu_bout = GTK_WIDGET(hildon_button_new(HILDON_SIZE_AUTO, NULL));
    GtkWidget* menu_exit = GTK_WIDGET(hildon_button_new(HILDON_SIZE_AUTO, NULL));
    GtkWidget* menu_full = GTK_WIDGET(hildon_button_new(HILDON_SIZE_AUTO, NULL));
    /* items' titles */
    hildon_button_set_title(GTK_BUTTON(menu_help), STR_HELP);
    hildon_button_set_title(GTK_BUTTON(menu_full), STR_FULL);
    hildon_button_set_title(GTK_BUTTON(menu_bout), STR_BOUT);
    hildon_button_set_title(GTK_BUTTON(menu_exit), STR_EXIT);
    /* append items */
    hildon_app_menu_append(HILDON_APP_MENU(main_menu), GTK_BUTTON(menu_full));
    hildon_app_menu_append(HILDON_APP_MENU(main_menu), GTK_BUTTON(menu_bout));
    hildon_app_menu_append(HILDON_APP_MENU(main_menu), GTK_BUTTON(menu_help));
    hildon_app_menu_append(HILDON_APP_MENU(main_menu), GTK_BUTTON(menu_exit));
    /* callback functions */
    g_signal_connect_after(G_OBJECT(menu_full), "clicked", G_CALLBACK(callback_full), NULL);
    g_signal_connect_after(G_OBJECT(menu_help), "clicked", G_CALLBACK(callback_help), NULL);
    g_signal_connect_after(G_OBJECT(menu_bout), "clicked", G_CALLBACK(callback_bout), NULL);
    g_signal_connect_after(G_OBJECT(menu_exit), "clicked", G_CALLBACK(callback_exit), NULL);
    /* add menu to window */
    hildon_stackable_window_set_main_menu(HILDON_STACKABLE_WINDOW(ui_data->window), main_menu);
    gtk_widget_show_all(GTK_WIDGET(main_menu));
}

/**
 * @brief help window
**/
void ui_init_help()
{
    /* window */
    GtkWidget* window_help = GTK_WIDGET(hildon_stackable_window_new());
    gtk_window_set_title (GTK_WINDOW (window_help), STR_HELP);
    /* label */
    
    gchar *str = g_strdup_printf(STR_HELPT, VERSION);
    GtkWidget* label = gtk_label_new(str);
    g_free(str);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_label_set_single_line_mode(GTK_LABEL(label), FALSE);
	/* pannable area */
	GtkWidget* panarea = GTK_WIDGET(hildon_pannable_area_new());
	hildon_pannable_area_add_with_viewport (panarea, label);
    gtk_container_add(GTK_CONTAINER((GtkWidget*)window_help), panarea);
   
    gtk_widget_show_all(GTK_WIDGET(window_help));
    return;
}

/**
 * @brief about window
**/
void ui_init_bout()
{
    /* window */
    GtkWidget* window_bout = hildon_stackable_window_new();
    gtk_window_set_title (GTK_WINDOW (window_bout), STR_BOUT);
    /* label */
    gchar *str = g_strdup_printf(STR_ABOUT, VERSION);
    GtkWidget* label = gtk_label_new(str);
    g_free(str);
	gtk_label_set_line_wrap(GTK_LABEL(label), TRUE);
	gtk_label_set_single_line_mode(GTK_LABEL(label), FALSE);
    /* pannable area */
    GtkWidget* panarea;
    panarea = GTK_WIDGET(hildon_pannable_area_new());
    hildon_pannable_area_add_with_viewport (panarea, label);
    gtk_container_add(GTK_CONTAINER((GtkWidget*)window_bout), panarea);    
    gtk_widget_show_all(GTK_WIDGET(window_bout)); 
    return;   
}

/**
 * @brief service chooser button
 * @return picker button
**/
gpointer ui_init_button_service()
{
    GtkWidget* button_srvc = GTK_WIDGET(hildon_picker_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL));
    GtkWidget* selector = GTK_WIDGET(hildon_touch_selector_new_text());
    GtkWidget* icon_service[ui_data->num_srvs];
    GtkWidget* alignment[ui_data->num_srvs];
    GtkWidget* combo = gtk_combo_box_new_text();
    GList* node;
    msa_module* info;
    int i = 0;
    for(node = ui_data->drivers; node != NULL; node = node->next) {
        info = (msa_module*)node->data;
        if (info->pic == NULL){
            icon_service[i] = gtk_image_new_from_file(IMG_SRVC);
        } else {
            int size;
            guchar* buff = g_base64_decode((gchar*)info->pic, &size);
            GdkPixbufLoader* pbloader;
            pbloader = gdk_pixbuf_loader_new_with_type ("png", NULL);
            gdk_pixbuf_loader_write(pbloader, buff, size, NULL);
            g_free(buff);
            GdkPixbuf *pix_orig = gdk_pixbuf_loader_get_pixbuf(pbloader);
            gdk_pixbuf_loader_close (pbloader, NULL);
            int width = gdk_pixbuf_get_width(pix_orig) / 2;
            GdkPixbuf* pixbuff = gdk_pixbuf_scale_simple (pix_orig, width, width, GDK_INTERP_BILINEAR);
            icon_service[i] = gtk_image_new_from_pixbuf(pixbuff);
            g_object_unref(pix_orig);
            g_object_unref(pixbuff);
            if (i == 0) {
                hildon_button_set_image(button_srvc, icon_service[i]);
            }
        }
        hildon_touch_selector_append_text (selector, (gchar*)info->name);
        if (i == 0) {
            hildon_touch_selector_set_active(selector, 0, 0);
        }
        i++;
    }
    hildon_button_set_value(button_srvc, hildon_touch_selector_get_current_text(selector));
    hildon_picker_button_set_selector(button_srvc, selector);
    return button_srvc;
}

/**
 * @brief create widget with friend tools
 * @param
 * @return
**/
gpointer ui_init_friend_tools(gpointer ptr_str_id)
{
    GtkWidget* box = gtk_hbox_new(TRUE, 0);
    GtkWidget* button_srvc = ui_init_button_service();
    GtkWidget* button_updt = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    GtkWidget* button_nmsg = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    GtkWidget* button_join = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    ui_data->button_friend_profile_refresh = button_updt;
    //hildon_button_set_title(button_updt, STR_UPDT);
    hildon_button_set_title(button_join, STR_JOIN);
    //hildon_button_set_title(button_nmsg, STR_NMSG);
    hildon_button_set_image(button_updt, gtk_image_new_from_icon_name("general_refresh", GTK_ICON_SIZE_BUTTON));
    hildon_button_set_image(button_nmsg, gtk_image_new_from_icon_name("general_sms_button", GTK_ICON_SIZE_BUTTON));
    gtk_button_set_relief(GTK_BUTTON(button_updt), GTK_RELIEF_NONE);
    gtk_button_set_relief(GTK_BUTTON(button_nmsg), GTK_RELIEF_NONE);
    gtk_button_set_relief(GTK_BUTTON(button_srvc), GTK_RELIEF_NONE);
    gtk_button_set_relief(GTK_BUTTON(button_join), GTK_RELIEF_NONE);
    gtk_widget_set_sensitive(GTK_WIDGET(button_join), FALSE);
    gtk_box_pack_start(GTK_BOX(box), button_srvc, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box), button_updt, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box), button_nmsg, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box), button_join, TRUE, TRUE, 0);
    g_signal_connect(G_OBJECT(button_updt), "clicked", G_CALLBACK(callback_button_friends_profile_update), ptr_str_id);
    g_signal_connect(G_OBJECT(button_nmsg), "clicked", G_CALLBACK(callback_friend_send_message), ptr_str_id);
    g_signal_connect(G_OBJECT(button_join), "clicked", G_CALLBACK(callback_button_friends_profile_join), ptr_str_id);
    return box;    
}

/**
 * @brief init message reply form
 * @param ptr_msg - message
 * @return gpointer 
**/
gpointer ui_init_message_reply(gpointer ptr_msg)
{
    Message* msg = ptr_msg;
    Friend* friend = struct_friend_create();
    GtkWidget* box = gtk_hbox_new(FALSE, 0);
    GtkWidget* container = gtk_vbox_new(FALSE, 0);
    GtkWidget* box_reply = gtk_vbox_new(FALSE, 0);
    GtkWidget* hbox_header = gtk_hbox_new(FALSE, 0);
    GtkWidget* label_sndr;
    
    if (msg->str_recipient_name == NULL || strcmp(msg->str_recipient_name, "") == 0) {
        label_sndr = gtk_label_new(STR_FROM);
        friend->str_id = msg->str_sender_id;
        friend->str_name = msg->str_sender_name;
    } else {
        label_sndr = gtk_label_new(STR_TO);
        friend->str_id = msg->str_recipient_id;
        friend->str_name = msg->str_recipient_name;
    }
    
    GtkWidget* label_time = gtk_label_new(g_strconcat(msg->str_date, "  ", msg->str_time, NULL));
    GtkWidget* label_text = gtk_label_new(NULL);
    GtkWidget* button_rply = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    GtkWidget* button_send = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    GtkWidget* button_sndr = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, NULL);
    GtkWidget* entry = GTK_WIDGET(hildon_text_view_new());
    GtkWidget* panarea = GTK_WIDGET(hildon_pannable_area_new());
    
    gtk_label_set_markup(GTK_LABEL(label_text), msg->str_text);
    gtk_misc_set_alignment(GTK_MISC(label_time), 1, 0.5);
    gtk_misc_set_alignment(GTK_MISC(label_text), 0, 0);
    gtk_label_set_justify(GTK_LABEL(label_text), GTK_JUSTIFY_FILL);
    gtk_label_set_line_wrap(GTK_LABEL(label_text), TRUE);
    gtk_label_set_single_line_mode(GTK_LABEL(label_text), FALSE);
    gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW(entry), TRUE);
    gtk_text_view_set_editable(GTK_TEXT_VIEW(entry), TRUE);
    gtk_widget_set_name(GTK_WIDGET(entry), friend->str_id);
    if (msg->str_recipient_name == NULL || strcmp(msg->str_recipient_name, "") == 0) {
        hildon_button_set_title(button_rply, STR_RPLY);
    } else {
        hildon_button_set_title(button_rply, STR_1MOR);   
    }
    hildon_button_set_title(button_send, STR_SEND);
    
    hildon_button_set_title(button_sndr, friend->str_name);
    
    gtk_button_set_relief(GTK_BUTTON(button_sndr), GTK_RELIEF_NONE);
    hildon_pannable_area_add_with_viewport (panarea, label_text);
    
    gtk_box_pack_start(GTK_BOX(hbox_header), label_sndr, FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(hbox_header), button_sndr, FALSE, FALSE, PADDING);
    gtk_box_pack_start(GTK_BOX(hbox_header), label_time, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_reply), entry, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_reply), button_send, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(box_reply), button_rply, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(container), hbox_header, FALSE, FALSE, PADDING);
    gtk_box_pack_start(GTK_BOX(container), gtk_hseparator_new(), FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(container), panarea, TRUE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX(container), gtk_hseparator_new(), FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(container), box_reply, FALSE, FALSE, PADDING);
    gtk_box_pack_start(GTK_BOX(box), container, TRUE, TRUE, PADDING);
    
    g_signal_connect(G_OBJECT(button_rply), "clicked", G_CALLBACK(callback_message_show_reply_entry), (gpointer)entry);
    g_signal_connect(G_OBJECT(button_send), "clicked", G_CALLBACK(callback_message_send_reply), (gpointer)entry);
    g_signal_connect(G_OBJECT(button_sndr), "clicked", G_CALLBACK(callback_message_profile), (gpointer)friend);
    
    gtk_widget_show_all(GTK_WIDGET(box));
    gtk_widget_hide(GTK_WIDGET(entry));
    gtk_widget_hide(GTK_WIDGET(button_send));
    return box;
}

/**
 * @brief init friend's profile form
 * @param
 * @return
**/
void ui_init_friend_profile(GtkWidget* container, gpointer ptr_str_id)
{   
    //FIXME
    //if (ui_data->box_friends_profile != NULL){
    //    gtk_widget_destroy(ui_data->box_friends_profile);
    //    ui_data->box_friends_profile = NULL;
    //}
    //if (ui_data->box_friends_profile == NULL)
    ui_data->box_friends_profile = gtk_hbox_new(FALSE, 0);
    GtkWidget* window_frnd = hildon_stackable_window_new();
    GtkWidget* hbox = gtk_hbox_new(FALSE, 0);
    GtkWidget* box_friend = gtk_vbox_new(FALSE, 0);
    GtkWidget* navi = ui_init_friend_tools(ptr_str_id);
    gtk_box_pack_start(GTK_BOX(box_friend), ui_data->box_friends_profile, TRUE, TRUE, PADDING);
    gtk_box_pack_start(GTK_BOX(box_friend), gtk_hseparator_new(), FALSE, FALSE, 0);
    gtk_box_pack_start(GTK_BOX(box_friend), navi, FALSE, FALSE, PADDING);
    gtk_box_pack_start(GTK_BOX(hbox), box_friend, TRUE, TRUE, PADDING);
    gtk_container_add(GTK_CONTAINER((GtkWidget*)window_frnd), hbox);
    gtk_widget_show_all(GTK_WIDGET(window_frnd));
    gtk_window_set_title(GTK_WINDOW(window_frnd), STR_PROG);
    return;
}
