/* 
 * File:   jabber.h
 * Author: legioner
 *
 * Created on 5 Октябрь 2009 г., 1:55
 */

#ifndef _JABBER_H
#define	_JABBER_H


#ifdef	__cplusplus
extern "C" {
#endif

#include <libxml/tree.h>



enum jabber_errors {
    JABBER_SUCCESS = 0,
    JABBER_NO_ERRORS = 0,
    JABBER_ALLREADY_CONNECT,
    JABBER_CONNECT_NOT_OPEN,
    JABBER_CONNECT_NOT_ESTABLISHED,
    JABBER_CANT_AUTH_CONNECT,
    JABBER_CANT_CONNETC

};

#define JABBER_CANT_AUTH_CONNECT_TEXT "Can't authenticate connection."
#define JABBER_CANT_CONNETC_TEXT "Can't connect."


int vk_req(xmlDocPtr reqXml, xmlDocPtr doc);
gboolean is_jabber_connect();

void jabber_init();
gint jabber_shtd();
guint jabber_get_proxy_port();
const gchar* jabber_get_proxy_host();
gint jabber_set_user_context(const gchar* jid, const gchar* password);
gint jabber_set_proxy(const gchar* host, const gint port);
gint jabber_connect();
gint jabber_reconnect();
void jabber_use_proxy(gboolean use);
gchar* jabber_get_jid_with_resource();


xmlChar* jabber_get_own_profile();
xmlChar* jabber_set_own_profile(xmlDocPtr profile_doc);
xmlChar* jabber_get_friends();
xmlChar* jabber_send_message(xmlDocPtr message_doc);

#ifdef	__cplusplus
}
#endif

#endif	/* _JABBER_H */

