#include <QtGui>
#include <QtDBus>
#include <QtWebKit>
#include <QNetworkProxyFactory>

#include <iostream>

#include "mainwindow.h"

using namespace std;

 MainWindow::MainWindow(const QString &url)
 {
     progress = 0;

     QFile file;
     file.setFileName(":/jquery.min.js");
     file.open(QIODevice::ReadOnly);
     jQuery = file.readAll();

     file.close();

//     QNetworkProxyFactory::setUseSystemConfiguration(true);

     view = new QWebView(this);
     view->load(QUrl(url));
     this->url = url;

     connect(view, SIGNAL(loadFinished(bool)), SLOT(adjustLocation()));
     connect(view, SIGNAL(titleChanged(QString)), SLOT(adjustTitle()));
     connect(view, SIGNAL(loadProgress(int)), SLOT(setProgress(int)));
     connect(view, SIGNAL(loadFinished(bool)), SLOT(finishLoading(bool)));
//     connect(view, SIGNAL(loadFinished(bool)), SLOT(highlightAllLinks()));
     

     locationEdit = new QLineEdit(this);
     locationEdit->setSizePolicy(QSizePolicy::Expanding, locationEdit->sizePolicy().verticalPolicy());
     connect(locationEdit, SIGNAL(returnPressed()), SLOT(changeLocation()));

     QToolBar *toolBar = addToolBar(tr("Navigation"));
     toolBar->addWidget(locationEdit);

     setCentralWidget(view);
     setUnifiedTitleAndToolBarOnMac(true);
     locationEdit->setReadOnly(true);
 }

 void MainWindow::adjustLocation()
 {
     locationEdit->setText(view->url().toString());
 }

 void MainWindow::changeLocation()
 {
     QUrl url = QUrl(locationEdit->text());
     view->load(url);
     view->setFocus();
 }

 void MainWindow::adjustTitle()
 {
     if (progress <= 0 || progress >= 100)
         setWindowTitle(view->title());
     else
         setWindowTitle(QString("%1 (%2%)").arg(view->title()).arg(progress));
 }

 void MainWindow::setProgress(int p)
 {
     progress = p;
     adjustTitle();
 }

 void MainWindow::finishLoading(bool)
 {
     progress = 100;
     adjustTitle();

     if (locationEdit->text() != url) {

         QDBusMessage msg = QDBusMessage::createSignal("/AuthManager", "org.lomalan.AuthManager", "message");
         msg << locationEdit->text();

         if (QDBusConnection::sessionBus().send(msg) == false) {
            cout << "\nMessage not send." << endl;
        } else {
            cout << "\nMessage send." << endl;
        }
//        this->close();
    }

     
 }

 void MainWindow::setURL(const QString &url)
{
    view->load(QUrl(url));
    view->reload();
}


void MainWindow::highlightAllLinks()
{

     //QString code = "$('input').each( function () { $(this).val('yellow'); } )"; //"$('a').each( function () { $(this).css('background-color', 'yellow') } )";
     QString code = "$('input:checkbox#alien[name=\"email\"]').each( function () { $(this).attr('checked',true); } );\
$('input:text[name=\"email\"]').each( function () { $(this).val('email_vk@mail.ru'); } );\
$('input:password[name=\"pass\"]').each( function () { $(this).val('email_vk'); } )"; //"$('a').each( function () { $(this).css('background-color', 'yellow') } )";
     //view->page()->mainFrame()->evaluateJavaScript(code);
     //code = "$('input:text[name=\"Login\"]').each( function () { $(this).val('yo'); } )"; //"$('a').each( function () { $(this).css('background-color', 'yellow') } )";
     view->page()->mainFrame()->evaluateJavaScript(jQuery);
     view->page()->mainFrame()->evaluateJavaScript(code);
 }
