#include "utils.h"
Utils::Utils()
{
}

QString Utils::getHomeDir()
{
    QDir dir;
#ifdef HOMEDIR
    QString home(HOMEDIR);
#else
    QString home = dir.homePath() + QString(LOCALDATADIR);
#endif

    return home;
}

QString Utils::getFriendsIconDir(char *serviceName)
{
    return Utils::getFriendsIconDir(QString::fromUtf8(serviceName, -1));
}

QString Utils::getFriendsIconDir(QString serviceName)
{
    QString icon = Utils::getHomeDir() + QString(FRIEND_ICONS_DIR) + QString("/") + serviceName + QString("/");

    return icon;
}

QString Utils::getAlbumsIconDir(char *serviceName)
{
    return Utils::getAlbumsIconDir(QString::fromUtf8(serviceName, -1));
}

QString Utils::getAlbumsIconDir(QString serviceName)
{
    QString icon = Utils::getHomeDir() + QString(ALBUM_ICONS_DIR) + QString("/") + serviceName + QString("/");

    return icon;
}

QString Utils::getPhotoDir(char *serviceName)
{
    return Utils::getPhotoDir(QString::fromUtf8(serviceName, -1));
}

QString Utils::getPhotoDir(QString serviceName)
{
    QString path = QDesktopServices::storageLocation(QDesktopServices::PicturesLocation) + QString("/") + serviceName + QString("/");

    return path;
}

QString Utils::decodeString(QString str)
{
    QDomDocument doc;
    doc.setContent(QString("<string>") + str + QString("</string>"));
    doc.normalize();
    QString ret = doc.documentElement().firstChild().toText().nodeValue();
    return ret;
}

QString Utils::getAccountDir(QString accountId)
{
    return Utils::getHomeDir() + QString("/accounts/") + accountId + QString("/");
}

QString Utils::getDriversDir()
{
    QString path;
#ifdef DATAPREFIX
    path = QString(DATAPREFIX);
#else
    path = QDesktopServices::storageLocation(QDesktopServices::DataLocation);
#endif

    return path + QString(DRIVER_LIBRARY_DIR);
}

bool Utils::RemoveDirectory(QDir &aDir)
{
    bool has_err = false;
    if (aDir.exists())//QDir::NoDotAndDotDot
    {
        QFileInfoList entries = aDir.entryInfoList(QDir::NoDotAndDotDot |
                                                   QDir::Dirs | QDir::Files);
        int count = entries.size();
        for (int idx = 0; ((idx < count) && (false == has_err)); idx++)
        {
            QFileInfo entryInfo = entries[idx];
            QString path = entryInfo.absoluteFilePath();
            if (entryInfo.isDir())
            {
                QDir dir(path);
                has_err = RemoveDirectory(dir);
            }
            else
            {
                QFile file(path);
                if (!file.remove())
                    has_err = true;
            }
        }
        if (!aDir.rmdir(aDir.absolutePath()))
            has_err = true;
    }
    return(has_err);
}

QString Utils::getPhotoListKey(PhotoList photos)
{
    if (photos.length() > 0)
        return QString("photos_%1_%2").arg(photos.at(0).accountId).arg(photos.at(0).albumId);
    else
        return QString("photos");
}

QString Utils::getPhotoListKey(Album album)
{
    return QString("photos_%1_%2").arg(album.accountId).arg(album.albumId);
}
