#include "uisettings.h"
#include "ui_uisettings.h"

UISettings::UISettings(ServiceMgr *sm, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::UISettings)
{
    ui->setupUi(this);
    this->sm = sm;

    AccountList acc = this->sm->getAccounts();
    this->updateAccounts(acc);

    ServiceMgr::ProxyType proxy = (ServiceMgr::ProxyType)this->sm->settings->value(SETTINGS_PROXY).toInt();

    // set proxy settings
    switch (proxy) {
    case ServiceMgr::NoProxy:
        ui->noProxyButton->setChecked(true);
        break;
    case ServiceMgr::SystemProxy:
        ui->systemProxyButton->setChecked(true);
        break;
    case ServiceMgr::UserProxy:
        ui->manualProxyButton->setChecked(true);
        break;
    default:
        qWarning() << "unknown proxy type";
    }

    ui->proxyServerInput->setText(this->sm->settings->value(SETTINGS_PROXYHOST).toString());
    ui->proxyPortInput->setText(this->sm->settings->value(SETTINGS_PROXYPORT).toString());

    connect(this->sm, SIGNAL(updateAccounts(AccountList)), this, SLOT(updateAccounts(AccountList)));
    connect(this->ui->listSettings, SIGNAL(itemSelectionChanged()), this, SLOT(selectAccount()));
}

UISettings::~UISettings()
{
    delete ui;
}

void UISettings::on_buttonBox_accepted() {
    // checkout proxy settings
    if (ui->noProxyButton->isChecked()) {
        this->sm->settings->setValue(SETTINGS_PROXY, ServiceMgr::NoProxy);
    } else {
        if (ui->systemProxyButton->isChecked()) {
            this->sm->settings->setValue(SETTINGS_PROXY, ServiceMgr::SystemProxy);
        } else {
            if (ui->manualProxyButton->isChecked()) {
                this->sm->settings->setValue(SETTINGS_PROXY, ServiceMgr::UserProxy);
                this->sm->settings->setValue(SETTINGS_PROXYHOST, ui->proxyServerInput->text());
                this->sm->settings->setValue(SETTINGS_PROXYPORT, ui->proxyPortInput->text().toInt());
            } else {
                qWarning() << "can't recognize type of proxy";
            }
        }
    }
    this->sm->updateDriverSettings();
    this->sm->settings->sync();
}

void UISettings::on_btnAddNew_clicked() {
    UIAddAccount *drvForm = new UIAddAccount(this->sm, this);
    drvForm->setModal(true);
    drvForm->show();
}

void UISettings::updateAccounts(AccountList acc)
{
    this->ui->listSettings->clear();
    for (int i = 0; i < acc.length(); i++) {
        DriverInfo *info = acc.at(i)->transport->getDriverInfo();
        QString title = acc.at(i)->transport->accountId + tr(" (") + info->name + QString(")\n") +
                        acc.at(i)->getProfile(false).name;
        if (!acc.at(i)->isNetworkEnabled)
            title += tr(" (offline mode)");
        QListWidgetItem *item = new QListWidgetItem(title, this->ui->listSettings);
        QIcon curIcon(acc.at(i)->getProfile(false).icon);
        if (curIcon.isNull())
            item->setIcon(info->icon);
        else
            item->setIcon(curIcon);
        QVariant v;
        v.setValue(acc.at(i));
        item->setData(Qt::UserRole, v);
    }
}

void UISettings::selectAccount()
{
    this->ui->btnRemove->setEnabled(true);
    this->ui->btnReconnect->setEnabled(true);
}

void UISettings::on_btnRemove_clicked()
{
    QList<QListWidgetItem *> selItems = this->ui->listSettings->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Account *>()) {
            Account * fd = v.value<Account *>();
            this->sm->deleteAccount(fd);
        }
    }
}

void UISettings::on_btnReconnect_clicked()
{
    QList<QListWidgetItem *> selItems = this->ui->listSettings->selectedItems();
    for (int i = 0; i < selItems.length(); i++) {
        QVariant v = selItems[i]->data(Qt::UserRole);
        if (v.canConvert<Account *>()) {
            Account * fd = v.value<Account *>();
            fd->isFirstRequest = true;
            fd->getProfile(true);
        }
    }
}

void UISettings::addNewAccount()
{
    this->show();
    this->on_btnAddNew_clicked();
}
