#include "friend.h"

Friend::Friend()
    :QObject(0)
{
}

Friend::Friend(const Friend & src)
    :QObject(src.parent())
{
    Friend::copyData(this, &src);
}

Friend::~Friend()
{
}

void Friend::copyData(Friend *dst, const Friend *src)
{
    dst->accountId = src->accountId;
    dst->icon = src->icon;
    dst->icon_url = src->icon_url;
    dst->id = src->id;
    dst->name = src->name;
    dst->online = src->online;
}

QDomElement Friend::toQDomElement(QDomDocument doc, Friend src) {
    QDomElement ret = doc.createElement(NODE_FRIEND_ROOT);

    // ID
    QDomElement node = doc.createElement(NODE_FRIEND_ID);
    QDomText t = doc.createTextNode(src.id);
    ret.appendChild(node);
    node.appendChild(t);

    // Name
    node = doc.createElement(NODE_FRIEND_NAME);
    t = doc.createTextNode(src.name);
    ret.appendChild(node);
    node.appendChild(t);

    // avatar
    node = doc.createElement(NODE_FRIEND_ICON);
    t = doc.createTextNode(src.icon);
    ret.appendChild(node);
    node.appendChild(t);

    // avatar url
    node = doc.createElement(NODE_FRIEND_ICON_URL);
    t = doc.createTextNode(src.icon_url);
    ret.appendChild(node);
    node.appendChild(t);

    return ret;
}

Friend Friend::fromQDomElement(QDomElement fr, QString accountId) {
    Friend ret = Friend();

    ret.id = fr.elementsByTagName(NODE_FRIEND_ID).at(0).firstChild().toText().data();
    ret.name = fr.elementsByTagName(NODE_FRIEND_NAME).at(0).firstChild().toText().data();
    ret.icon = fr.elementsByTagName(NODE_FRIEND_ICON).at(0).firstChild().toText().data();
    ret.icon_url = fr.elementsByTagName(NODE_FRIEND_ICON_URL).at(0).firstChild().toText().data();
    ret.accountId = accountId;

    return ret;
}

AlbumList Friend::getAlbumList() {
    AlbumList ret;
    QFile file(Utils::getAccountDir(this->accountId) + QString(FILE_ALBUMS_DATA).arg(this->id));
    if (file.open(QIODevice::ReadOnly) == false)
        return ret;

    QDomDocument doc;
    doc.setContent(&file);
    file.close();

    QDomNodeList lst = doc.elementsByTagName(NODE_ALBUM_ROOT);

    qDebug() << "Start load of " << lst.length() << " albums for " << this->id;
    for (uint i = 0; i < lst.length(); i++) {
        ret.append(Album::fromQDomElement(lst.at(i).toElement(), this->accountId, this->id));
    }

    return ret;

}

void Friend::setAlbumList(AlbumList list, QString accountId, QString friendId) {

    if (friendId.isEmpty())
        return;

    // store albums into cache
    QDomDocument out("MyDoc");
    QDomElement profile = out.createElement(NODE_ALBUMS_ROOT);
    out.appendChild(profile);

    for (int i = 0; i < list.length(); i++) {
        profile.appendChild(list[i].toQDomElement(out));
    }

    QDir dir;

    dir.setPath(dir.cleanPath(Utils::getAccountDir(accountId)));
    if (!dir.exists())
        dir.mkpath(dir.absolutePath());

    QFile file(dir.absolutePath() + QString(FILE_ALBUMS_DATA).arg(friendId));
    qDebug() << file.fileName();
    if (file.open(QIODevice::WriteOnly | QIODevice::Text | QIODevice::Truncate) == false) {
        qDebug() << "can't open file: " + file.errorString();
    }
    //file.write(output.toUtf8());
    file.write(out.toByteArray(1));
    file.close();

}

Friend& Friend::operator =(const Friend& src)
                          {
//    Friend *ret = new Friend(src);
//    qDebug() << "operator=(" << src.name << ", " << ret->name;
//    return *ret;
    Friend::copyData(this, &src);

    return *this;
}
