#ifndef VKGALLERY_H
#define VKGALLERY_H

#include <QMainWindow>
#include <QDebug>
#include <QPushButton>
#include <QListWidgetItem>
#include <QList>
#include <QLabel>

#include "hintedit.h"
#include "QProgressIndicator.h"
#include "servicemgr.h"
#include "uisettings.h"
#include "ui_vkgallery.h"
#include "item.h"
#include "qimageviewer.h"

#ifdef Q_WS_MAEMO_5
#include "fullscreenexitbutton.h"
#endif

namespace Ui {
    class VKGallery;
}

class VKGallery : public QMainWindow {
    Q_OBJECT
public:
    VKGallery(QWidget *parent = 0);
    ~VKGallery();

    void hideAll(QLayout *layout);
    void showAll(QLayout *layout);
    void clearEditOwnr();

signals:
    void showSettings(ServiceMgr sm);

protected:
    void changeEvent(QEvent *e);

    void setAlbumHeader();
    void setAlbumHeader(Friend fr);
    void setPhotoHeader();
    void setPhotoHeader(Album al);
    static QString albumItem(Album al);
    static QPixmap albumIcon(Album al);
    static QPixmap photoIcon(Photo al);

private:
    Ui::VKGallery *ui;
    void init();
    void ownrChanged();
    HintEdit *editOwnr;
    QPushButton *buttonEditOwnr;
    QPushButton *buttonRefreshFriends;
    QPushButton *buttonRefreshAlbums;
    QPushButton *buttonRefreshPhotos;
    QPushButton *buttonCloseAlbums;
    QPushButton *buttonClosePhotos;
#ifdef Q_WS_MAEMO_5
    FullScreenExitButton *fullScreenButton;
#endif
    QLabel lablContacts;
    ServiceMgr *sm;
    bool isFriendsUpdate;
    bool isAlbumsUpdate;
    bool isPhotosUpdate;

private slots:
    void on_pushButtonLogout_clicked();
    void on_pushButtonMe_toggled(bool checked);
    void on_editOwnr_textChanged(QString str);
    void on_buttonResetOwnr_clicked();
    void on_actionSettings_toggled();
    void on_actionFull_screen_toggled();

    void ownrSelected(QListWidgetItem *item);
    void albmSelected(QListWidgetItem *item);
    void photoSelected(QListWidgetItem *item);

    void refreshFriends();
    void refreshFriends(bool isNeedUpdate);
    void refreshAlbums();
    void refreshAlbums(bool isNeedUpdate);
    void refreshPhotos();
    void refreshPhotos(bool isNeedUpdate);

    void hidePhotos();
    void hideAlbums();

    void updateListFriends(FriendList list, bool isLastUpdate);
    void updateListAlbums(QString friendId, AlbumList, bool isLastUpdate);
    void updateListPhotos(QString albumId, PhotoList, bool isLastUpdate);
    void updateListAccounts(AccountList);
    void gotErrorMsg(QString errorMsg, VkTransport::Action acc);
};

#endif // VKGALLERY_H
