#ifndef glwidget_h
#define glwidget_h
#include <QGLWidget>
//#include <QtOpenGL>
#include <QDBusInterface>
#include <vector>
#include "model.h"
#include "structures.h"
#include "md2.h"
#include <QTime>

struct sPaikka {
	float x, y,z,s;
};


class GLWidget : public QGLWidget {
	Q_OBJECT


		
		
public:
	GLWidget(QMainWindow *parent=0);
	~GLWidget();
	void newGame();
	int ajankesto;
	bool keskeytetty;	
protected:
	void initializeGL();
	void paintGL();
	void resizeGL(int width, int height);
	void mousePressEvent(QMouseEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);
	void mouseMoveEvent(QMouseEvent *event);
	void keyPressEvent(QKeyEvent *event);
	void keyReleaseEvent(QKeyEvent *event);
	bool event(QEvent *event);
private:
	bool isAlussa;
	QDBusInterface *qDBusInterface;
	QMainWindow *parentti;
	GLfloat *projection;
	MD2Model *md2;
	struct md2_model_t modelfile;
	int keyIndex;
	bool kaasupohjassa;
	bool noukkiminen;
	bool lopussa;
	float speed;
	QTimer *aikaKello;
	QTime time;
	QTimer *timer;
	int frames;
	bool checked;
	float bestlap;
	QPainter painter;
	QDBusInterface *interface;
	void Plane();
	void pauseGame();
	void resumeGame();

	GLuint program;
	QImage qim;
	QImage textImage;
	float xRot, yRot, zRot, xPos, yPos, zPos, suuntaX, suuntaY, aX, aY, aZ, eta;
	float pitch, roll, yax, xax;
	void getOrientation();
	GLuint colorAttr1;
	float s1, s2;
	int pmitta;
	std::list<sPaikka> sienipaikat;
	Model *sieni;
	GLuint *textures, *tbuffers;
    	GLuint vertexAttr1;
    	GLuint vertexAttr2;
    	GLuint textureAttr;
    	GLuint matrixUniform1, gmatrixu, timeUniform, gmatrixu2, nmatrixUniform, rotmUniform;
    	GLuint matrixUniform2;
    	GLuint textureUniform;
	GLuint transUniform1;
	GLuint scaleUniform1;
	int mx;
	int my;
	void paintModel();
	QPushButton *quitButton;
	bool showQuitButton;
	
private slots:
	void paivita();
	void avoidScreensaver();
	void hideGame();
	void displayStateError(const QDBusError &);
	void setDisplayState(const QString&);
	void displayStateChanged(const QDBusMessage &);
	void lisaaAikaa();
public slots:


signals:
	void onClose();
};	

#endif
