#include "model.h"
#include <string>
#include <vector>
#include <sstream>
#include <fstream>
#include <QDebug>
#include <iostream>
#include <QtCore>
#include <QtGui>
#include <QGLWidget>
using namespace std;

std::vector<std::string> &split(const std::string &s, char delim, std::vector<std::string> &elems) {
	std::stringstream ss(s);
	std::string item;
	while(std::getline(ss, item, delim)) {
		elems.push_back(item);
   	}
	return elems;
}


std::vector<std::string> split(const std::string &s, char delim) {
	std::vector<std::string> elems;
	return split(s, delim, elems);
}

template <class T>

bool from_string(T& t,const std::string& s,std::ios_base& (*f)(std::ios_base&)) {
	std::istringstream iss(s);
	return !(iss >> f >> t).fail();
}
		

Model::Model(QString filename, QString textureImage) {
 //Parsi malli ja tee siitävectori
        QFile mfile(filename);
        string line;
	qint64 foo = 5000;
        mfile.open(QIODevice::ReadOnly);
        vector<MyVertex> verteksit;
	vector<MyTexture> texttemp;
	vector<MyVertex> normaalit;
	vector<MyVertex> sotilas;
	vector<MyTexture> tekstureet;	
	vector<MyVertex> normitukset;
	while(!mfile.atEnd()) {
                string buf;
		QString linetemp;
                QByteArray ba = mfile.readLine(foo);
		line = string(ba.constData());
                if(mfile.atEnd())
                        break;
                vector<string> tokens;
                stringstream ss(line);
                while(ss >> buf) {
                        tokens.push_back(buf);
                }
                if(tokens[0].compare("v") == 0) {
                        float mx, my, mz;
                        from_string<float>(mx, tokens[1], dec);
                        from_string<float>(my, tokens[2], dec);
                        from_string<float>(mz, tokens[3], dec);
                        MyVertex temp;
                        temp.x = mx;
                        temp.y = my;
                	temp.z = mz;
                        verteksit.push_back(temp);
                }
		if(tokens[0].compare("vt") == 0) {
			float u, v;
			from_string<float>(u, tokens[1], dec);
			from_string<float>(v, tokens[2], dec);
			MyTexture tmpc;
			tmpc.u = u+0.00000001;
			tmpc.v = v+0.00000001;
			texttemp.push_back(tmpc);
		}
		if(tokens[0].compare("vn") == 0) {
			float nx, ny, nz;
			from_string<float>(nx, tokens[1], dec);
			from_string<float>(ny, tokens[2], dec);
		    	from_string<float>(nz, tokens[3], dec);
			MyVertex normi;
			normi.x = nx;
			normi.y = ny;
			normi.z = nz;
			normaalit.push_back(normi);
		}			
		
                if(tokens[0].compare("f") == 0) {
                        for(int i=1; i<4; i++) {
                                vector<string> luvut = split(tokens[i], '/');
                                int ind;
                                int tex;
				int norm;
				from_string<int>(ind, luvut[0], dec);
                                from_string<int>(tex, luvut[1], dec);
				from_string<int>(norm, luvut[2], dec);
				sotilas.push_back(verteksit[ind-1]);
				textureet.push_back(texttemp[tex-1]);
                        	normitukset.push_back(normaalit[norm-1]);
			}
                }
        }
        mfile.close();
      	
       	tbuffers = new GLuint[2];	
       	Vertex *vpc = new Vertex[sotilas.size()];
	uint *indices = new uint[sotilas.size()];		
	
	for(uint i=0; i< sotilas.size(); i++) {
		vpc[i].x = sotilas[i].x;
		vpc[i].y = sotilas[i].y;
		vpc[i].z = sotilas[i].z;
		vpc[i].u = textureet[i].u;
		vpc[i].v = textureet[i].v;
		vpc[i].nx = normitukset[i].x;
		vpc[i].ny = normitukset[i].y;
		vpc[i].nz = normitukset[i].z;
		indices[i] = i;
	}
	pmitta = sotilas.size();
	
	glGenBuffers(2, &tbuffers[0]);
	glBindBuffer(GL_ARRAY_BUFFER, tbuffers[0]);
	glBufferData(GL_ARRAY_BUFFER, pmitta*sizeof(Vertex), vpc, GL_STATIC_DRAW);
	glBindBuffer(GL_ARRAY_BUFFER, 0);
	
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, tbuffers[1]);
	glBufferData(GL_ELEMENT_ARRAY_BUFFER, pmitta*sizeof(uint), indices, GL_STATIC_DRAW);
	glBindBuffer(GL_ELEMENT_ARRAY_BUFFER, 0);

	
	textures = new GLuint[1];
	QImage buf;
	buf.load(QString(textureImage));
	QImage textImage = QGLWidget::convertToGLFormat(buf);
	glGenTextures(1, &textures[0]);
	glBindTexture(GL_TEXTURE_2D, textures[0]);
	glTexImage2D(GL_TEXTURE_2D, 0, GL_RGBA, textImage.width(), textImage.height(), 0, GL_RGBA, GL_UNSIGNED_BYTE, textImage.bits());
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
	glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
	glBindTexture(GL_TEXTURE_2D, 0);
	free(vpc);
	free(indices);
}

Model::~Model() {
}

void Model::render(GLuint program) {
	glBindTexture(GL_TEXTURE_2D, textures[0]);
      	glBindBuffer(GL_ARRAY_BUFFER, tbuffers[0]);
	glEnableVertexAttribArray(0);
	glEnableVertexAttribArray(1); 
      	glEnableVertexAttribArray(2); 
	glVertexAttribPointer(0, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), ((char *)NULL + (0)));
        glVertexAttribPointer(1, 2, GL_FLOAT, GL_FALSE, sizeof(Vertex), ((char *)NULL + (sizeof(float)*3)));
	glVertexAttribPointer(2, 3, GL_FLOAT, GL_FALSE, sizeof(Vertex), ((char *)NULL + (sizeof(float)*5)));
      	glBindAttribLocation(program, 0, "vertex");
      	glBindAttribLocation(program, 1, "texture");
	glBindAttribLocation(program, 2, "normaali");
	glDrawArrays(GL_TRIANGLES, 0, pmitta);
      	glBindTexture(GL_TEXTURE_2D, 0);
	glBindBuffer(GL_ARRAY_BUFFER, 0);
}

void Model::setPosition(float x, float y, float z) {
}

