#include <QtGui/QApplication>
#include "mainwindow.h"
#include <QtDBus/QtDBus>

int main(int argc, char *argv[])
{

    QApplication a(argc, argv);
    a.setApplicationName("munadi");
    a.setApplicationVersion("0.1");
    a.setOrganizationName("HaqManInc");

    MainWindow w;

#ifdef maemo5

    if (!QDBusConnection::sessionBus().isConnected()) {
        qWarning("Cannot connect to the D-Bus session bus.");
        exit(1);
    }

    if (!QDBusConnection::sessionBus().registerService("org.indt.munadi")) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
            message()));
        exit(2);
    }

    if (!QDBusConnection::sessionBus().registerObject("/org/indt/munadi", &w,
            QDBusConnection::ExportScriptableSlots)) {
        qWarning("%s", qPrintable(QDBusConnection::sessionBus().lastError().
            message()));
        exit(3);
    }

#endif

    w.show();

    return a.exec();
}
