#ifndef ADDCITYDIALOG_H
#define ADDCITYDIALOG_H

#include <QtGui/QDialog>
#include "munadiengine.h"
#include "globals.h"
#define WEBSERVICE_URL "http://tinygeocoder.com/create-api.php?q="

struct City;

namespace Ui {
    class addCityDialog;
}

class addCityDialog : public QDialog {
    Q_OBJECT
public:
    addCityDialog(MunadiEngine * munadiEngine, QWidget *parent = 0);
    ~addCityDialog();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::addCityDialog *m_ui;
    MunadiEngine * munadi;
    QNetworkAccessManager * netManager;
    QString locationInput;
    City foundCity;

    void autoDetectLocation();
    void displayResults(City & city);
    City parseIPLocTools(QByteArray &);

private slots:
    void on_buttonBox_accepted();
    void on_btnProbeWS_clicked();
    void netReplyReceived(QNetworkReply *);

    void on_buttonBox_rejected();
};

#endif // ADDCITYDIALOG_H
