#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import datetime
import time
import uuid
import commands
import sqlite3
import pango
import os

DB_FORMAT = '%Y-%m-%d'
FRAMEWORK_VERSION = '0.2.0'
HOME_PATH = os.path.expanduser("~")
DB_PATH = HOME_PATH + '/.mPIM/mtodos.db'
LAUNCH_UPDATE_DB_ONCE = False

class Database:
        def __init__(self,path=None):
          self.db = None
          self.cursor = None
          if path != None:
            self.path = path
          else:
            self.path = DB_PATH
          try:
            self.db = sqlite3.connect(self.path)
            self.cursor = self.db.cursor()
            global LAUNCH_UPDATE_DB_ONCE
            if LAUNCH_UPDATE_DB_ONCE==False:
              LAUNCH_UPDATE_DB_ONCE=True
              try:
                self._update()
              except StandardError,e:
                print e
          except:
            print 'Database doesn t exist'
            self._create()

        def _create(self):
          #Try to create the folder in case of
          commands.getoutput("mkdir "+HOME_PATH+"/.mPIM/")
          self.db = sqlite3.connect(self.path)
          self.cursor = self.db.cursor()
          self.cursor.execute('CREATE TABLE todos (uuid TEXT PRIMARY KEY, due_datetime DATETIME, description TEXT, status INTEGER, category TEXT)')
          self.db.commit()
          self.cursor.execute('CREATE TABLE db_struct (version TEXT);')
          self.db.commit()
          self.cursor.execute('INSERT INTO db_struct (version) VALUES ("'+FRAMEWORK_VERSION+'");')
          self.db.commit()

        def _update(self):
          self.cursor.execute('SELECT version From db_struct;')
          for version in self.cursor.fetchall():
            v, = version

          if v < '0.0':
            self._create()

          if v < '0.2':
            self.cursor.execute('ALTER TABLE todos ADD category TEXT')
            self.db.commit()

          self.cursor.execute('UPDATE db_struct SET version ="'+FRAMEWORK_VERSION+'";')
          self.db.commit()

        def close(self):
          self.db.close()

class Todo:
        """This class represents one todo"""

        def __init__(self,suuid='',default_due_datetime=datetime.datetime.now(),default_category='None'):

            self.due_datetime = default_due_datetime
            self.description = ''
            self.status = 0
            self.category = default_category
            if self.category=='All':
              self.category='None'

            if suuid=='':
              self.uuid = uuid.uuid4().__str__()
              self.new = True
            else:
              self.uuid = suuid
              self.load_from_db(self.uuid)
              self.new = False

        def load_from_db(self,suuid):
            db = Database(DB_PATH)
            db.cursor.execute('SELECT due_datetime, description, status, category FROM todos where uuid="'+suuid+'"')
            for todo in db.cursor.fetchall():
              if todo[0]!=None:
                self.due_datetime = datetime.datetime.strptime(todo[0],DB_FORMAT)
              #print todo[0]
              self.description = todo[1]
              self.status = int(todo[2])==1
              self.category = todo[3]
#              print todo[2]
#              print int(todo[2]) 
              self.new = False
            db.close()

        def save_to_db(self):
            db = Database(DB_PATH)
            if self.due_datetime == None:
              due_datetime = None
            else:
              due_datetime = datetime.datetime.strftime(self.due_datetime,DB_FORMAT)

            if self.new==True:
              db.cursor.execute('INSERT INTO todos (uuid , due_datetime, description, status,category ) VALUES(?,?,?,?,?);',[self.uuid,due_datetime,self.description ,self.status,self.category])
              db.db.commit()
            else:
              db.cursor.execute('UPDATE todos SET due_datetime=?, description=?, status=?,category=? WHERE uuid=?;',[due_datetime,self.description, self.status,self.category,self.uuid])
              db.db.commit()
            db.close()

        def get_bg_color(self):
          return '#FFFFFF'

        def get_fg_color(self):
            return "#000000"

        def get_style(self):
          if self.status==0:
            return pango.STYLE_NORMAL
          else:
            return pango.STYLE_ITALIC

        def delete_from_db(self):
            db = Database(DB_PATH)
            db.cursor.execute('DELETE FROM todos WHERE uuid ="'+self.uuid + '";')
            db.db.commit()
            db.close()

class TodosList:
        def __init__(self):
            self.todos_list = []
            self.db = Database(DB_PATH)

        def clear(self):
            self.todos_list = []

        def get_all_todos(self,category=None):
            self.clear()
#            db = Database(DB_PATH)

            select = 'SELECT uuid FROM todos  '
            where = ''
            if (category!=None) and (category!='All'):
              where = where + ' WHERE category="'+category+'"'
            query = select + where

            self.db.cursor.execute(query)       
            for uuid in self.db.cursor.fetchall():
              todo = Todo(uuid[0])
              if todo.due_datetime == None:
                due_datetime = datetime.datetime(9999,9,9)
              else:
                due_datetime = todo.due_datetime 
              self.todos_list.append((todo.status,due_datetime,todo.uuid))
#            db.close()

            return self.todos_list

        def get_done_todos(self,category=None):
            self.clear()
#            db = Database(DB_PATH)

            select = 'SELECT uuid FROM todos  '
            where = ' WHERE status="1"'
            if (category!=None) and (category!='All'):
              where = where + ' AND category="'+category+'"'
            query = select + where

            self.db.cursor.execute(query)       
            for uuid in self.db.cursor.fetchall():
              todo = Todo(uuid[0])
              self.todos_list.append((todo.status,todo.due_datetime,todo.uuid))
#            db.close()

            return self.todos_list

        def get_undone_todos(self,category=None):
            self.clear()
#            db = Database(DB_PATH)

            select = 'SELECT uuid FROM todos  '
            where = ' WHERE status="0"'
            if (category!=None) and (category!='All'):
              where = where + ' AND category="'+category+'"'
            query = select + where

            self.db.cursor.execute(query)       
            for uuid in self.db.cursor.fetchall():
              todo = Todo(uuid[0])
              self.todos_list.append((todo.status,todo.due_datetime,todo.uuid))
#            db.close()

            return self.todos_list

        def get_now_todos(self,category=None):
            self.clear()
#            db = Database(DB_PATH)

            today = datetime.datetime.now()
            select = 'SELECT uuid FROM todos  '
            where = ' WHERE status=0 and due_datetime <= "' + today.strftime(DB_FORMAT)+'"'
            if (category!=None) and (category!='All'):
              where = where + ' AND category="'+category+'"'
            query = select + where

            self.db.cursor.execute(query)       
            for uuid in self.db.cursor.fetchall():
              todo = Todo(uuid[0])
              self.todos_list.append((todo.status,todo.due_datetime,todo.uuid))
#            db.close()

            return self.todos_list

        def get_next_todos(self,category=None):
            self.clear()
#            db = Database(DB_PATH)

            today = datetime.datetime.now()
            diff = datetime.timedelta(days=10)

            select = 'SELECT uuid FROM todos  '
            where = ' WHERE status=0 and due_datetime <= "' + (today+diff).strftime(DB_FORMAT)+'" AND due_datetime > "' + today.strftime(DB_FORMAT)+'"'
            if (category!=None) and (category!='All'):
              where = where + ' AND category="'+category+'"'
            query = select + where

            self.db.cursor.execute(query)       
            for uuid in self.db.cursor.fetchall():
              todo = Todo(uuid[0])
              self.todos_list.append((todo.status,todo.due_datetime,todo.uuid))
#            db.close()

            return self.todos_list

        def get_future_todos(self,category=None):
            self.clear()
#            db = Database(DB_PATH)

            today = datetime.datetime.now()
            diff1 = datetime.timedelta(days=31)
            diff2 = datetime.timedelta(days=10)

            select = 'SELECT uuid FROM todos  '
            where = ' WHERE status=0 and due_datetime <= "' + (today+diff1).strftime(DB_FORMAT)+'" and due_datetime > "' + (today+diff2).strftime(DB_FORMAT)+'"'
            if (category!=None) and (category!='All'):
              where = where + ' AND category="'+category+'"'
            query = select + where

            self.db.cursor.execute(query)       
            for uuid in self.db.cursor.fetchall():
              todo = Todo(uuid[0])
              self.todos_list.append((todo.status,todo.due_datetime,todo.uuid))
#            db.close()

            return self.todos_list

        def get_searched_todos(self,text):
            self.clear()
#            db = Database(DB_PATH)

            select = 'SELECT uuid FROM todos  '
            where = ' WHERE description LIKE "%'+text+'%"'
            query = select + where

            self.db.cursor.execute(query)       
            for uuid in self.db.cursor.fetchall():
              todo = Todo(uuid[0])
              self.todos_list.append((todo.status,todo.due_datetime,todo.uuid))
#            db.close()

            return self.todos_list

        def get_categories(self):
            self.clear()
#            db = Database(DB_PATH)
            self.todos_list.append('All')
            query = 'SELECT DISTINCT category FROM todos;'

            self.db.cursor.execute(query)       
            for cat in self.db.cursor.fetchall():
              if cat[0]!=None:
                self.todos_list.append(cat[0])
#            db.close()

            return self.todos_list

        def close(self):
          self.db.close()