#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import os
import threading

import gobject
import gtk
gtk.gdk.threads_init()
import gtk.glade
import datetime
import mtodos_framework
import pango

try:
  import hildon
except ImportError:
  hildon = None

def ask_dialogue(win,message):
  dialog = gtk.MessageDialog(win,
                  gtk.DIALOG_MODAL,
                  gtk.MESSAGE_QUESTION,
                  gtk.BUTTONS_YES_NO,
                  message)
  rc = dialog.run ()
  dialog.destroy ()

  if rc == gtk.RESPONSE_YES:
    return True
  else:
    return False

class mTodos(object):

  __pretty_app_name__ = "mTodos"
  __app_name__ = "mTodos"
  __version__ = "0.2.0"
  __context__ = "net.khertan.mtodos"

  _glade_files = [
#    'ui/mtodos.glade',
    '/usr/lib/mtodos/ui/mtodos.glade',
  ]

  def __init__(self,app,context):
    self._callbackList = None

    for path in mTodos._glade_files:
      if os.path.isfile(path):
        self._widgetTree = gtk.glade.XML(path)
        break
    else:
      #self.display_error_message("Cannot find mcalendar.glade")
#     gtk.main_quit()
      return

    #Get the buffer associated with the number display
    self._window = self._widgetTree.get_widget("MainView")

    global hildon
    self._app = None
    self._isFullScreen = False
    if hildon is not None and self._window is gtk.Window:
      warnings.warn("Hildon installed but glade file not updated to work with hildon", UserWarning, 2)
      hildon = None
    elif hildon is not None:
      self._app = app
      self._context = context
      self._window = hildon.Window()
      self._window.set_border_width(0)
      self._widgetTree.get_widget("VirtualWindow").reparent(self._window)
      self._app.add_window(self._window)
      hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('scrolledwindow2'),True)
      self._window.connect("key-press-event", self._on_key_press)
      self._window.connect("window-state-event", self._on_window_state_change)
    else:
      warnings.warn("No Hildon", UserWarning, 2)

    if hildon is not None:
      self._window.set_title("mTodos")
    else:
      self._window.set_title("%s" % self.__pretty_app_name__)

    self._current_view = 1
    self._previous_view = 1
    # 1-> Now (Today)
    # 2-> Next (10 days)
    # 3-> Future (1 months)
    # 4-> Archive (All)

    self._current_virtual = 1
    self._previous_virtual = 1
    # 1-> View
    # 2-> Edit
    # 3-> DatePicker

    self._current_category = 'All'

    callbackMapping = {
      # View Signal
      "on_bNow_toggled": self._show_now,
      "on_bNext_toggled": self._show_next,
      "on_bFuture_toggled": self._show_future,
#      "on_bArchive_clicked": self._show_archive,
      "on_bAdd_clicked": self._add_todo,
      "on_bEdit_clicked": self._edit_todo,
      "on_bCancel_clicked": self._cancel,
      "on_bValidate_clicked": self._validate,
      "on_bDelete_clicked": self._delete,
      "on_bGetDate_clicked": self._datepicker_open,
      "on_bDatepickerCancel_clicked": self._datepicker_cancel,
      "on_bDatepickerValidate_clicked": self._datepicker_validate,
      "on_bSearch_clicked": self._open_search_diag,
      "on_bSearchCancel_clicked": self._cancel_search_diag,
      "on_bSearchValidate_clicked": self._validate_search_diag,
      "on_bCat_changed":self._bCat_changed,
      "on_tDisplay_row_activated":self._edit_todo
    }
    self._widgetTree.signal_autoconnect(callbackMapping)

    if self._window:
      self._children_color_bg(self._window)
      self._window.connect("delete-event", self._win_closebox)
#      self._window.show()

    self._view_window = self._widgetTree.get_widget("VirtualView")
    self._edit_window = self._widgetTree.get_widget("VirtualEdit")
    self._datepicker_window = self._widgetTree.get_widget("VirtualDatepicker")

    self._now_label = self._widgetTree.get_widget("now_label")
    self._next_label = self._widgetTree.get_widget("next_label")
    self._future_label = self._widgetTree.get_widget("future_label")
    self._archive_label = self._widgetTree.get_widget("archive_label")

    threading.Thread(target=self._idle_setup).start()

  def _delete(self,widget):
    if ask_dialogue(self._window,'Do you really want to delete this task ?')==True:
      self._current_todo.delete_from_db()
      self.refresh()  
      self._update_virtual(1)

  def _edit_todo(self,widget,*args):
    selection = self.todosListTree.get_selection()
    model, selection_iter = selection.get_selected()
    if (selection_iter):
      uuid = self._todosList.get_value(selection_iter, 0)
      self._open_todo(uuid)      

  def _open_search_diag(self,widget):
    self.search_dialog = self._widgetTree.get_widget("dSearchDiag")
    self.search_dialog.run()

  def _cancel_search_diag(self,widget):
    self.search_dialog.hide()

  def _validate_search_diag(self,widget):
    searched_text = self._widgetTree.get_widget("searched_text").get_text()
    self.search_dialog.hide()
    self._search_todoslist_bg(searched_text)

  def refresh(self):
    self._load_todoslist_bg()
#   gtk.gdk.threads_enter()
#    tasks_list =  mtasks_framework.TasksList().get_all_tasks()
#    tasks_list.sort()
#    new_order = range(len(tasks_list))
#    uuid_list = []
#    for task in tasks_list:
#      uuid_list.append(task[3])
#
#    iter = self._tasksList.get_iter_root()
#    index = 0
#    while(iter):
#      new_order[uuid_list.index(self._tasksList.get_value(iter, 0))] = index
#      index = index  + 1
#      iter = self._tasksList.iter_next(iter)
#    self._tasksList.reorder(new_order)
##   gtk.gdk.threads_leave()
#    self._pijama_color()
    print '#TODO'

  def _pijama_color(self):
#    #pijama
    iter = self._todosList.get_iter_root()
    pij = True
    while(iter):
      if pij == True:
        color = '#E5E5FF'
      else:
        color = '#FFFFFF'
      pij = not pij
      self._todosList.set_value(iter, 5, color)
      iter = self._todosList.iter_next(iter)
    self.todosListTree.queue_draw()

#  def _set_low(self,widget):
#    selection = self.tasksListTree.get_selection()
#    model, selection_iter = selection.get_selected()
#    if (selection_iter):
#      uuid = self._tasksList.get_value(selection_iter, 0)
#      task = mtasks_framework.Task(uuid)
#      task.priority = 2
#      self._tasksList.set_value(selection_iter, 3,task.priority)
#      self._tasksList.set_value(selection_iter, 5,task.get_fg_color())
#      task.save_to_db()
#      self.refresh()
#
#  def _set_normal(self,widget):
#    selection = self.tasksListTree.get_selection()
#    model, selection_iter = selection.get_selected()
#    if (selection_iter):
#      uuid = self._tasksList.get_value(selection_iter, 0)
#      task = mtasks_framework.Task(uuid)
#      task.priority = 1
#      self._tasksList.set_value(selection_iter, 3,task.priority)
#      self._tasksList.set_value(selection_iter, 5,task.get_fg_color())
#      task.save_to_db()
#      self.refresh()
#
#  def _set_high(self,widget):
#    selection = self.tasksListTree.get_selection()
#    model, selection_iter = selection.get_selected()
#    if (selection_iter):
#      uuid = self._tasksList.get_value(selection_iter, 0)
#      task = mtasks_framework.Task(uuid)
#      task.priority = 0
#      self._tasksList.set_value(selection_iter, 3,task.priority)
#      self._tasksList.set_value(selection_iter, 5,task.get_fg_color())
#      task.save_to_db()
#      self.refresh()
  def _if_all_false(self,widget):
    if (self._widgetTree.get_widget("bNow").get_active()==False) and (self._widgetTree.get_widget("bNext").get_active()==False) and (self._widgetTree.get_widget("bFuture").get_active()==False):
      widget.set_active(True)

  def _show_now(self,widget):
    print 'now'
    if (self._widgetTree.get_widget("bNow").get_active()==True) :
#    if self._current_view!=1:
      self._update_view(1)
    else:
      self._if_all_false(self._widgetTree.get_widget("bNow"))

  def _show_next(self,widget):
    print 'next'
    if (self._widgetTree.get_widget("bNext").get_active()==True):
      self._update_view(2)
    else:
       self._if_all_false(self._widgetTree.get_widget("bNext"))

  def _show_future(self,widget):
    print 'future'
    if (self._widgetTree.get_widget("bFuture").get_active()==True):
      self._update_view(3)
    else:
      self._if_all_false(self._widgetTree.get_widget("bFuture"))

  def _show_archive(self,widget):
    #if self._widgetTree.get_widget("bArchive").get_active()==True:
    self._current_category='All'
    self._widgetTree.get_widget("bCat").set_active(0)
    self._update_view(4)

  def _cancel(self,widget):
    self._update_virtual(1)

  def _datepicker_cancel(self,widget):
    self._update_virtual(2)

  def _datepicker_open(self,widget):
    self._update_virtual(3)
    date = datetime.datetime.strptime(self._widgetTree.get_widget("todo_duedate").get_text(),'%x')
    print date
    self._widgetTree.get_widget("tCalendar").select_month(date.month -1,date.year)
    self._widgetTree.get_widget("tCalendar").select_day(date.day)
#    self._widgetTree.get_widget("tCalendar").select_year(date.year)

  def _datepicker_validate(self,widget):
    y,m,d = self._widgetTree.get_widget("tCalendar").get_date()
    duedatetime = datetime.datetime(y,m+1,d)
    self._widgetTree.get_widget("todo_duedate").set_text(duedatetime.strftime('%x'))
    self._update_virtual(2)

  def _validate(self,widget):
    self._save_todo()
    self._update_virtual(1)
    self.refresh()
#    self._load_todoslist_bg()

  def _set_category_available(self,widget,isEntry=False):
    gtk.gdk.threads_enter()
    model = gtk.ListStore(str)
    widget.set_model(model)
    if isEntry==True:
      widget.set_text_column(0)
    for cat in mtodos_framework.TodosList().get_categories():
      model.append((str(cat),))
    if isEntry==False:
      widget.set_active(0)
    gtk.gdk.threads_leave()

  def _open_todo(self,uid):
    threading.Thread(target=self._set_category_available,args=[self._widgetTree.get_widget("eCat"),True]).start()
    self._current_todo = mtodos_framework.Todo(uid,default_category=self._current_category)
    self._widgetTree.get_widget("todo_status").set_active(self._current_todo.status)
    self._widgetTree.get_widget("todo_duedate").set_text(self._current_todo.due_datetime.strftime('%x'))
    if self._current_todo.category==None:
      self._current_todo.category='None'
    self._widgetTree.get_widget("eCat").get_child().set_text(self._current_todo.category)
    self._widgetTree.get_widget("todo_description").get_buffer().set_text(self._current_todo.description)
    self._update_virtual(2)

  def _save_todo(self):
    self._current_todo.status = self._widgetTree.get_widget("todo_status").get_active()
    self._current_todo.due_datetime = datetime.datetime.strptime(self._widgetTree.get_widget("todo_duedate").get_text(),'%x')
    start,end = self._widgetTree.get_widget("todo_description").get_buffer().get_bounds()
    self._current_todo.description = self._widgetTree.get_widget("todo_description").get_buffer().get_text(start,end)
    self._current_todo.category = self._widgetTree.get_widget("eCat").get_child().get_text()
    self._current_todo.save_to_db()

  def _add_todo(self,widget):
    self._open_todo('')
    self._update_virtual(2)

#    todo = mtasks_framework.Todo('')
#    todo.description = 'Enter a description'
#    todo.date = datetime.datetime.now()
#    due_datetime = datetime.datetime.strftime(task.date,'%x')
#    todo.due_datetime = datetime.datetime.now()
#    self._edit_todo(todo.uid)
#    self._tasksList_append(self._tasksList,task.uuid,task.status,due_datetime,task.priority,task.description,task.get_fg_color(),task.get_bg_color(),task.get_style())
#    task.save_to_db()
#    self.tasksListTree.queue_draw()

  def _update_virtual(self,virtual):
    self._previous_virtual = self._current_virtual
    self._current_virtual = virtual
    if virtual == 1:
      self._view_window.show()
      self._edit_window.hide()
      self._datepicker_window.hide()
    elif virtual == 2:
      self._view_window.hide()
      self._edit_window.show()
      self._datepicker_window.hide()
    elif virtual == 3:
      self._view_window.hide()
      self._edit_window.hide()
      self._datepicker_window.show()

  def _update_view(self,view):
    self._previous_view = self._current_view
    self._current_view = view

    threading.Thread(target=self._set_category_available,args=[self._widgetTree.get_widget("bCat")]).start()
    if view == 1:
      self._widgetTree.get_widget("bNow").set_active(True)
      self._widgetTree.get_widget("bNext").set_active(False)
      self._widgetTree.get_widget("bFuture").set_active(False)
#      self._widgetTree.get_widget("bArchive").set_active(False)
    elif view == 2:
      self._widgetTree.get_widget("bNow").set_active(False)
      self._widgetTree.get_widget("bNext").set_active(True)
      self._widgetTree.get_widget("bFuture").set_active(False)
#      self._widgetTree.get_widget("bArchive").set_active(False)
    elif view == 3:
      self._widgetTree.get_widget("bNow").set_active(False)
      self._widgetTree.get_widget("bNext").set_active(False)
      self._widgetTree.get_widget("bFuture").set_active(True)
#      self._widgetTree.get_widget("bArchive").set_active(False)
    elif view == 4:
      self._widgetTree.get_widget("bNow").set_active(False)
      self._widgetTree.get_widget("bNext").set_active(False)
      self._widgetTree.get_widget("bFuture").set_active(False)
#      self._widgetTree.get_widget("bArchive").set_active(True)

    self._load_todoslist_bg()

  def _win_closebox(self,widget,data):
    if self._current_virtual == 1:
      print 'oh now !'
      self._window.destroy()
      gtk.main_quit()
      return False
    elif self._current_virtual == 2:
      self._update_virtual(1)
    elif self._current_virtual == 3:
      self._update_virtual(2)    
    return True

  def _children_color_bg(self,widget):
    if (type(widget)!=gtk.Image) and (type(widget)!=gtk.Label) and (type(widget)!=gtk.TreeView) and (type(widget)!=gtk.VSeparator)  and (type(widget)!=gtk.Entry) and (type(widget)!=gtk.CellView) and (type(widget)!=gtk.Calendar):
      widget.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
      widget.modify_bg(gtk.STATE_INSENSITIVE,gtk.gdk.Color(60000,60000,60000))
      for child in widget.get_children():
        self._children_color_bg(child)

  def _idle_setup(self):
    """
    If something can be done after the UI loads, push it here so it's not blocking the UI
    """
    gtk.gdk.threads_enter()

    try:
      import osso
    except ImportError:
      osso = None

    self._osso = None
    if osso is not None:
      self._osso = osso.Context(mTodos.__app_name__, mTodos.__version__, False)
    else:
      warnings.warn("No OSSO", UserWarning, 2)

    self._todosList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_BOOLEAN,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
    self.todosListTree = self._widgetTree.get_widget("tDisplay")
    self.todosListTree.set_grid_lines(False)
    self.todosListTree.set_fixed_height_mode(True)
    self.todosListTree.set_hadjustment(gtk.Adjustment(value=0))
#    self.todosListTree.style.set_property("horizontal-separator",0)
    self.todosListTree.set_model(self._todosList)
#
    checkboxrenderer = gtk.CellRendererToggle()
    checkboxrenderer.set_property('activatable' , True)
    checkboxrenderer.set_property('height' , 50)
    checkboxrenderer.set_property('width' , 50)
    checkboxrenderer.set_property('cell-background-set' , True)
#
    checkboxrenderer.connect("toggled", self.edited_checkbox_cb, (self._todosList, 1))    
    column_status = gtk.TreeViewColumn("Status", checkboxrenderer, active=1)
    column_status.set_spacing(0)
    column_status.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
    column_status.set_fixed_width(60)

    column_status.add_attribute(checkboxrenderer, 'cell-background', 5)
#
    self.todosListTree.append_column(column_status)
#
    datetimetextrenderer = gtk.CellRendererText()
#    datetimetextrenderer.set_property('editable' , True)
    datetimetextrenderer.set_property('background-set' , True)
    datetimetextrenderer.set_property('foreground-set' , True)
    datetimetextrenderer.set_property('wrap-mode' , pango.WRAP_CHAR)
    datetimetextrenderer.set_property('style' , True)
    datetimetextrenderer.set_property('height' , 60)
    datetimetextrenderer.set_property('width' , 120)
#    datetimetextrenderer.connect('edited', self.edited_cell_cb, (self._tasksList, 2))
    column_datetime = gtk.TreeViewColumn("Datetime", datetimetextrenderer, text=2)
    column_datetime.add_attribute(datetimetextrenderer, 'background', 5)
    column_datetime.set_spacing(0)
    column_datetime.set_fixed_width(120)
    column_datetime.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)

    column_datetime.add_attribute(datetimetextrenderer, 'foreground', 4)
    column_datetime.add_attribute(datetimetextrenderer, 'style', 6)
    self.todosListTree.append_column(column_datetime)

    descriptiontextrenderer = gtk.CellRendererText()
#    descriptiontextrenderer.set_property('editable' , True)
    descriptiontextrenderer.set_property('background-set' , True)
    descriptiontextrenderer.set_property('foreground-set' , True)
    descriptiontextrenderer.set_property('wrap-mode' , pango.WRAP_CHAR)
    descriptiontextrenderer.set_property('style' , True)
    descriptiontextrenderer.set_property('height' , 60)
    descriptiontextrenderer.set_property('width' , 350)

#    descriptiontextrenderer.connect('edited', self.edited_cell_cb, (self._tasksList, 4))
    column_description = gtk.TreeViewColumn("Description", descriptiontextrenderer, text=3)
    column_description.set_spacing(0)
    column_description.set_sizing(gtk.TREE_VIEW_COLUMN_FIXED)
    column_description.add_attribute(descriptiontextrenderer, 'background',5)
    column_description.add_attribute(descriptiontextrenderer, 'foreground',4)
    column_description.add_attribute(descriptiontextrenderer, 'style', 6)
    self.todosListTree.append_column(column_description)

    hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('scrolledwindow'),True)

#    import mokoui
#    mokoscroll = mokoui.FingerScroll()
#    for child in self._widgetTree.get_widget('scrolledwindow').get_children():
#      child.reparent(mokoscroll)
#    parent = self._widgetTree.get_widget('scrolledwindow').get_parent()
#    self._widgetTree.get_widget('scrolledwindow').destroy()
#    parent.add(mokoscroll) 
#    mokoscroll.show()

    self._window.show()

    self._widgetTree.get_widget("bNow").set_active(True)
#    self._widgetTree.get_widget("bCat").set_active(0)
    self._todos_loader_process = threading.Thread(target=self._set_label)
    self._todos_loader_process.start()

    gtk.gdk.threads_leave()

    #Menu
    gtk.gdk.threads_enter()
    self.create_menu()
    gtk.gdk.threads_leave()

    return False

  def _on_window_state_change(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
      self._isFullScreen = True
    else:
      self._isFullScreen = False

  def _todosList_append(self,todosList,uuid,status,datetime,description, fg_color,bg_color,style):
    todosList.append((uuid,status==1,datetime,description, fg_color,bg_color,style))

  def _load_todoslist_bg(self):
    #gtk.gdk.threads_enter()
    self._todosList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_BOOLEAN, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
    self.todosListTree.set_model(self._todosList)
    self._todos_loader_process = threading.Thread(target=self._load_todoslist,args=[self._todosList])
    self._todos_loader_process.start()
    self._todos_label_process = threading.Thread(target=self._set_label)
    self._todos_label_process.start()
    #gtk.gdk.threads_leave()

  def _search_todoslist_bg(self,searched_text):
    #gtk.gdk.threads_enter()
    self._todosList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_BOOLEAN, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
    self.todosListTree.set_model(self._todosList)
    self._todos_loader_process = threading.Thread(target=self._search_todoslist,args=[self._todosList,searched_text])
    self._todos_loader_process.start()
    self._todos_label_process = threading.Thread(target=self._set_label)
    self._todos_label_process.start()

  def _set_label(self):
    gtk.gdk.threads_enter()
    todos_list = mtodos_framework.TodosList()
    self._now_label.set_markup('<b>Now</b>\n'+str(len(todos_list.get_now_todos(self._current_category)))+' tasks')
    self._next_label.set_markup('<b>Next</b>\n'+str(len(todos_list.get_next_todos(self._current_category)))+' tasks')
    self._future_label.set_markup('<b>Future</b>\n'+str(len(todos_list.get_future_todos(self._current_category)))+' tasks')
    self._archive_label.set_markup('<b>Archive</b>\n'+str(len(todos_list.get_all_todos(self._current_category)))+' tasks')
    todos_list.close()
    gtk.gdk.threads_leave()

  def _bCat_changed(self,widget):
    model = widget.get_model()
    active = widget.get_active()
    if active < 0:
        return None
    self._current_category = model[active][0]
    self._load_todoslist_bg()

  def _load_todoslist(self,todosList):
    gtk.gdk.threads_enter()
    todosList.clear()
    gtk.gdk.threads_leave()
    if self._current_view == 1:
      todos_uuid_list =  mtodos_framework.TodosList().get_now_todos(self._current_category)
    elif self._current_view == 2:
      todos_uuid_list =  mtodos_framework.TodosList().get_next_todos(self._current_category)
    elif self._current_view == 3:
      todos_uuid_list =  mtodos_framework.TodosList().get_future_todos(self._current_category)
    elif self._current_view == 4:
      todos_uuid_list =  mtodos_framework.TodosList().get_all_todos(self._current_category)
    todos_uuid_list.sort()
    todo = None
    for (todo_status,todo_due_datetime,todo_uuid) in todos_uuid_list:
      if self._todosList != todosList:
        return False
      todo = mtodos_framework.Todo(todo_uuid)
      if todo_due_datetime != None:
        due_datetime = datetime.datetime.strftime(todo_due_datetime,'%x')
      else:
        due_datetime = None
      gtk.gdk.threads_enter()
      self._todosList_append(todosList,todo.uuid,todo.status,due_datetime,todo.description,todo.get_fg_color(),todo.get_bg_color(),todo.get_style())
      gtk.gdk.threads_leave()

    gtk.gdk.threads_enter()
    self._pijama_color()
    gtk.gdk.threads_leave()
    return False

  def _search_todoslist(self,todosList,searched_text):
    gtk.gdk.threads_enter()
    todosList.clear()
    gtk.gdk.threads_leave()
    todos_uuid_list =  mtodos_framework.TodosList().get_searched_todos(searched_text)
    todos_uuid_list.sort()
    todo = None
    for (todo_status,todo_due_datetime,todo_uuid) in todos_uuid_list:
      if self._todosList != todosList:
        return False
      todo = mtodos_framework.Todo(todo_uuid)
      if todo.due_datetime != None:
        due_datetime = datetime.datetime.strftime(todo_due_datetime,'%x')
      else:
        due_datetime = None
      gtk.gdk.threads_enter()
      self._todosList_append(todosList,todo.uuid,todo.status,due_datetime,todo.description,todo.get_fg_color(),todo.get_bg_color(),todo.get_style())
      gtk.gdk.threads_leave()

    gtk.gdk.threads_enter()
    self._pijama_color()
    gtk.gdk.threads_leave()
    return False

  def edited_checkbox_cb(self,cell, path, user_data):
    liststore, column = user_data
    liststore = self._todosList
    liststore[path][column] = not liststore[path][column]

    todo = mtodos_framework.Todo(liststore[path][0])
    if column == 1:
      todo.status = int(liststore[path][1])
    todo.save_to_db()
    liststore[path][6] = todo.get_style()
#    self.refresh()

    return

  def edited_cell_cb(self,cell, path, new_text, user_data):
#      liststore, column = user_data
#      liststore[path][column] = new_text
#
#      task = mtasks_framework.Task(liststore[path][0])
#      if column == 4:
#        task.description = liststore[path][4]
#      elif column == 2:
#        task.due_datetime = datetime.datetime.strptime(liststore[path][2],'%x')
#      task.save_to_db()
#      self.refresh()
#      return
    print '#TODO'

  def purge_done(self,widget,*data):
#    mtasks_framework
#    tasks_uuid_list =  mtasks_framework.TasksList().get_done_tasks()
#    task = None
#    for (task_status,task_due_datetime,task_priority,task_uuid) in tasks_uuid_list:
#      task = mtasks_framework.Task(task_uuid)
#      task.delete_from_db()
#    self._load_taskslist_bg()
    print '#TODO'

  def create_menu(self):
    self.menubar = gtk.Menu ()

    self._window.set_menu(self.menubar)
    accel_group = gtk.AccelGroup ()
    self._window.add_accel_group (accel_group)

    #Search
    item = gtk.ImageMenuItem (gtk.STOCK_SELECT_ALL, accel_group)
    item.get_child().set_text('Show all')
    item.connect ("activate", self._show_archive)
    item.show ()
    self.menubar.append (item)

    #Search
    item = gtk.ImageMenuItem (gtk.STOCK_FIND, accel_group)
    item.get_child().set_text('Search')
    item.connect ("activate", self._open_search_diag)
    item.show ()
    self.menubar.append (item)

    #Separator
    item = gtk.SeparatorMenuItem ()
    item.show ()
    self.menubar.append (item)

    #Purge
    item = gtk.ImageMenuItem (gtk.STOCK_DELETE, accel_group)
    item.get_child().set_text('Purge Todos done')
    item.connect ("activate", self.purge_done)
    item.show ()
    self.menubar.append (item)

    #Separator
    item = gtk.SeparatorMenuItem ()
    item.show ()
    self.menubar.append (item)

    #About
    item = gtk.ImageMenuItem (gtk.STOCK_ABOUT, accel_group)
    item.connect ("activate", self.onAbout)
    item.show ()
    self.menubar.append (item)

  def _on_key_press(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.keyval == gtk.keysyms.F6:
      if self._isFullScreen:
        self._window.unfullscreen()
      else:
        self._window.fullscreen()

  def onAbout(self, widget):
    dialog = gtk.AboutDialog()
    dialog.set_name(self.__pretty_app_name__)
    dialog.set_logo_icon_name('mtodos')
    dialog.set_authors(("Benoit HERVIER (Khertan)","","Thanks to :","",""))
    dialog.set_comments('a PIM Todos for Maemo')
    dialog.set_version(self.__version__)
    dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
    dialog.set_copyright("By Benoit HERVIER (aka Khertan)")
    dialog.set_website("http://khertan.net/")
    dialog.connect ("response", lambda d, r: d.destroy())
    dialog.show()

def run_mtodos(app,context):
  gtk.gdk.threads_init()
  if hildon is not None:
    gtk.set_application_name(mTodos.__pretty_app_name__)
  handle = mTodos(app,context)
  gtk.main()

if __name__ == "__main__":
  run_mtodos(hildon.Program(),None)
