/*
	mStatus
	
	maemo statusbar plugin to update all your social network status through Ping.fm
	
	"This product uses the Ping.fm API but is not endorsed or certified by Ping.fm."
	
	@author	Daniele Maio (b0unc3) 
	@date	22/01/2010
	@ver	1.0
	
*/

#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <glib/gerror.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <string.h>
#include <osso-log.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>

#include "mstatus.h"

                         
#define MSTATUS_STATUS_MENU_ITEM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, MSTATUS_TYPE_STATUS_MENU_ITEM, MStatusStatusMenuItemPrivate))


struct _MStatusStatusMenuItemPrivate
{
    GtkWidget *label;
    gpointer data;
};

HD_DEFINE_PLUGIN_MODULE (MStatusStatusMenuItem, mstatus_status_menu_item, HD_TYPE_STATUS_MENU_ITEM)

static void
mstatus_status_menu_item_class_finalize (MStatusStatusMenuItemClass *klass) {}

static void
mstatus_status_menu_item_class_init (MStatusStatusMenuItemClass *klass)
{
    g_type_class_add_private (klass, sizeof (MStatusStatusMenuItemPrivate));
}


static gboolean
is_user_ok()
{
	//check if the user is valid
	gchar *contents;
	
	if ( g_file_get_contents (CONF_FILE, &contents, NULL,NULL) ) return verify(g_strdup_printf("%suser.validate",URL_BASE), contents);
	else return FALSE;
	
}


static gboolean
some_page_func (GtkNotebook *nb,
                gint current,
                gpointer userdata)
{
	HildonEntry *kentry;
	switch (current) {
		case 1:
			kentry = HILDON_ENTRY (gtk_notebook_get_nth_page (nb, current));
			return (strlen (hildon_entry_get_text (kentry)) != 0);
		default:
			return TRUE;
	}

}
static gboolean
mstatus_wizard()
{
	/*std for g_spawn*/
        GError  *error = NULL;
        gchar   *out;
        gchar   *err;
        gint    exit;
        gint	res;


	/* settings wizard */
	if ( !g_file_test(CONF_DIR, G_FILE_TEST_IS_DIR) ) { 
	gchar *mk = g_strdup_printf("/bin/mkdir \"%s\"",CONF_DIR);
	if (g_spawn_command_line_sync(mk,&out,&err,&exit,&error) ) {
		if ( strlen(err) > 2 ) {
			hildon_banner_show_information(NULL, NULL, g_strdup_printf("[Error] creating conf directory : %s",error->message));
                        return FALSE;
		}
	} else {
		hildon_banner_show_information(NULL, NULL, "Error during the creation of the conf directory!\n");
		return FALSE;
	}
	}

	GtkWidget *notebook = gtk_notebook_new ();
	GtkWidget *label_1 = gtk_label_new ("To use this software , you need the ping.fm key\nGet it there : http://ping.fm/key/\nCopy the key and paste it in the next entry");GtkWidget *entry_2 = hildon_entry_new (HILDON_SIZE_AUTO);
	hildon_gtk_entry_set_placeholder_text (GTK_ENTRY (entry_2), " Your Ping.fm key");
	GtkWidget *label_3 = gtk_label_new ("All done. Now you can update your status!");
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), label_1, NULL);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), entry_2, NULL);
	gtk_notebook_append_page (GTK_NOTEBOOK (notebook), label_3, NULL);
	GtkWidget *dialog = hildon_wizard_dialog_new (NULL, "mStatus Wizard", GTK_NOTEBOOK (notebook));
	hildon_wizard_dialog_set_forward_page_func (HILDON_WIZARD_DIALOG (dialog), some_page_func, NULL, NULL);

	gtk_widget_show (GTK_WIDGET(label_1));
	gtk_widget_show_all (dialog);
	res = gtk_dialog_run(GTK_DIALOG(dialog));
        if ( res == 2 ) {
        	FILE *f;
        	f = fopen(CONF_FILE, "w");          /* Open conf file to write data */
		fputs((char *)gtk_entry_get_text(GTK_ENTRY(entry_2)), f);
		fclose(f);
		gtk_widget_destroy(dialog);
		return TRUE;
	}

	gtk_widget_destroy(dialog);
	
	return FALSE;

}
static void
mstatus_ui ( GtkWidget *button, gconstpointer user_data G_GNUC_UNUSED)
{
	GtkWidget *toplevel = gtk_widget_get_toplevel(button);
   	gtk_widget_hide (toplevel); 
   	
   	if ( !g_file_test(CONF_FILE,G_FILE_TEST_IS_REGULAR) ) {
		if ( mstatus_wizard() ) {  }
	} else {
		gchar *status;
		gchar *uk;
		g_file_get_contents (CONF_FILE, &uk, NULL,NULL);
		status = get_last_status(g_strdup_printf("%suser.latest",URL_BASE),uk);
		GtkWidget *dialog;
		GtkWidget *box;
		GtkWidget *sentry;
		GtkWidget *cstatus;
		gint response;
		
		dialog = hildon_dialog_new_with_buttons("mStatus: set your status",
							NULL,//GTK_WINDOW(data),
							GTK_DIALOG_MODAL | GTK_DIALOG_NO_SEPARATOR,
							"Reset key",
							GTK_RESPONSE_PROPERTIES,
							GTK_STOCK_REFRESH,
							GTK_RESPONSE_REFRESH,
							NULL);
				
		box = gtk_vbox_new(2,FALSE);
		cstatus = gtk_label_new(g_strdup_printf("Your last status : %s",status));
		sentry = hildon_entry_new(HILDON_SIZE_AUTO);
		gtk_box_pack_start(GTK_BOX(box), cstatus, TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(box), sentry, TRUE,TRUE,0);
		
		if ( !is_user_ok() ) {
			hildon_banner_show_information(NULL, NULL, "Unable to validate user!\nPlease verify your key or your connection.");
			gtk_dialog_set_response_sensitive ( GTK_DIALOG(dialog), GTK_RESPONSE_REFRESH, FALSE);
		}
			
		gtk_container_add ( GTK_CONTAINER(GTK_DIALOG(dialog)->vbox), box);
		
		gtk_widget_show_all ( GTK_WIDGET(dialog) );
		gtk_widget_show_all ( GTK_WIDGET(sentry) );
		response = gtk_dialog_run(GTK_DIALOG(dialog));
		if (response == GTK_RESPONSE_PROPERTIES) {
			system(g_strdup_printf("/bin/rm %s",CONF_FILE));
			system(g_strdup_printf("/bin/rmdir %s", CONF_DIR));
			hildon_banner_show_information(NULL, NULL, "Your old key has been removed!");
			gtk_widget_destroy(GTK_WIDGET(dialog));
			mstatus_wizard();
		} else if ( response == GTK_RESPONSE_REFRESH ) {
			//update status
			if ( post("http://api.ping.fm/v1/user.post",uk,"default",hildon_entry_get_text(HILDON_ENTRY(sentry))) )
				hildon_banner_show_information(NULL, NULL, "Message posted!");
			else
				hildon_banner_show_information(NULL, NULL, "Error! Message not posted!");
		}
				
		gtk_widget_destroy(GTK_WIDGET(dialog));

	}
	
}

static void
mstatus_status_menu_item_init (MStatusStatusMenuItem *plugin)
{
    GtkWidget *b,*img;
    
    plugin->priv = MSTATUS_STATUS_MENU_ITEM_GET_PRIVATE (plugin);

    b = hildon_button_new_with_text (HILDON_SIZE_AUTO_WIDTH | HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL,"mStatus", "update your status!");
    
    img = gtk_image_new_from_file(MSTATUS_ICON);
    gtk_widget_show(img);
    hildon_button_set_image(HILDON_BUTTON(b), img);
    hildon_button_set_alignment (HILDON_BUTTON(b), 0.0, 0.0, 0.0, 0.0);
    gtk_widget_show(b);
    g_signal_connect(b, "clicked", G_CALLBACK(mstatus_ui), plugin);

    gtk_container_add (GTK_CONTAINER (plugin), b);

    gtk_widget_show_all (b);

    gtk_widget_show (GTK_WIDGET (plugin));
}


