#include "settingsdialog.h"
#include "ui_settingsdialog.h"
#include "constants.h"

SettingsDialog::SettingsDialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::SettingsDialog)
{
    ui->setupUi(this);

    connect(ui->defaultButton, SIGNAL(clicked()), this, SLOT(defaultChannelsFeedUrl()));
}

SettingsDialog::~SettingsDialog()
{
    delete ui;
}

void SettingsDialog::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type())
    {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void SettingsDialog::setChannelsFeedUrl(const QString &hello)
{
    ui->feedUrl->setText(hello);
}

QString SettingsDialog::getChannelsFeedUrl() const
{
    return ui->feedUrl->text();
}

void SettingsDialog::defaultChannelsFeedUrl()
{
    ui->feedUrl->setText(CHANNELS_FEED_URL);
}
