#include "qaddcomment.h"
#include "ui_qaddcomment.h"

QAddComment::QAddComment(Photo photo, ServiceMgr *sm, QWidget *parent) :
    QDialog(parent),
    ui(new Ui::QAddComment)
{
    ui->setupUi(this);
    this->sm = sm;
    this->commentedPhoto = photo;
    connect(this->ui->buttonBox, SIGNAL(accepted()), this, SLOT(addComment()));
}

QAddComment::~QAddComment()
{
    delete ui;
}

void QAddComment::changeEvent(QEvent *e)
{
    QDialog::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void QAddComment::addComment()
{
    if (this->sm->sendComment(this->commentedPhoto, ui->text->document()->toPlainText())) {
        this->sm->getComments(this->commentedPhoto, true, true);
        this->close();
    }
}
