#ifndef PROFILEBROWSER_H
#define PROFILEBROWSER_H

/**
  \file profilebrowser.h
  \author MySocials team
  \date 2011-04-01
  */

#include <QWidget>
#include <QPushButton>
#include <QListWidget>

#include "datatypes/friend.h"
#include "servicemgr.h"

namespace Ui {
    class ProfileBrowser;
}

/**
  \brief Profile browser widget.

  Shows profile data.
  */
class ProfileBrowser : public QWidget
{
    Q_OBJECT
public:
    /**
      \brief Default constructor.

      \param showAvatar Add avatar to profile browser widget

      \param parent The pointer to parent widget.
      */
    explicit ProfileBrowser(ServiceMgr *sm, bool showAvatar, QWidget *parent = 0);

    /**
      \brief Contructor with selected profile.

      \param profile The Friend instance with owner data.

      \param showAvatar Add avatar to profile browser widget

      \param parent The pointer to parent widget.

      */
    explicit ProfileBrowser(ServiceMgr *sm, Friend profile, bool showAvatar, QWidget *parent = 0);

    /**
      \brief The destructor.
      */
    ~ProfileBrowser();

public slots:
    /**
      \brief Sets profile data.

      \param profile  The Friend instance with owner data.
      */
    void setProfile(Friend profile);

private:
    void init();

    // shows profile data
    void showProfile(Friend fd);

    // uses to access to list of drivers
    ServiceMgr *sm;

    Ui::ProfileBrowser *ui;

    Friend currentProfile;
    bool showAvatar;

private slots:
    void profileSelected(QListWidgetItem*);
};

#endif // PROFILEBROWSER_H

#if 0
class ProfileBrowser
{
    QT_TR_NOOP("male")
    QT_TR_NOOP("female")

};
#endif
