#ifndef QMESSAGELISTWIDGET_H
#define QMESSAGELISTWIDGET_H

#include <QWidget>
#include <QPushButton>
#include <QModelIndex>
#include <QAction>
#include <QDesktopWidget>

#include <utils/hintedit.h>
#include <servicemgr.h>

#include "widgets/filter/filterpanel.h"
#include "qmessagelistmodel.h"

namespace Ui {
    class QMessageListWidget;
}

class FilterModel;
class QToolBar;
class QMessageListWidget : public QWidget
{
    Q_OBJECT
public:
    explicit QMessageListWidget(QFont uf, ServiceMgr* sm = 0, QWidget *parent = 0);
    ~QMessageListWidget();

    Message getSelectedMessage() const;

    void selectedMessage(const Message &msg);
    QToolBar* filtersToolBar() const;

    void showFriendMessages(Friend fr);
    void setMultipanelEnabled(const bool isMultiPanel);

signals:
    void ownerSelected(Message msg);
    void messageCountChanged(int count);

public slots:
    // occurs when user selects message on list
    void itemSelected(QModelIndex index);

    void updateMessages(MessageList list, bool isLastUpdate);

private:
    Ui::QMessageListWidget *ui;

    ServiceFilter* filter;
    FilterPanel *filterPanel;

    HintEdit *editOwnr;
    QPushButton *buttonEditOwnr;
    ServiceMgr *sm;

    bool isMultiPanel;

    // used model to store list of friends
    QMessageListModel *model;

    // Proxy model
    FilterModel *filterModel;

    // the index of selected item
    QPersistentModelIndex selectedItem;

    QString selectedMsgAccount;

    QString selectedMsgId;

    QToolBar* filtersToolBar_;

private slots:
    void modelLayoutChanged();
    void orientationChanged();
};

#endif // QMESSAGELISTWIDGET_H
