#ifndef SERVICEFILTER_H
#define SERVICEFILTER_H

#include <QWidget>
#include <QList>

class ServiceMgr;
class DriverInfo;
class QButtonGroup;
class QPushButton;
class QToolBar;

class ServiceFilterWidget : public QWidget
{
    Q_OBJECT
    ServiceMgr* m_serviceManager;
    QButtonGroup* m_buttonGroup;
    QList<DriverInfo*> m_drivers;
    QToolBar* m_toolbar;

    void addService(DriverInfo* driverInfo);
    void createToolbar();
public:
    explicit ServiceFilterWidget(ServiceMgr* serviceManager, QWidget *parent = 0);

signals:
    void stateChanged(DriverInfo* driverInfo);

public slots:
    void serviceSelected(QAction* act);
};

#endif // SERVICEFILTER_H
