#include "regionmap.h"

#include <QtCore/QList>
#include <QtCore/QRect>

typedef QPair<QRect, QVariant> RectVariantPair;

class RegionMapData : public QSharedData
{
public:
    QList<RectVariantPair> rectangles;
};

RegionMap::RegionMap()
    : d(new RegionMapData)
{
}

RegionMap::RegionMap(const RegionMap& src)
    : d(src.d)
{
}

RegionMap& RegionMap::operator=(const RegionMap& src)
{
    if (this != &src)
        d = src.d;
    return *this;
}

RegionMap::~RegionMap()
{
}

void RegionMap::addRegion(const QRect& rect, const QVariant& data)
{
    d->rectangles.append(qMakePair(rect, data));
}

QVariant RegionMap::value(const QPoint& p) const
{
    foreach (const RectVariantPair& item, d->rectangles) {
        if (item.first.contains(p))
            return item.second;
    }

    return QVariant();
}

void RegionMap::clear()
{
    d->rectangles.clear();
}


