#ifndef FEEDVIEW_H
#define FEEDVIEW_H

#include <QListView>

#include "datatypes/photo.h"

class QEventFeed;
class FeedView : public QListView
{
    Q_OBJECT

public:
    FeedView(QWidget *parent = 0);

    void mousePressEvent(QMouseEvent *event);
    void scrollTo(const QModelIndex &index, ScrollHint hint);

private:
    void processFeed(const QEventFeed& feed);

signals:
    void linkClicked(QString linkText);
    void imageClicked(Photo photo);
};

#endif // FEEDVIEW_H
