#include "QProgressIndicator.h"

#include <QPainter>

QProgressIndicator::QProgressIndicator(QWidget* parent)
        : QWidget(parent),
        m_angle(0),
        m_timerId(-1),
        m_delay(40)
{
    //setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Fixed);
    setFocusPolicy(Qt::NoFocus);
    setFixedSize(this->sizeHint());
    setMaximumSize(this->sizeHint());
}

void QProgressIndicator::startAnimation()
{
    m_angle = 0;

    if (m_timerId == -1)
        m_timerId = startTimer(m_delay);
}

void QProgressIndicator::stopAnimation()
{
    if (m_timerId != -1)
        killTimer(m_timerId);

    m_timerId = -1;

    update();
}

void QProgressIndicator::setAnimationDelay(int delay)
{
    if (m_timerId != -1)
        killTimer(m_timerId);

    m_delay = delay;

    if (m_timerId != -1)
        m_timerId = startTimer(m_delay);
}

QSize QProgressIndicator::sizeHint() const
{
    return QSize(40,40);
}

int QProgressIndicator::heightForWidth(int w) const
{
    return w;
}

void QProgressIndicator::timerEvent(QTimerEvent *)
{
    m_angle = (m_angle+30)%360;

    update();
}

void QProgressIndicator::paintEvent(QPaintEvent *)
{
    if (m_timerId == -1)
        return;

    int width = qMin(this->width(), this->height());
    
    QPainter p(this);
    //p.fillRect(0,0,width,this->height(),QBrush(QColor::fromRgbF(1.0f, 1.0f, 1.0f, 1.0f)));
    p.setRenderHint(QPainter::Antialiasing);
    
    int outerRadius = (width-1)*0.5;
    int innerRadius = (width-1)*0.5*0.38;

    int capsuleHeight = outerRadius - innerRadius;
    int capsuleWidth  = (width > 32 ) ? capsuleHeight *.23 : capsuleHeight *.35;

    for (int i=0; i<12; i++) {
        QColor color = QColor::fromRgbF(0.2f, 0.7f, 0.9f, 1.0f - (i/12.0f));
        p.setPen(Qt::NoPen);
        p.setBrush(color);       
        p.save();
        p.translate(rect().center());
        p.rotate(m_angle - i*30.0f);
        p.drawRect(-capsuleWidth*0.5, -(innerRadius+capsuleHeight), capsuleWidth, capsuleHeight);
        p.restore();
    }
}
