/**
  \file messagebrowser.h
  \brief MessageBrowser class description
  \author MySocials team
  \date 2011-03-23
  */
#ifndef MESSAGEBROWSER_H
#define MESSAGEBROWSER_H

#include <QWidget>
#include <QLineEdit>
#include <QTextEdit>
#include <QLabel>
#include "datatypes/message.h"
#include "servicemgr.h"

namespace Ui {
    class MessageBrowser;
}

/*!
 \class MessageBrowser
 \brief Widget for showing message data.

 This class is using for showing message data such as subject, recepients, sender
 and message body.

 \see Message
 */
class MessageBrowser : public QWidget
{
    Q_OBJECT
public:

    /*!
     A MessageBrowser constructor.

     \param parent Pointer to parent widget.
     */
    explicit MessageBrowser(QWidget *parent = 0);

    /*!
     \brief A MessageBrowser constructor.

     \param sm Pointer to Service Manages.

     \param parent Pointer to parent widget.
     */
    explicit MessageBrowser(ServiceMgr *sm, QWidget *parent = 0);

    /*!
     A MessageBrowser constructor.

     \param msg Message which is using for filling MessageBrowser fields

     \param parent Pointer to parent widget
     */
    explicit MessageBrowser(Message msg, QWidget *parent);

    //! A destructor.
    ~MessageBrowser();

    /*!
     \brief Sets current message.

     \param msg Message which is using for filling MessageBrowser fields
     */
    void setMessage(Message msg);

    /*!
     \brief Gets title of message.
     */
    QString title();

    /*!
     \brief Gets list of recepients.
     */
    QStringList to();

    /*!
     \brief Gets sender of message.
     */
    QString from();

    /*!
     \brief Gets message body.
     */
    QString message();

    /*!
     \brief Clears all fields of message form.
     */
    void resetMessage();

    void init();

private:
    ServiceMgr *sm;
    Ui::MessageBrowser *ui;

    QTextEdit *textLabel;

    AccountList mAccountList;
    QSet<QString> mLocalAccountIds;

    QLabel* descLabel;

    QLabel* titleLabel;
    QLabel* dateLabel;
    QLabel* fromLabel;
    QLabel* toLabel;
    QLabel* serviceIcon;
    QLineEdit* titleLineEdit;
    QLineEdit* dateLineEdit;
    QLineEdit* fromLineEdit;
    QLineEdit* toLineEdit;

    void hideTo(bool hide);
    void hideFrom(bool hide);

private slots:
    void updateAccountList(QString, AccountList);
};

#endif // MESSAGEBROWSER_H
